/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.datamodel.types.internal;

import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.types.api.ShortTextTD;
import de.rcenvironment.core.datamodel.types.internal.AbstractTypedDatum;
import org.apache.commons.lang3.StringUtils;

public class ShortTextTDImpl
extends AbstractTypedDatum
implements ShortTextTD {
    public static final int MAXIMUM_LENGTH = 140;
    private final String shortText;

    public ShortTextTDImpl(String shortText) {
        super(DataType.ShortText);
        if (shortText.length() > 140) {
            throw new IllegalArgumentException("text exceeds maximum character of 140. it has: " + shortText.length());
        }
        this.shortText = shortText;
    }

    @Override
    public String getShortTextValue() {
        return this.shortText;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof ShortTextTD) {
            ShortTextTD other = (ShortTextTD)obj;
            return this.shortText.equals(other.getShortTextValue());
        }
        return false;
    }

    public int hashCode() {
        return this.shortText.hashCode();
    }

    public String toString() {
        return this.getShortTextValue();
    }

    @Override
    public String toLengthLimitedString(int maxLength) {
        return StringUtils.abbreviate((String)this.getShortTextValue(), (int)maxLength);
    }
}

