/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.datamodel.types.internal;

import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.DataTypeException;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.api.TypedDatumConverter;
import de.rcenvironment.core.datamodel.internal.TypedDatumServiceImpl;
import de.rcenvironment.core.datamodel.types.api.FloatTD;
import de.rcenvironment.core.datamodel.types.api.MatrixTD;
import de.rcenvironment.core.datamodel.types.api.SmallTableTD;
import de.rcenvironment.core.datamodel.types.api.VectorTD;
import de.rcenvironment.core.datamodel.types.internal.AbstractTypedDatum;
import de.rcenvironment.core.datamodel.types.internal.SmallTableTDImpl;
import de.rcenvironment.core.datamodel.types.internal.VectorTDImpl;
import de.rcenvironment.core.utils.common.StringUtils;
import org.apache.commons.logging.LogFactory;

public class MatrixTDImpl
extends AbstractTypedDatum
implements MatrixTD {
    private SmallTableTD table;

    public MatrixTDImpl(FloatTD[][] matrixEntries) {
        super(DataType.Matrix);
        this.table = new SmallTableTDImpl(matrixEntries);
    }

    @Override
    public FloatTD getFloatTDOfElement(int rowIndex, int columnIndex) {
        return (FloatTD)this.table.getTypedDatumOfCell(rowIndex, columnIndex);
    }

    @Override
    public void setFloatTDForElement(FloatTD number, int rowIndex, int columnIndex) {
        this.table.setTypedDatumForCell(number, rowIndex, columnIndex);
    }

    @Override
    public int getRowDimension() {
        return this.table.getRowCount();
    }

    @Override
    public int getColumnDimension() {
        return this.table.getColumnCount();
    }

    @Override
    public MatrixTD getSubMatrix(int endRowIndex, int endColumnIndex) {
        TypedDatumConverter converter = new TypedDatumServiceImpl().getConverter();
        try {
            return converter.castOrConvert((TypedDatum)this.table.getSubTable(endRowIndex, endColumnIndex), MatrixTD.class);
        }
        catch (DataTypeException e) {
            LogFactory.getLog(this.getClass()).error((Object)"conversion failed", (Throwable)e);
            return null;
        }
    }

    @Override
    public MatrixTD getSubMatrix(int beginRowIndex, int beginColumnIndex, int endRowIndex, int endColumnIndex) {
        TypedDatumConverter converter = new TypedDatumServiceImpl().getConverter();
        try {
            return converter.castOrConvert((TypedDatum)this.table.getSubTable(beginRowIndex, beginColumnIndex, endRowIndex, endColumnIndex), MatrixTD.class);
        }
        catch (DataTypeException e) {
            LogFactory.getLog(this.getClass()).error((Object)"conversion failed", (Throwable)e);
            return null;
        }
    }

    @Override
    public VectorTD getColumnVector(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.getColumnDimension()) {
            throw new IllegalArgumentException("index out of range: " + columnIndex);
        }
        FloatTD[][] matrixEntries = this.toArray();
        FloatTD[] vectorEntries = new FloatTD[this.getRowDimension()];
        int i = 0;
        while (i < this.getRowDimension()) {
            vectorEntries[i] = matrixEntries[i][columnIndex];
            ++i;
        }
        return new VectorTDImpl(vectorEntries);
    }

    @Override
    public VectorTD getRowVector(int rowIndex) {
        if (rowIndex < 0 || rowIndex >= this.getRowDimension()) {
            throw new IllegalArgumentException("index out of range: " + rowIndex);
        }
        FloatTD[][] matrixEntries = this.toArray();
        FloatTD[] vectorEntries = new FloatTD[this.getColumnDimension()];
        int i = 0;
        while (i < this.getColumnDimension()) {
            vectorEntries[i] = matrixEntries[rowIndex][i];
            ++i;
        }
        return new VectorTDImpl(vectorEntries);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof MatrixTD) {
            MatrixTD other = (MatrixTD)obj;
            return this.table.equals(new SmallTableTDImpl(other.toArray()));
        }
        return false;
    }

    public int hashCode() {
        return this.table.hashCode();
    }

    @Override
    public FloatTD[][] toArray() {
        TypedDatum[][] tableAsArray = this.table.toArray();
        FloatTD[][] resultArray = new FloatTD[this.getRowDimension()][this.getColumnDimension()];
        int i = 0;
        while (i < this.getRowDimension()) {
            System.arraycopy(tableAsArray[i], 0, resultArray[i], 0, this.getColumnDimension());
            ++i;
        }
        return resultArray;
    }

    @Override
    public String toLengthLimitedString(int maxLength) {
        StringBuilder strBuilder = new StringBuilder("[");
        VectorTD firstRow = this.getRowVector(0);
        FloatTD[] floatTDArray = firstRow.toArray();
        int n = floatTDArray.length;
        int n2 = 0;
        while (n2 < n) {
            FloatTD f = floatTDArray[n2];
            strBuilder.append(f.toString());
            strBuilder.append(",");
            if (strBuilder.length() > maxLength) break;
            ++n2;
        }
        strBuilder.setLength(strBuilder.length() - 1);
        if (strBuilder.length() > maxLength) {
            strBuilder.setLength(maxLength);
            strBuilder.append("...");
        }
        strBuilder.append("]");
        if (this.getRowDimension() > 1) {
            strBuilder.append(",...");
        }
        strBuilder.append(StringUtils.format((String)" (%dx%d)", (Object[])new Object[]{this.getRowDimension(), this.getColumnDimension()}));
        return strBuilder.toString();
    }

    public String toString() {
        StringBuilder strBuilder = new StringBuilder();
        int i = 0;
        while (i < this.getRowDimension()) {
            VectorTD row = this.getRowVector(i);
            FloatTD[] floatTDArray = row.toArray();
            int n = floatTDArray.length;
            int n2 = 0;
            while (n2 < n) {
                FloatTD f = floatTDArray[n2];
                strBuilder.append(f.toString());
                strBuilder.append(", ");
                ++n2;
            }
            strBuilder.setLength(strBuilder.length() - 2);
            strBuilder.append(System.lineSeparator());
            ++i;
        }
        return strBuilder.toString();
    }
}

