/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.cluster.configuration.internal;

import de.rcenvironment.core.gui.cluster.configuration.internal.ClusterConnectionConfiguration;
import de.rcenvironment.core.gui.cluster.configuration.internal.CreateClusterConnectionConfigurationDialog;
import de.rcenvironment.core.gui.cluster.configuration.internal.Messages;
import de.rcenvironment.core.utils.cluster.ClusterQueuingSystem;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditClusterConnectionConfigurationDialog
extends CreateClusterConnectionConfigurationDialog {
    private ClusterConnectionConfiguration configuration;

    public EditClusterConnectionConfigurationDialog(Shell parentShell, List<String> existingConfigurationNames, ClusterConnectionConfiguration configuration) {
        super(parentShell, existingConfigurationNames);
        this.configuration = configuration;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Control control = super.createDialogArea(parent);
        this.prefillForm();
        return control;
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.createButton.setText(Messages.editButtonTitle2);
    }

    @Override
    protected boolean isConfigurationNameValid(String currentConfigurationName) {
        return super.isConfigurationNameValid(this.configuration.getConfigurationName());
    }

    private void prefillForm() {
        if (this.configuration.getClusterQueuingSystem() == ClusterQueuingSystem.TORQUE) {
            this.queuingSystemCombo.select(1);
        }
        this.showqPathText.setEnabled(this.queuingSystemCombo.getSelectionIndex() == 1);
        Map<String, String> paths = this.configuration.getPathToClusterQueuingSystemCommands();
        this.prefillCommandPath("qstat", this.qstatPathText, paths);
        this.prefillCommandPath("qdel", this.qdelPathText, paths);
        this.prefillCommandPath("showq", this.showqPathText, paths);
        this.hostText.setText(this.configuration.getHost());
        this.portText.setText(String.valueOf(this.configuration.getPort()));
        this.usernameText.setText(this.configuration.getUsername());
        if (this.configuration.getPassword() != null) {
            this.passwordText.setText(this.configuration.getPassword());
            this.passwordText.setEnabled(true);
            this.savePasswordCheckbox.setSelection(true);
        }
        this.configurationNameText.setText(this.configuration.getConfigurationName());
        this.configurationNameText.setEnabled(true);
        this.defaultConfigurationNameCheckbox.setSelection(false);
    }

    private void prefillCommandPath(String command, Text pathText, Map<String, String> paths) {
        if (paths.containsKey(command)) {
            pathText.setText(paths.get(command));
        }
    }
}

