/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.common;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.commons.io.input.CountingInputStream;

public class SizeValidatedDataSource {
    protected final long size;
    protected final CountingInputStream dataStream;

    public SizeValidatedDataSource(long size, InputStream dataStream) {
        this.size = size;
        this.dataStream = new CountingInputStream(dataStream);
    }

    public SizeValidatedDataSource(byte[] data) {
        this(data.length, new ByteArrayInputStream(data));
    }

    public long getSize() {
        return this.size;
    }

    public InputStream getStream() {
        return this.dataStream;
    }

    public long getRemaining() {
        return this.size - (long)this.dataStream.getCount();
    }

    public boolean receivedCompletely() {
        return this.dataStream.getByteCount() == this.size;
    }
}

