/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.common;

import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

class BundleAccessor {
    private static final String VERSIONINFO_BUNDLE_NAME = "de.rcenvironment.core.gui.branding.default.versioninfo";
    private static final String PLATFORM_BUNDLES_PREFIX = "de.rcenvironment.platform.";
    private final Class<?> clazz;
    private final Supplier<Bundle> containingBundle;
    private final Supplier<Bundle[]> allBundlesInContext;

    BundleAccessor(Class<?> clazz) {
        this.clazz = clazz;
        this.containingBundle = new CachedSupplier<Bundle>(() -> FrameworkUtil.getBundle((Class)clazz));
        this.allBundlesInContext = new CachedSupplier<Bundle[]>(() -> this.containingBundle.get().getBundleContext().getBundles());
    }

    public Bundle getOwnBundleOrLogDebug() {
        Bundle ownBundle = this.containingBundle.get();
        if (ownBundle == null) {
            this.logDebug("No Bundle available (most likely because we are running in a unit test)");
        }
        return ownBundle;
    }

    public Bundle[] getAllBundlesOrLogError() {
        Bundle ownBundle = this.getOwnBundleOrLogDebug();
        if (ownBundle == null) {
            return new Bundle[0];
        }
        Bundle[] bundles = this.allBundlesInContext.get();
        if (bundles == null) {
            this.logError("Unexpected error: 'null' bundle list while getting bundles in context of bundle " + ownBundle.getSymbolicName());
            return new Bundle[0];
        }
        return bundles;
    }

    public Optional<Bundle> getVersionInfoBundle() {
        Bundle[] bundles = this.getAllBundlesOrLogError();
        return Stream.of(bundles).filter(bundle -> bundle.getSymbolicName().startsWith(VERSIONINFO_BUNDLE_NAME)).findAny();
    }

    public Stream<Bundle> getPlatformBundles() {
        Bundle[] bundles = this.getAllBundlesOrLogError();
        return Stream.of(bundles).filter(bundle -> bundle.getSymbolicName().startsWith(PLATFORM_BUNDLES_PREFIX));
    }

    protected void logDebug(String message) {
        LogFactory.getLog(this.clazz).debug((Object)message);
    }

    protected void logError(String message) {
        LogFactory.getLog(this.clazz).error((Object)message);
    }

    private class CachedSupplier<T>
    implements Supplier<T> {
        private final Supplier<T> supplier;
        private T value = null;

        CachedSupplier(Supplier<T> supplier) {
            this.supplier = supplier;
        }

        @Override
        public T get() {
            if (this.value == null) {
                this.value = this.supplier.get();
            }
            return this.value;
        }
    }
}

