/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.integration;

import de.rcenvironment.core.component.integration.ConfigurationMapMigration;
import de.rcenvironment.core.component.integration.ToolIntegrationConstants;
import de.rcenvironment.core.component.model.configuration.api.ComponentConfigurationModelFactory;
import de.rcenvironment.core.component.model.configuration.api.ConfigurationDefinition;
import de.rcenvironment.core.utils.common.StringUtils;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class ConfigurationMap {
    protected Map<String, Object> rawConfigurationMap;

    public ConfigurationMap(Map<String, Object> rawConfigurationMap) {
        this.rawConfigurationMap = rawConfigurationMap;
    }

    public ConfigurationMap() {
        this(new HashMap<String, Object>());
    }

    public static ConfigurationMap fromMap(Map<String, Object> configurationMap) {
        return new ConfigurationMap(configurationMap);
    }

    public void applyMigration(ConfigurationMapMigration migration) {
        migration.migrate(this.rawConfigurationMap);
    }

    public String getToolName() {
        return (String)this.rawConfigurationMap.getOrDefault("toolName", "");
    }

    public String getToolVersion() {
        return this.getFirstLaunchSettings().get("version");
    }

    public Map<String, String> getFirstLaunchSettings() {
        List<Object> allLaunchSettings = this.checkedListCast(this.rawConfigurationMap.get("launchSettings"));
        return this.checkedMapCast(allLaunchSettings.get(0), String.class, String.class);
    }

    public String getGroupPath() {
        return (String)this.rawConfigurationMap.getOrDefault("groupName", "");
    }

    public List<Map<String, String>> getStaticInputs() {
        return this.checkedListOfMapCast(this.rawConfigurationMap.getOrDefault("inputs", new LinkedList()), String.class, String.class);
    }

    public boolean containsStaticInputs() {
        return this.rawConfigurationMap.containsKey("inputs");
    }

    public boolean containsDynamicInputs() {
        return this.rawConfigurationMap.containsKey("dynamicInputs");
    }

    public List<Map<String, Object>> getDynamicInputs() {
        return this.checkedListOfMapCast(this.rawConfigurationMap.getOrDefault("dynamicInputs", new LinkedList()), String.class, Object.class);
    }

    public List<Map<String, String>> getStaticOutputs() {
        return this.checkedListOfMapCast(this.rawConfigurationMap.getOrDefault("outputs", new LinkedList()), String.class, String.class);
    }

    public List<Map<String, Object>> getDynamicOutputs() {
        return this.checkedListOfMapCast(this.rawConfigurationMap.getOrDefault(ToolIntegrationConstants.KEY_ENDPOINT_DYNAMIC_OUTPUTS, new LinkedList()), String.class, Object.class);
    }

    public String getExecutionCountLimit() {
        Map<String, String> firstLaunchSettings = this.getFirstLaunchSettings();
        String newExecutionCountLimit = firstLaunchSettings.get("limitInstallationInstances");
        if (newExecutionCountLimit != null) {
            return newExecutionCountLimit;
        }
        return firstLaunchSettings.get("limitInstalltionInstances");
    }

    public String getMaxParallelCount() {
        return this.getFirstLaunchSettings().get("limitInstallationInstancesNumber");
    }

    public Optional<Boolean> isActive() {
        return Optional.ofNullable((Boolean)this.rawConfigurationMap.get("isActive"));
    }

    public String getIconPath() {
        return (String)this.rawConfigurationMap.getOrDefault("toolIconPath", "");
    }

    public Long getIconModificationDate() {
        return (Long)this.rawConfigurationMap.get("iconModified");
    }

    public String getIconHash() {
        return (String)this.rawConfigurationMap.get("iconHash");
    }

    public Boolean shouldUploadIcon() {
        return (Boolean)this.rawConfigurationMap.get("uploadIcon");
    }

    public void setIconHash(String md5Hash) {
        this.rawConfigurationMap.put("iconHash", md5Hash);
    }

    public void setIconModificationDate(long lastModified) {
        this.rawConfigurationMap.put("iconModified", lastModified);
    }

    public void doNotUploadIcon() {
        this.rawConfigurationMap.remove("uploadIcon");
    }

    public void setIconPath(String path) {
        this.rawConfigurationMap.put("toolIconPath", path);
    }

    public ConfigurationDefinition generateConfiguration() {
        LinkedList<Object> configuration = new LinkedList<Object>();
        LinkedList<Object> configurationMetadata = new LinkedList<Object>();
        this.readConfigurationWithMetaDataToLists(configuration, configurationMetadata);
        Map<String, String> readOnlyConfiguration = this.createReadOnlyConfiguration();
        return ComponentConfigurationModelFactory.createConfigurationDefinition(configuration, new LinkedList(), configurationMetadata, readOnlyConfiguration);
    }

    private void readConfigurationWithMetaDataToLists(List<Object> configuration, List<Object> configurationMetadata) {
        Map<String, Object> properties = this.checkedMapCast(this.rawConfigurationMap.getOrDefault("toolProperties", new HashMap()), String.class, Object.class);
        for (Map.Entry<String, Object> groupEntry : properties.entrySet()) {
            Map<String, Object> group = this.checkedMapCast(groupEntry.getValue(), String.class, Object.class);
            String configFileName = null;
            if (group.get("propertyCreateConfigFile") != null && ((Boolean)group.get("propertyCreateConfigFile")).booleanValue()) {
                configFileName = (String)group.get("propertyConfigFilename");
            }
            int i = 0;
            for (Map.Entry<String, Object> propertyOrConfigfile : group.entrySet()) {
                if (propertyOrConfigfile.getValue() instanceof String || propertyOrConfigfile.getValue() instanceof Boolean) continue;
                Map<String, String> property = this.checkedMapCast(propertyOrConfigfile.getValue(), String.class, String.class);
                HashMap<String, String> config = new HashMap<String, String>();
                config.put("key", property.get("propertyKey"));
                config.put("defaultValue", property.get("propertyDefaultValue"));
                configuration.add(config);
                HashMap<String, String> configMetadata = new HashMap<String, String>();
                configMetadata.put("guiName", property.get("propertyDisplayName"));
                configMetadata.put("comment", property.get("propertyComment"));
                if (configFileName != null) {
                    configMetadata.put("propertyConfigFilename", configFileName);
                }
                configMetadata.put("guiGroupPosition", groupEntry.getKey());
                configMetadata.put("guiPosition", "" + i++);
                configMetadata.put("key", property.get("propertyKey"));
                configurationMetadata.add(configMetadata);
            }
        }
        HashMap<String, String> historyConfig = new HashMap<String, String>();
        historyConfig.put("key", "storeComponentHistoryData");
        historyConfig.put("defaultValue", "false");
        configuration.add(historyConfig);
    }

    private Map<String, String> createReadOnlyConfiguration() {
        HashMap<String, String> configuration = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : this.rawConfigurationMap.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof String) {
                configuration.put(entry.getKey(), (String)value);
                continue;
            }
            if (!(value instanceof Boolean)) continue;
            configuration.put(entry.getKey(), ((Boolean)value).toString());
        }
        configuration.put("rootWorkingDirectory", this.getFirstLaunchSettings().get("rootWorkingDirectory"));
        configuration.put("toolDirectory", this.getFirstLaunchSettings().get("toolDirectory"));
        return configuration;
    }

    public boolean hasIntegrationVersion() {
        return this.rawConfigurationMap.containsKey("toolIntegrationVersion");
    }

    public void setIntegrationVersion(int currentToolintegrationVersion) {
        this.rawConfigurationMap.put("toolIntegrationVersion", currentToolintegrationVersion);
    }

    public boolean containsDocFilePath() {
        return this.rawConfigurationMap.get("documentationFilePath") != null && !this.getDocFilePath().isEmpty();
    }

    public String getDocFilePath() {
        return (String)this.rawConfigurationMap.getOrDefault("documentationFilePath", "");
    }

    public void setDocFilePath(String path) {
        this.rawConfigurationMap.put("documentationFilePath", path);
    }

    private <K, V> List<Map<K, V>> checkedListOfMapCast(Object o, Class<K> clazzK, Class<V> clazzV) {
        if (!(o instanceof List)) {
            throw new ClassCastException(StringUtils.format((String)"Tool integration configuration error. %s is not of type 'List'", (Object[])new Object[]{o}));
        }
        boolean castable = Stream.of(o).filter(Map.class::isInstance).map(Map.class::cast).allMatch(entry -> {
            if (!entry.keySet().stream().allMatch(clazzK::isInstance)) return false;
            if (!entry.values().stream().allMatch(clazzV::isInstance)) return false;
            return true;
        });
        if (!castable) {
            throw new ClassCastException(StringUtils.format((String)"Tool integration configuration error. At least one list entry is not of type Map<%s, %s>.", (Object[])new Object[]{clazzK, clazzV}));
        }
        return (List)o;
    }

    /*
     * Unable to fully structure code
     */
    private <K, V> Map<K, V> checkedMapCast(Object o, Class<K> clazzK, Class<V> clazzV) {
        if (!(o instanceof Map)) {
            throw new ClassCastException(StringUtils.format((String)"Tool integration configuration error. %s is not of type 'Map'", (Object[])new Object[]{o}));
        }
        map = (Map)o;
        if (!map.keySet().stream().allMatch((Predicate<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Ljava/lang/Object;)Z)(clazzK))) ** GOTO lbl-1000
        if (map.values().stream().allMatch((Predicate<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Ljava/lang/Object;)Z)(clazzV))) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = castable = false;
        }
        if (!castable) {
            throw new ClassCastException(StringUtils.format((String)"Tool integration configuration error. Unable to cast to Map<%s, %s>.", (Object[])new Object[]{clazzK, clazzV}));
        }
        return (Map)o;
    }

    private List<Object> checkedListCast(Object o) {
        if (!(o instanceof List)) {
            throw new ClassCastException(StringUtils.format((String)"Tool integration configuration error. %s is not of type 'List'", (Object[])new Object[]{o}));
        }
        return (List)o;
    }

    public Map<String, Object> getShallowClone() {
        TreeMap<String, Object> returnValue = new TreeMap<String, Object>();
        returnValue.putAll(this.rawConfigurationMap);
        return returnValue;
    }

    public String getToolDescription() {
        return (String)this.rawConfigurationMap.getOrDefault("toolDescription", "");
    }

    public String getIntegratorName() {
        return (String)this.rawConfigurationMap.getOrDefault("toolIntegratorName", "");
    }

    public String getIntegratorEmail() {
        return (String)this.rawConfigurationMap.getOrDefault("toolIntegratorE-Mail", "");
    }

    public boolean isCopyIcon() {
        return (Boolean)this.rawConfigurationMap.getOrDefault("uploadIcon", false);
    }

    public boolean isLimitInstance() {
        Map<String, String> firstLaunchSettings = this.getFirstLaunchSettings();
        return Boolean.parseBoolean(firstLaunchSettings.getOrDefault("limitInstallationInstances", "false"));
    }

    public Map<String, Object> getRawConfigurationMap() {
        return this.rawConfigurationMap;
    }

    public void setRawConfigurationMap(Map<String, Object> rawConfigurationMap) {
        this.rawConfigurationMap = rawConfigurationMap;
    }
}

