/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.optimizer.gui.properties.commands;

import de.rcenvironment.components.optimizer.gui.properties.commands.OptimizerDynamicEndpointCommandHelper;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinition;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.gui.workflow.editor.commands.endpoint.EditDynamicEndpointCommand;
import de.rcenvironment.core.gui.workflow.editor.properties.Refreshable;
import java.util.HashMap;
import java.util.Map;

public class OptimizerEditDynamicEndpointCommand
extends EditDynamicEndpointCommand {
    private static final String DESIGN_VARIABLE = "Design";
    private static final String DASH = "-";

    public OptimizerEditDynamicEndpointCommand(EndpointType direction, String id, EndpointDescription oldDescription, EndpointDescription newDescription, boolean executable, boolean undoable, Refreshable ... refreshable) {
        super(direction, oldDescription, newDescription, refreshable);
    }

    public void execute() {
        WorkflowNode workflowNode = this.getWorkflowNode();
        super.execute();
        switch (this.direction) {
            case INPUT: {
                if (this.hasGradient(this.oldDesc)) {
                    if (this.hasGradient(this.newDesc)) {
                        this.executeBothHaveGradients(workflowNode);
                        break;
                    }
                    for (EndpointDescription variable : workflowNode.getOutputDescriptionsManager().getDynamicEndpointDescriptions()) {
                        if (!variable.getDynamicEndpointIdentifier().equals(DESIGN_VARIABLE)) continue;
                        String oldGradientName = OptimizerDynamicEndpointCommandHelper.createGradientChannelName(this.oldDesc.getName(), variable.getName());
                        workflowNode.getInputDescriptionsManager().removeDynamicEndpointDescription(oldGradientName);
                    }
                } else {
                    if (!this.hasGradient(this.newDesc)) break;
                    for (EndpointDescription variable : workflowNode.getOutputDescriptionsManager().getDynamicEndpointDescriptions()) {
                        if (!variable.getDynamicEndpointIdentifier().equals(DESIGN_VARIABLE)) continue;
                        String newGradientName = OptimizerDynamicEndpointCommandHelper.createGradientChannelName(this.newDesc.getName(), variable.getName());
                        HashMap<String, String> metaData = new HashMap<String, String>();
                        for (String key : this.newDesc.getMetaData().keySet()) {
                            if (key.equals("vectorSize") || key.startsWith("inputHandling_73b1056e") || key.startsWith("inputExecutionConstraint_4aae3eea")) {
                                metaData.put(key, (String)this.newDesc.getMetaData().get(key));
                                continue;
                            }
                            metaData.put(key, DASH);
                        }
                        workflowNode.getInputDescriptionsManager().addDynamicEndpointDescription("gradients", newGradientName, variable.getDataType(), metaData);
                    }
                }
                break;
            }
            case OUTPUT: {
                if (!this.newDesc.getName().equals(this.oldDesc.getName()) || !this.newDesc.getDataType().equals((Object)this.oldDesc.getDataType())) {
                    for (EndpointDescription function : workflowNode.getInputDescriptionsManager().getDynamicEndpointDescriptions()) {
                        if (workflowNode.getInputDescriptionsManager().isValidEndpointName(OptimizerDynamicEndpointCommandHelper.createGradientChannelName(function.getName(), this.oldDesc.getName()))) continue;
                        String oldName = OptimizerDynamicEndpointCommandHelper.createGradientChannelName(function.getName(), this.oldDesc.getName());
                        String newName = OptimizerDynamicEndpointCommandHelper.createGradientChannelName(function.getName(), this.newDesc.getName());
                        EndpointDescription desc = workflowNode.getInputDescriptionsManager().getEndpointDescription(OptimizerDynamicEndpointCommandHelper.createGradientChannelName(function.getName(), this.oldDesc.getName()));
                        desc.setName(newName);
                        workflowNode.getInputDescriptionsManager().editDynamicEndpointDescription(oldName, newName, this.newDesc.getDataType(), desc.getMetaData());
                    }
                }
                if (!this.oldDesc.getName().equals(this.newDesc.getName()) || !this.oldDesc.getDataType().equals((Object)this.newDesc.getDataType())) {
                    if (this.getWorkflowNode().getOutputDescriptionsManager().getEndpointDescription(String.valueOf(this.oldDesc.getName()) + "_optimal") != null) {
                        this.getWorkflowNode().getOutputDescriptionsManager().removeDynamicEndpointDescription(String.valueOf(this.oldDesc.getName()) + "_optimal");
                    }
                    HashMap metadata = new HashMap();
                    metadata.putAll(this.newDesc.getMetaData());
                    this.getWorkflowNode().getOutputDescriptionsManager().addDynamicEndpointDescription("optima", String.valueOf(this.newDesc.getName()) + "_optimal", this.newDesc.getDataType(), metadata);
                }
                this.handleExtraValueInputs(workflowNode, "hasStartValue", null, " - start value", true, this.oldDesc, this.newDesc);
                this.handleExtraValueInputs(workflowNode, "useStep", "useUnifiedStep", " - step value", false, this.oldDesc, this.newDesc);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        String oldHasBounds = this.oldDesc.getMetaDataValue("hasSingleBounds");
        String newHasBounds = this.newDesc.getMetaDataValue("hasSingleBounds");
        if (oldHasBounds != null && Boolean.parseBoolean(oldHasBounds) && !Boolean.parseBoolean(newHasBounds)) {
            OptimizerDynamicEndpointCommandHelper.addLowerAndUpperBoundsEndpoints(this.newDesc.getName(), this.newDesc.getDataType(), this.newDesc.getMetaData(), workflowNode);
        }
        if (oldHasBounds != null && !Boolean.parseBoolean(oldHasBounds)) {
            if (Boolean.parseBoolean(newHasBounds)) {
                OptimizerDynamicEndpointCommandHelper.removeUpperLowerBoundsEndpoints(this.oldDesc.getName(), this.oldDesc.getMetaData(), workflowNode);
            } else if (!this.oldDesc.getName().equals(this.newDesc.getName())) {
                OptimizerDynamicEndpointCommandHelper.removeUpperLowerBoundsEndpoints(this.oldDesc.getName(), this.oldDesc.getMetaData(), workflowNode);
                OptimizerDynamicEndpointCommandHelper.addLowerAndUpperBoundsEndpoints(this.newDesc.getName(), this.newDesc.getDataType(), this.newDesc.getMetaData(), workflowNode);
            }
        }
        if (this.refreshable != null) {
            Refreshable[] refreshableArray = this.refreshable;
            int n = this.refreshable.length;
            int n2 = 0;
            while (n2 < n) {
                Refreshable r = refreshableArray[n2];
                r.refresh();
                ++n2;
            }
        }
    }

    private void handleExtraValueInputs(WorkflowNode workflowNode, String conditionName, String condition2Name, String signature, boolean negateCondition, EndpointDescription fromDescription, EndpointDescription toDescription) {
        HashMap<String, String> metaData;
        boolean dataTypeChanged;
        String newConditionValueString = toDescription.getMetaDataValue(conditionName);
        boolean newConditionValue = newConditionValueString != null && Boolean.parseBoolean(newConditionValueString);
        String oldConditionValueString = fromDescription.getMetaDataValue(conditionName);
        boolean oldConditionValue = oldConditionValueString != null && Boolean.parseBoolean(oldConditionValueString);
        boolean condition2Active = false;
        boolean newCondition2Value = false;
        boolean oldCondition2Value = false;
        if (condition2Name != null) {
            condition2Active = true;
            String newCondition2ValueString = toDescription.getMetaDataValue(condition2Name);
            newCondition2Value = newCondition2ValueString != null && !Boolean.parseBoolean(newCondition2ValueString);
            String oldCondition2ValueString = fromDescription.getMetaDataValue(condition2Name);
            oldCondition2Value = oldCondition2ValueString != null && !Boolean.parseBoolean(oldCondition2ValueString);
        }
        boolean nameChanged = !fromDescription.getName().equals(toDescription.getName());
        boolean bl = dataTypeChanged = !fromDescription.getDataType().equals((Object)toDescription.getDataType());
        if (negateCondition) {
            newConditionValue = !newConditionValue;
            boolean bl2 = oldConditionValue = !oldConditionValue;
        }
        if ((nameChanged || dataTypeChanged) && oldConditionValue && (!condition2Active || oldCondition2Value)) {
            workflowNode.getInputDescriptionsManager().editDynamicEndpointDescription(String.valueOf(fromDescription.getName()) + signature, String.valueOf(toDescription.getName()) + signature, toDescription.getDataType(), fromDescription.getMetaData());
        }
        if (oldConditionValue && newConditionValue && condition2Active) {
            if (oldCondition2Value && !newCondition2Value && workflowNode.getInputDescriptionsManager().getEndpointDescription(String.valueOf(toDescription.getName()) + signature) != null) {
                workflowNode.getInputDescriptionsManager().removeDynamicEndpointDescription(String.valueOf(toDescription.getName()) + signature);
            }
            if (!oldCondition2Value && newCondition2Value) {
                metaData = new HashMap();
                metaData.put("inputExecutionConstraint_4aae3eea", EndpointDefinition.InputExecutionContraint.Required.name());
                workflowNode.getInputDescriptionsManager().addDynamicEndpointDescription("startvalues", String.valueOf(toDescription.getName()) + signature, toDescription.getDataType(), metaData);
            }
        }
        if (oldConditionValue && !newConditionValue && (!condition2Active || oldCondition2Value && !newCondition2Value) && workflowNode.getInputDescriptionsManager().getEndpointDescription(String.valueOf(toDescription.getName()) + signature) != null) {
            workflowNode.getInputDescriptionsManager().removeDynamicEndpointDescription(String.valueOf(toDescription.getName()) + signature);
        }
        if (!oldConditionValue && newConditionValue && (!condition2Active || !oldCondition2Value && newCondition2Value)) {
            metaData = new HashMap<String, String>();
            metaData.put("inputExecutionConstraint_4aae3eea", EndpointDefinition.InputExecutionContraint.Required.name());
            workflowNode.getInputDescriptionsManager().addDynamicEndpointDescription("startvalues", String.valueOf(toDescription.getName()) + signature, toDescription.getDataType(), metaData);
        }
    }

    private void executeBothHaveGradients(WorkflowNode workflowNode) {
        if (!this.oldDesc.getName().equals(this.newDesc.getName()) || this.oldDesc.getDataType() != this.newDesc.getDataType()) {
            for (EndpointDescription variable : workflowNode.getOutputDescriptionsManager().getDynamicEndpointDescriptions()) {
                if (variable.getName().contains("_optimal")) continue;
                String oldGradientName = OptimizerDynamicEndpointCommandHelper.createGradientChannelName(this.oldDesc.getName(), variable.getName());
                String newGradientName = OptimizerDynamicEndpointCommandHelper.createGradientChannelName(this.newDesc.getName(), variable.getName());
                EndpointDescription newDesc = workflowNode.getInputDescriptionsManager().getEndpointDescription(oldGradientName);
                newDesc.setName(newGradientName);
                newDesc.setDataType(this.newDesc.getDataType());
                HashMap<String, String> gradientMetadata = new HashMap<String, String>();
                for (String key : this.newDesc.getMetaData().keySet()) {
                    if (key.equals("vectorSize") || key.startsWith("inputHandling_73b1056e") || key.startsWith("inputExecutionConstraint_4aae3eea")) {
                        gradientMetadata.put(key, (String)this.newDesc.getMetaData().get(key));
                        continue;
                    }
                    gradientMetadata.put(key, DASH);
                }
                newDesc.setMetaData(gradientMetadata);
                workflowNode.getInputDescriptionsManager().editDynamicEndpointDescription(oldGradientName, newGradientName, newDesc.getDataType(), newDesc.getMetaData());
            }
        }
    }

    private boolean hasGradient(EndpointDescription description) {
        return description.getMetaDataValue("hasGradient") != null && Boolean.parseBoolean(description.getMetaDataValue("hasGradient"));
    }

    public void undo() {
        WorkflowNode workflowNode = this.getWorkflowNode();
        super.undo();
        switch (this.direction) {
            case INPUT: {
                if (this.hasGradient(this.newDesc)) {
                    if (this.hasGradient(this.oldDesc)) {
                        this.undoBothHaveGradients(workflowNode);
                        break;
                    }
                    for (EndpointDescription variable : workflowNode.getOutputDescriptionsManager().getDynamicEndpointDescriptions()) {
                        if (!variable.getDynamicEndpointIdentifier().equals(DESIGN_VARIABLE)) continue;
                        String newGradientName = OptimizerDynamicEndpointCommandHelper.createGradientChannelName(this.newDesc.getName(), variable.getName());
                        workflowNode.getInputDescriptionsManager().removeDynamicEndpointDescription(newGradientName);
                    }
                } else {
                    if (!this.hasGradient(this.oldDesc)) break;
                    for (EndpointDescription variable : workflowNode.getOutputDescriptionsManager().getDynamicEndpointDescriptions()) {
                        if (!variable.getDynamicEndpointIdentifier().equals(DESIGN_VARIABLE)) continue;
                        String oldGradientName = OptimizerDynamicEndpointCommandHelper.createGradientChannelName(this.oldDesc.getName(), variable.getName());
                        HashMap<String, String> metaData = new HashMap<String, String>();
                        for (String key : this.newDesc.getMetaData().keySet()) {
                            if (key.equals("vectorSize") || key.startsWith("inputHandling_73b1056e") || key.startsWith("inputExecutionConstraint_4aae3eea")) {
                                metaData.put(key, (String)this.newDesc.getMetaData().get(key));
                                continue;
                            }
                            metaData.put(key, DASH);
                        }
                        workflowNode.getInputDescriptionsManager().addDynamicEndpointDescription("gradients", oldGradientName, this.oldDesc.getDataType(), metaData);
                    }
                }
                break;
            }
            case OUTPUT: {
                if (!this.newDesc.getName().equals(this.oldDesc.getName())) {
                    for (EndpointDescription function : workflowNode.getInputDescriptionsManager().getDynamicEndpointDescriptions()) {
                        if (workflowNode.getInputDescriptionsManager().isValidEndpointName(OptimizerDynamicEndpointCommandHelper.createGradientChannelName(function.getName(), this.newDesc.getName()))) continue;
                        String oldName = OptimizerDynamicEndpointCommandHelper.createGradientChannelName(function.getName(), this.oldDesc.getName());
                        String newName = OptimizerDynamicEndpointCommandHelper.createGradientChannelName(function.getName(), this.newDesc.getName());
                        EndpointDescription desc = workflowNode.getInputDescriptionsManager().getEndpointDescription(OptimizerDynamicEndpointCommandHelper.createGradientChannelName(function.getName(), this.newDesc.getName()));
                        desc.setName(oldName);
                        workflowNode.getInputDescriptionsManager().editDynamicEndpointDescription(newName, oldName, desc.getDataType(), desc.getMetaData());
                    }
                    if (this.getWorkflowNode().getOutputDescriptionsManager().getEndpointDescription(String.valueOf(this.newDesc.getName()) + "_optimal") != null) {
                        this.getWorkflowNode().getOutputDescriptionsManager().removeDynamicEndpointDescription(String.valueOf(this.newDesc.getName()) + "_optimal");
                    }
                    Map metadata = this.oldDesc.getMetaData();
                    this.getWorkflowNode().getOutputDescriptionsManager().addDynamicEndpointDescription("optima", String.valueOf(this.oldDesc.getName()) + "_optimal", this.newDesc.getDataType(), metadata);
                }
                this.handleExtraValueInputs(workflowNode, "hasStartValue", null, " - start value", true, this.newDesc, this.oldDesc);
                this.handleExtraValueInputs(workflowNode, "useStep", "useUnifiedStep", " - step value", false, this.newDesc, this.oldDesc);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        String oldHasBounds = this.oldDesc.getMetaDataValue("hasSingleBounds");
        String newHasBounds = this.newDesc.getMetaDataValue("hasSingleBounds");
        if (Boolean.parseBoolean(newHasBounds)) {
            if (oldHasBounds != null && !Boolean.parseBoolean(oldHasBounds)) {
                OptimizerDynamicEndpointCommandHelper.addLowerAndUpperBoundsEndpoints(this.oldDesc.getName(), this.oldDesc.getDataType(), this.oldDesc.getMetaData(), workflowNode);
            }
        } else if (oldHasBounds != null && !Boolean.parseBoolean(oldHasBounds)) {
            if (!this.oldDesc.getName().equals(this.newDesc.getName())) {
                OptimizerDynamicEndpointCommandHelper.removeUpperLowerBoundsEndpoints(this.newDesc.getName(), this.newDesc.getMetaData(), workflowNode);
                OptimizerDynamicEndpointCommandHelper.addLowerAndUpperBoundsEndpoints(this.oldDesc.getName(), this.oldDesc.getDataType(), this.oldDesc.getMetaData(), workflowNode);
            }
        } else {
            OptimizerDynamicEndpointCommandHelper.removeUpperLowerBoundsEndpoints(this.newDesc.getName(), this.newDesc.getMetaData(), workflowNode);
        }
        if (this.refreshable != null) {
            Refreshable[] refreshableArray = this.refreshable;
            int n = this.refreshable.length;
            int n2 = 0;
            while (n2 < n) {
                Refreshable r = refreshableArray[n2];
                r.refresh();
                ++n2;
            }
        }
    }

    private void undoBothHaveGradients(WorkflowNode workflowNode) {
        if (!this.oldDesc.getName().equals(this.newDesc.getName()) || this.oldDesc.getDataType() != this.newDesc.getDataType()) {
            for (EndpointDescription variable : workflowNode.getOutputDescriptionsManager().getDynamicEndpointDescriptions()) {
                if (!variable.getDynamicEndpointIdentifier().equals(DESIGN_VARIABLE)) continue;
                String oldGradientName = OptimizerDynamicEndpointCommandHelper.createGradientChannelName(this.oldDesc.getName(), variable.getName());
                String newGradientName = OptimizerDynamicEndpointCommandHelper.createGradientChannelName(this.newDesc.getName(), variable.getName());
                EndpointDescription desc = workflowNode.getInputDescriptionsManager().getEndpointDescription(newGradientName);
                desc.setName(oldGradientName);
                HashMap<String, String> gradientMetadata = new HashMap<String, String>();
                for (String key : this.oldDesc.getMetaData().keySet()) {
                    if (key.equals("vectorSize") || key.startsWith("inputHandling_73b1056e") || key.startsWith("inputExecutionConstraint_4aae3eea")) {
                        gradientMetadata.put(key, (String)this.newDesc.getMetaData().get(key));
                        continue;
                    }
                    gradientMetadata.put(key, DASH);
                }
                desc.setMetaData(gradientMetadata);
                workflowNode.getInputDescriptionsManager().editDynamicEndpointDescription(newGradientName, oldGradientName, this.oldDesc.getDataType(), gradientMetadata);
            }
        }
    }
}

