/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.outputwriter.common;

import de.rcenvironment.core.datamodel.api.TypedDatum;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class OutputWriterValidatorHelper {
    public static final int MINUS_ONE = -1;
    private static final List<Character> ALLOWED_ESCAPES = Arrays.asList(Character.valueOf('\\'), Character.valueOf('['), Character.valueOf(']'));
    private static final String LINE_SEP = System.getProperty("line.separator");

    public static List<String> getValidationErrors(String text) {
        Set<String> unknownEscapes;
        LinkedList<String> validationErrors = new LinkedList<String>();
        if (OutputWriterValidatorHelper.endsWithOddNumberOfBackslashes(text)) {
            validationErrors.add("Ends with single '\\'. Use '\\\\' to enter a single backslash.");
        }
        if (!(unknownEscapes = OutputWriterValidatorHelper.getInvalidEscapes(text)).isEmpty()) {
            StringBuilder errorMessageBuilder = new StringBuilder();
            errorMessageBuilder.append(String.format("Contains unknown escape characters: %s.", String.join((CharSequence)", ", unknownEscapes)));
            errorMessageBuilder.append('\n');
            errorMessageBuilder.append("Only \\\\, \\[, and \\] are supported, all other characters may be entered directly.");
            validationErrors.add(errorMessageBuilder.toString());
        }
        if (OutputWriterValidatorHelper.containsNestedBrackets(text)) {
            validationErrors.add("Contains nested brackets '[..[..]..]'.");
        }
        if (OutputWriterValidatorHelper.containsUnmatchedOpeningBracket(text)) {
            validationErrors.add("Contains unmatched opening bracket '['");
        }
        if (OutputWriterValidatorHelper.containsUnmatchedClosingBracket(text)) {
            validationErrors.add("Contains unmatched closing bracket ']'");
        }
        return validationErrors;
    }

    private static boolean endsWithOddNumberOfBackslashes(String text) {
        int numberOfTerminalBackslashes = 0;
        int i = 0;
        while (i < text.length()) {
            numberOfTerminalBackslashes = text.charAt(i) == '\\' ? ++numberOfTerminalBackslashes : 0;
            ++i;
        }
        return numberOfTerminalBackslashes % 2 == 1;
    }

    private static boolean containsNestedBrackets(String text) {
        boolean skipChar = false;
        boolean insideBracket = false;
        int i = 0;
        while (i < text.length()) {
            if (skipChar) {
                skipChar = false;
            } else {
                char currentChar = text.charAt(i);
                if (currentChar == '[') {
                    if (insideBracket) {
                        return true;
                    }
                    insideBracket = true;
                } else if (currentChar == ']') {
                    insideBracket = false;
                } else if (currentChar == '\\') {
                    skipChar = true;
                }
            }
            ++i;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean containsUnmatchedClosingBracket(String text) {
        boolean skipChar = false;
        int nestingDepth = 0;
        int i = 0;
        while (i < text.length()) {
            if (skipChar) {
                skipChar = false;
            } else {
                char currentChar = text.charAt(i);
                if (currentChar == ']') {
                    if (nestingDepth <= 0) return true;
                    --nestingDepth;
                } else if (currentChar == '[') {
                    ++nestingDepth;
                } else if (currentChar == '\\') {
                    skipChar = true;
                }
            }
            ++i;
        }
        return false;
    }

    private static boolean containsUnmatchedOpeningBracket(String text) {
        boolean skipChar = false;
        int nestingDepth = 0;
        int i = 0;
        while (i < text.length()) {
            if (skipChar) {
                skipChar = false;
            } else {
                char currentChar = text.charAt(i);
                if (currentChar == '[') {
                    ++nestingDepth;
                } else if (currentChar == ']') {
                    nestingDepth = Math.max(nestingDepth - 1, 0);
                } else if (currentChar == '\\') {
                    skipChar = true;
                }
            }
            ++i;
        }
        return nestingDepth > 0;
    }

    private static Set<String> getInvalidEscapes(String text) {
        HashSet<String> invalidEscapes = new HashSet<String>();
        boolean skipChar = false;
        int i = 0;
        while (i < text.length() - 1) {
            if (skipChar) {
                skipChar = false;
            } else {
                char currentChar = text.charAt(i);
                if (currentChar == '\\') {
                    char nextChar = text.charAt(i + 1);
                    if (!ALLOWED_ESCAPES.contains(Character.valueOf(nextChar))) {
                        invalidEscapes.add(String.format("%s%s", Character.valueOf(currentChar), Character.valueOf(nextChar)));
                    } else {
                        skipChar = true;
                    }
                }
            }
            ++i;
        }
        return invalidEscapes;
    }

    public static List<String> getValidationWarnings(StringBuilder warningBuilder, String text, List<String> knownPlaceholders) {
        LinkedList<String> warnings = new LinkedList<String>();
        List<String> placeholders = OutputWriterValidatorHelper.parsePlaceholders(text);
        LinkedList<String> unknownPlaceholders = new LinkedList<String>();
        for (String placeholder : placeholders) {
            if (knownPlaceholders.contains(placeholder)) continue;
            unknownPlaceholders.add(placeholder);
        }
        if (!unknownPlaceholders.isEmpty()) {
            warningBuilder.append(String.join((CharSequence)", ", unknownPlaceholders));
            warnings.add(warningBuilder.toString());
        }
        return warnings;
    }

    private static List<String> parsePlaceholders(String text) {
        LinkedList<String> placeholders = new LinkedList<String>();
        StringBuilder placeholderBuilder = new StringBuilder();
        boolean escapeChar = false;
        boolean inPlaceholder = false;
        int i = 0;
        while (i < text.length()) {
            char currentChar = text.charAt(i);
            if (currentChar == '[') {
                if (inPlaceholder) {
                    placeholderBuilder.append(currentChar);
                } else if (!escapeChar) {
                    placeholderBuilder.append(currentChar);
                    inPlaceholder = true;
                }
                escapeChar = false;
            } else if (currentChar == ']') {
                if (inPlaceholder) {
                    if (escapeChar) {
                        placeholderBuilder.append(currentChar);
                    } else {
                        placeholderBuilder.append(currentChar);
                        String placeholder = placeholderBuilder.toString();
                        if (!placeholders.contains(placeholder)) {
                            placeholders.add(placeholder);
                        }
                        placeholderBuilder = new StringBuilder();
                        inPlaceholder = false;
                    }
                }
                escapeChar = false;
            } else if (currentChar == '\\') {
                if (escapeChar) {
                    if (inPlaceholder) {
                        placeholderBuilder.append(currentChar);
                    }
                    escapeChar = false;
                } else {
                    escapeChar = true;
                }
            } else if (inPlaceholder) {
                placeholderBuilder.append(currentChar);
            }
            ++i;
        }
        return placeholders;
    }

    public static String replacePlaceholders(String formatString, Map<String, TypedDatum> inputMap, String timestamp, int executionCount) {
        StringBuilder resultBuilder = new StringBuilder();
        StringCharacterIterator formatStringIterator = new StringCharacterIterator(formatString);
        char currentChar = formatStringIterator.current();
        while (currentChar != '\uffff') {
            block16: {
                block17: {
                    block15: {
                        if (currentChar != '\\') break block15;
                        char nextChar = formatStringIterator.next();
                        resultBuilder.append(nextChar);
                        break block16;
                    }
                    if (currentChar != '[') break block17;
                    String placeholder = OutputWriterValidatorHelper.parsePlaceholder(formatStringIterator);
                    switch (String.format("[%s]", placeholder)) {
                        case "[Linebreak]": {
                            resultBuilder.append(LINE_SEP);
                            break;
                        }
                        case "[Timestamp]": {
                            resultBuilder.append(timestamp);
                            break;
                        }
                        case "[Execution count]": {
                            resultBuilder.append(Integer.toString(executionCount));
                            break;
                        }
                        default: {
                            if (inputMap.containsKey(placeholder)) {
                                resultBuilder.append(inputMap.get(placeholder));
                                break;
                            }
                            resultBuilder.append(String.format("[%s]", placeholder));
                            break;
                        }
                    }
                    break block16;
                }
                resultBuilder.append(currentChar);
            }
            currentChar = formatStringIterator.next();
        }
        return resultBuilder.toString();
    }

    private static String parsePlaceholder(CharacterIterator formatStringIterator) {
        char currentChar;
        StringBuilder resultBuilder = new StringBuilder();
        while ((currentChar = formatStringIterator.next()) != ']') {
            if (currentChar == '\\') {
                char nextChar = formatStringIterator.next();
                resultBuilder.append(nextChar);
                continue;
            }
            resultBuilder.append(currentChar);
        }
        return resultBuilder.toString();
    }

    public static String formatHeader(String formatString, String timestamp, int executionCount) {
        return OutputWriterValidatorHelper.replacePlaceholders(formatString, new HashMap<String, TypedDatum>(), timestamp, executionCount);
    }
}

