/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.RepaintManager;
import javax.swing.border.Border;
import org.jpedal.Display;
import org.jpedal.DisplayOffsets;
import org.jpedal.PageOffsets;
import org.jpedal.PdfDecoder;
import org.jpedal.exception.PdfException;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.rendering.AcroRenderer;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.render.SwingDisplay;
import org.jpedal.text.TextLines;
import org.jpedal.utils.ScalingFactory;

class SwingPainter {
    protected int lastFormPage = -1;
    protected int lastStart = -1;
    protected int lastEnd = -1;
    public Rectangle viewableArea = null;
    private int pageUsedForTransform;
    private int lastIndent = -1;
    private Rectangle cursorBoxOnScreen = null;
    private Rectangle lastCursorBoxOnScreen = null;
    private Color outlineColor;
    private AffineTransform cursorAf;
    private double indent = 0.0;
    private AffineTransform viewScaling = null;
    private PdfDecoder pdfDecoder;
    DisplayOffsets displayOffsets;
    DecoderOptions options = new DecoderOptions();

    public SwingPainter(PdfDecoder pdfDecoder, DecoderOptions decoderOptions) {
        this.pdfDecoder = pdfDecoder;
        this.options = decoderOptions;
        this.displayOffsets = decoderOptions.getDisplayOffsets();
    }

    public void paintPage(Graphics2D graphics2D, PdfDecoder pdfDecoder, Display display, PdfPageData pdfPageData, int n, DynamicVectorRenderer dynamicVectorRenderer, int n2, int n3, int n4, int n5, TextLines textLines, Border border, PageOffsets pageOffsets, ExternalHandlers externalHandlers) {
        AcroRenderer acroRenderer = pdfDecoder.getFormRenderer();
        Rectangle rectangle = pdfDecoder.getVisibleRect();
        int n6 = pdfDecoder.getPageCount();
        float f = pdfDecoder.getScaling();
        display.init(f, n6, n3, n, dynamicVectorRenderer, false, pdfPageData, n4, n5);
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.translate(this.displayOffsets.getUserOffsetX(), this.displayOffsets.getUserOffsetY());
        int n7 = n;
        int n8 = n;
        if (n2 != 1 && n2 != 5) {
            n7 = display.getStartPage();
            n8 = display.getEndPage();
            if (n7 == 0 || n8 == 0 || this.lastEnd != n8 || this.lastStart != n7) {
                this.lastFormPage = -1;
            }
            this.lastEnd = n8;
            this.lastStart = n7;
        }
        if (this.lastFormPage != n && acroRenderer != null) {
            acroRenderer.displayComponentsOnscreen(n7, n8);
            if (acroRenderer.getCompData().getStartComponentCountForPage(n) != -1) {
                this.lastFormPage = n;
            }
        }
        if (pdfDecoder.alignment == 2) {
            double d = pdfDecoder.getBounds().getWidth();
            if (n2 == 5) {
                d = rectangle.getWidth();
            }
            int n9 = pdfDecoder.getPDFWidth();
            if (n2 != 1) {
                n9 = (int)display.getPageSize(n2).getWidth();
            }
            if (n2 == 5) {
                this.indent = (rectangle.width - display.getWidthForPage(n)) / 2 - n4 - pdfDecoder.getBounds().x;
            } else if (n2 == 3) {
                int n10 = n;
                if (display.getSeparateCover() && (n10 & 1) == 1) {
                    --n10;
                } else if (!display.getSeparateCover() && (n10 & 1) == 0) {
                    --n10;
                }
                int n11 = (n3 + pdfPageData.getRotation(n10)) % 180 == 90 ? pdfPageData.getCropBoxHeight(n10) : pdfPageData.getCropBoxWidth(n10);
                int n12 = n10 + 1 > n6 ? n11 : ((n3 + pdfPageData.getRotation(n10 + 1)) % 180 == 90 ? pdfPageData.getCropBoxHeight(n10 + 1) : pdfPageData.getCropBoxWidth(n10 + 1));
                int n13 = 0;
                if (!display.getTurnoverOn() || pdfPageData.hasMultipleSizes() || n6 == 2) {
                    n13 = 10 / 2;
                }
                this.indent = (d - (double)((float)(n11 + n12) * f)) / 2.0 - (double)n13 - (double)n4;
            } else {
                this.indent = (d - (double)n9) / 2.0;
            }
            if (n2 == 1) {
                this.lastIndent = (int)this.indent;
            } else if ((n2 == 2 || n2 == 5) && this.lastIndent != -1) {
                this.indent = this.lastIndent;
                this.lastIndent = -1;
            } else {
                this.lastIndent = -1;
            }
            graphics2D.translate(this.indent, 0.0);
            if (acroRenderer != null && pageOffsets != null) {
                if (n2 == 5) {
                    this.indent -= (double)(n - 1) * PageOffsets.getPageFlowPageWidth((int)((float)pdfPageData.getCropBoxWidth(n) * f), f);
                }
                acroRenderer.getCompData().setPageValues(f, n3, (int)this.indent, this.displayOffsets.getUserOffsetX(), this.displayOffsets.getUserOffsetY(), n2, pageOffsets.widestPageNR, pageOffsets.widestPageR);
                acroRenderer.getCompData().resetScaledLocation(f, n3, (int)this.indent);
            }
        } else if (acroRenderer != null && pageOffsets != null) {
            this.lastIndent = -1;
            acroRenderer.getCompData().setPageValues(f, n3, (int)this.indent, this.displayOffsets.getUserOffsetX(), this.displayOffsets.getUserOffsetY(), n2, pageOffsets.widestPageNR, pageOffsets.widestPageR);
            acroRenderer.getCompData().resetScaledLocation(f, n3, (int)this.indent);
        }
        display.initRenderer(textLines.areas, graphics2D, border, (int)this.indent);
        display.drawPage(this.viewScaling, pdfDecoder.displayScaling, this.pageUsedForTransform);
        if (n2 == 1) {
            if (this.viewScaling != null) {
                graphics2D.transform(this.viewScaling);
            }
            if (this.cursorBoxOnScreen != null) {
                this.cursorAf = graphics2D.getTransform();
            }
            display.resetToDefaultClip();
        }
        if (n2 == 1) {
            SwingPainter.drawHighlightsForImage(graphics2D, display.getHighlightedImage(), f, n3, n4, n5, pdfDecoder.max_x, pdfDecoder.max_y);
        } else {
            display.setHighlightedImage(null);
        }
        display.drawBorder();
        graphics2D.setTransform(affineTransform);
        if (n2 == 1) {
            display.drawPreviewImage(graphics2D, rectangle);
        }
    }

    public void setCursorBoxOnScreen(Rectangle rectangle, boolean bl, AcroRenderer acroRenderer) {
        this.cursorBoxOnScreen = rectangle;
        if (!bl && acroRenderer != null) {
            acroRenderer.removeDisplayComponentsFromScreen();
            this.lastFormPage = -1;
        }
    }

    public Rectangle getCursorBoxOnScreen() {
        return this.cursorBoxOnScreen;
    }

    public void drawCursor(Graphics graphics, int n) {
        if (this.cursorBoxOnScreen != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            AffineTransform affineTransform = graphics2D.getTransform();
            if (this.cursorAf != null) {
                graphics2D.setTransform(this.cursorAf);
                Shape shape = graphics2D.getClip();
                if (n == 2 && shape != null) {
                    graphics2D.setClip(null);
                }
                if (this.cursorBoxOnScreen != null && PdfDecoder.showMouseBox) {
                    SwingPainter.paintRectangle(graphics2D, this.cursorBoxOnScreen, this.pdfDecoder.scaling, this.outlineColor);
                }
                this.lastCursorBoxOnScreen = this.cursorBoxOnScreen;
                graphics2D.setClip(shape);
                graphics2D.setTransform(affineTransform);
            }
        }
    }

    public final void updateCursorBoxOnScreen(Rectangle rectangle, Color color, PdfDecoder pdfDecoder, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        PdfPageData pdfPageData = pdfDecoder.getPdfPageData();
        int n6 = pdfDecoder.x_size;
        int n7 = pdfDecoder.y_size;
        if (rectangle != null) {
            int n8;
            n5 = rectangle.x;
            n4 = rectangle.y;
            n3 = rectangle.width;
            n2 = rectangle.height;
            int n9 = pdfPageData.getCropBoxX(n);
            int n10 = pdfPageData.getCropBoxY(n);
            int n11 = pdfPageData.getCropBoxWidth(n);
            int n12 = pdfPageData.getCropBoxHeight(n);
            if (n4 > 0 && n4 < n10) {
                n4 += n10;
            }
            if (n5 < n9) {
                n8 = n9 - n5;
                n3 -= n8;
                n5 = n9;
            }
            if (n4 < n10) {
                n8 = n10 - n4;
                n2 -= n8;
                n4 += n8;
            }
            if (n5 + n3 > n11 + n9) {
                n3 = n9 + n11 - n5;
            }
            if (n4 + n2 > n10 + n12) {
                n2 = n10 + n12 - n4;
            }
            this.cursorBoxOnScreen = new Rectangle(n5, n4, n3, n2);
        } else {
            this.cursorBoxOnScreen = null;
        }
        this.outlineColor = color;
        n5 = 30;
        n4 = 0;
        if (pdfDecoder.alignment == 2) {
            n3 = pdfDecoder.getBounds().width;
            n2 = pdfDecoder.getPDFWidth();
            if (pdfDecoder.displayView != 1) {
                n2 = (int)pdfDecoder.pages.getPageSize(pdfDecoder.displayView).getWidth();
            }
            n4 = (n3 - n2) / 2;
        }
        RepaintManager repaintManager = RepaintManager.currentManager(pdfDecoder);
        if (this.lastCursorBoxOnScreen != null) {
            if (pdfDecoder.displayRotation == 0 || pdfDecoder.displayRotation == 180) {
                repaintManager.addDirtyRegion(pdfDecoder, pdfDecoder.insetW + n4, pdfDecoder.insetH, n6 + 5, n7);
            } else {
                repaintManager.addDirtyRegion(pdfDecoder, pdfDecoder.insetH + n4, pdfDecoder.insetW, n7 + 5, n6);
            }
            this.lastCursorBoxOnScreen = null;
        }
        if (this.cursorBoxOnScreen != null) {
            repaintManager.addDirtyRegion(pdfDecoder, (int)((float)this.cursorBoxOnScreen.x * pdfDecoder.scaling) - n5, (int)((float)(pdfDecoder.max_y - this.cursorBoxOnScreen.y - this.cursorBoxOnScreen.height) * pdfDecoder.scaling) - n5, (int)((float)this.cursorBoxOnScreen.width * pdfDecoder.scaling) + n5 + n5, (int)((float)this.cursorBoxOnScreen.height * pdfDecoder.scaling) + n5 + n5);
        }
        if (this.viewScaling != null) {
            repaintManager.markCompletelyDirty(pdfDecoder);
        }
        pdfDecoder.repaint();
    }

    public double getIndent() {
        return this.indent;
    }

    public void setPageRotation(int n, PdfPageData pdfPageData) {
        this.pdfDecoder.displayRotation = n;
        if (this.pdfDecoder.displayView != 1) {
            n = 0;
        }
        this.pageUsedForTransform = this.pdfDecoder.pageNumber;
        this.pdfDecoder.displayScaling = this.pdfDecoder.displayView != 1 && this.pdfDecoder.displayView != 3 ? ScalingFactory.getScalingForImage(1, 0, this.pdfDecoder.scaling, pdfPageData) : ScalingFactory.getScalingForImage(this.pdfDecoder.pageNumber, n, this.pdfDecoder.scaling, pdfPageData);
        if (n == 90) {
            this.pdfDecoder.displayScaling.translate((float)this.pdfDecoder.insetH / this.pdfDecoder.scaling, (float)this.pdfDecoder.insetW / this.pdfDecoder.scaling);
        } else if (n == 270) {
            this.pdfDecoder.displayScaling.translate((float)(-this.pdfDecoder.insetH) / this.pdfDecoder.scaling, (float)(-this.pdfDecoder.insetW) / this.pdfDecoder.scaling);
        } else if (n == 180) {
            this.pdfDecoder.displayScaling.translate((float)(-this.pdfDecoder.insetW) / this.pdfDecoder.scaling, (float)this.pdfDecoder.insetH / this.pdfDecoder.scaling);
        } else {
            this.pdfDecoder.displayScaling.translate((float)this.pdfDecoder.insetW / this.pdfDecoder.scaling, (float)(-this.pdfDecoder.insetH) / this.pdfDecoder.scaling);
        }
        this.pdfDecoder.pages.refreshDisplay();
        if (this.viewableArea != null) {
            this.viewScaling = new AffineTransform();
            double d = (double)this.viewableArea.width / (double)pdfPageData.getCropBoxWidth(this.pdfDecoder.pageNumber);
            double d2 = (double)this.viewableArea.height / (double)pdfPageData.getCropBoxHeight(this.pdfDecoder.pageNumber);
            double d3 = d;
            if (d2 < d) {
                d3 = d2;
            }
            double d4 = this.viewableArea.x;
            double d5 = (double)this.viewableArea.y + ((double)this.viewableArea.height - (double)pdfPageData.getCropBoxHeight(this.pdfDecoder.pageNumber) * d3);
            this.viewScaling.translate(d4, d5);
            this.viewScaling.scale(d3, d3);
        } else {
            this.viewScaling = null;
        }
    }

    public AffineTransform setViewableArea(Rectangle rectangle, PdfDecoder pdfDecoder, PdfPageData pdfPageData) throws PdfException {
        if (rectangle != null) {
            double d = rectangle.getX();
            double d2 = rectangle.getY();
            double d3 = rectangle.getWidth();
            double d4 = rectangle.getHeight();
            double d5 = pdfPageData.getCropBoxWidth(pdfDecoder.pageNumber);
            double d6 = pdfPageData.getCropBoxHeight(pdfDecoder.pageNumber);
            if (d < 0.0 || d2 < 0.0 || d + d3 > d5 || d2 + d4 > d6) {
                throw new PdfException("Viewport is not totally enclosed within displayed panel.");
            }
            if (d5 != d3 || d6 != d4) {
                this.viewableArea = rectangle;
                this.setPageRotation(pdfDecoder.displayRotation, pdfPageData);
                pdfDecoder.repaint();
            }
        } else {
            this.resetViewableArea(pdfDecoder, pdfPageData);
        }
        return this.viewScaling;
    }

    public DisplayOffsets getDisplayOffsets() {
        return this.displayOffsets;
    }

    public void resetViewableArea(PdfDecoder pdfDecoder, PdfPageData pdfPageData) {
        if (this.viewableArea != null) {
            this.viewableArea = null;
            this.setPageRotation(pdfDecoder.displayRotation, pdfPageData);
            pdfDecoder.repaint();
        }
    }

    public void resetMultiPageForms(int n, PdfDecoder pdfDecoder, AcroRenderer acroRenderer, Display display) {
        acroRenderer.removeDisplayComponentsFromScreen();
        pdfDecoder.add((Component)display.getScroll(), "South");
        this.lastFormPage = -1;
        acroRenderer.displayComponentsOnscreen(n, n);
        if (acroRenderer.getCompData().getStartComponentCountForPage(n) != -1) {
            this.lastFormPage = n;
        }
    }

    public void forceRedraw() {
        this.lastFormPage = -1;
        this.lastEnd = -1;
        this.lastStart = -1;
    }

    private static void drawHighlightsForImage(Graphics2D graphics2D, int[] nArray, float f, int n, int n2, int n3, int n4, int n5) {
        if (nArray != null) {
            int n6;
            int n7;
            int n8 = (int)((float)nArray[0] * f);
            int n9 = (int)((float)nArray[1] * f);
            int n10 = (int)((float)nArray[2] * f);
            int n11 = (int)((float)nArray[3] * f);
            if (n10 < 0) {
                n10 = -n10;
                n8 -= n10;
            }
            if (n11 < 0) {
                n11 = -n11;
                n9 -= n11;
            }
            int n12 = n10;
            int n13 = n11;
            if (n == 90) {
                n13 = n10;
                n12 = n11;
                n7 = n2 + n9;
                n6 = n3 + n8;
            } else if (n == 180) {
                n7 = (int)((float)n4 * f - (float)n8 - (float)n10) + n2;
                n6 = n3 + n9;
            } else if (n == 270) {
                n13 = n10;
                n12 = n11;
                n6 = (int)((float)n4 * f - (float)n8 - (float)n10) + n2;
                n7 = (int)((float)n5 * f - (float)n9 - (float)n11) + n3;
            } else {
                n7 = n2 + n8;
                n6 = (int)((float)n5 * f - (float)n9 - (float)n11) + n3;
            }
            Color color = graphics2D.getColor();
            Composite composite = graphics2D.getComposite();
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(new BasicStroke(2.0f));
            graphics2D.setComposite(AlphaComposite.getInstance(3, PdfDecoder.highlightComposite));
            if (SwingDisplay.invertHighlight) {
                graphics2D.setColor(Color.WHITE);
                graphics2D.setXORMode(Color.BLACK);
            } else {
                graphics2D.setColor(DecoderOptions.highlightColor);
                graphics2D.drawRect(n7, n6, n12, n13);
            }
            graphics2D.fillRect(n7, n6, n12, n13);
            graphics2D.setColor(color);
            graphics2D.setComposite(composite);
            graphics2D.setStroke(stroke);
        }
    }

    private static void paintRectangle(Graphics2D graphics2D, Rectangle rectangle, float f, Color color) {
        Stroke stroke = graphics2D.getStroke();
        BasicStroke basicStroke = f < 0.0f ? new BasicStroke(1.0f / -f) : new BasicStroke(1.0f / f);
        graphics2D.setStroke(basicStroke);
        graphics2D.setColor(color);
        graphics2D.draw(rectangle);
        graphics2D.setStroke(stroke);
    }

    public static BufferedImage getSelectedRectangleOnscreen(float f, float f2, float f3, float f4, float f5, int n, PdfPageData pdfPageData, AcroRenderer acroRenderer, DynamicVectorRenderer dynamicVectorRenderer, PdfObjectReader pdfObjectReader) {
        int n2 = pdfPageData.getMediaBoxHeight(n);
        int n3 = pdfPageData.getCropBoxWidth(n);
        int n4 = pdfPageData.getCropBoxHeight(n);
        int n5 = pdfPageData.getCropBoxX(n);
        int n6 = pdfPageData.getCropBoxY(n);
        if (f4 < (float)n6) {
            f4 = n6;
        }
        if (f < (float)n5) {
            f = n5;
        }
        if (f2 > (float)(n4 + n6)) {
            f2 = n4 + n6;
        }
        if (f3 > (float)(n5 + n3)) {
            f3 = n5 + n3;
        }
        if (f3 - f < 1.0f || f2 - f4 < 1.0f) {
            return null;
        }
        float f6 = f5 / 100.0f;
        float f7 = f3 - f;
        float f8 = f2 - f4;
        BufferedImage bufferedImage = new BufferedImage((int)(f7 * f6), (int)(f8 * f6), 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (n6 > 0) {
            n6 = n2 - n4 - n6;
        }
        AffineTransform affineTransform = ScalingFactory.getScalingForImage(n, 0, f6, pdfPageData);
        int n7 = -n5;
        int n8 = -n6;
        affineTransform.translate(n7, -n8);
        affineTransform.translate(-(f - (float)n5), (float)n2 - f2 - (float)n6);
        AffineTransform affineTransform2 = graphics2D.getTransform();
        graphics2D.transform(affineTransform);
        dynamicVectorRenderer.setG2(graphics2D);
        dynamicVectorRenderer.paintBackground(new Rectangle(n5, n6, n3, n4));
        dynamicVectorRenderer.setOptimsePainting(true);
        dynamicVectorRenderer.paint(null, null, null);
        if (acroRenderer != null && acroRenderer.hasFormsOnPage(n)) {
            acroRenderer.getCompData().renderFormsOntoG2(graphics2D, n, f5, 0, 0, null, null, pdfObjectReader, pdfPageData.getMediaBoxHeight(n));
        }
        graphics2D.setTransform(affineTransform2);
        graphics2D.dispose();
        return bufferedImage;
    }
}

