/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.cluster.view.internal;

import de.rcenvironment.core.gui.cluster.configuration.internal.ClusterConnectionConfigurationDialogsController;
import de.rcenvironment.core.gui.cluster.internal.ErrorMessageDialogFactory;
import de.rcenvironment.core.gui.cluster.view.internal.ClusterConnectionInformation;
import de.rcenvironment.core.gui.cluster.view.internal.ClusterJobInformationContentProvider;
import de.rcenvironment.core.gui.cluster.view.internal.ClusterJobInformationLabelProvider;
import de.rcenvironment.core.gui.cluster.view.internal.ClusterJobInformationModel;
import de.rcenvironment.core.gui.cluster.view.internal.ClusterJobInformationTableColumnSorter;
import de.rcenvironment.core.gui.cluster.view.internal.ClusterJobInformationTableFilter;
import de.rcenvironment.core.gui.cluster.view.internal.KillClusterJobListenerListener;
import de.rcenvironment.core.gui.cluster.view.internal.Messages;
import de.rcenvironment.core.utils.cluster.ClusterService;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.IOException;
import java.net.URL;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;

public class ClusterJobMonitorView
extends ViewPart {
    private static final String CONNECTING_TO_CLUSTER_FAILED = "Connecting to cluster failed";
    private static final String FETCHING_CLUSTER_JOB_INFORMATION_FAILED = "Fetching cluster job information failed";
    private static final int COLUMN_WIDTH = 120;
    private static final int COLUMN_WIDTH_JOBSTATE = 100;
    private static final int NO_SPACE = 0;
    private static final int PLATFORM_WIDTH = 250;
    private static final int TEXT_WIDTH = 250;
    private static final int DELAY = 30000;
    private static final Log LOGGER = LogFactory.getLog(ClusterJobMonitorView.class);
    private Button othersCheckbox;
    private Button runningCheckbox;
    private Button queuedCheckbox;
    private Combo connectedConfigurationNameCombo;
    private ClusterJobInformationTableFilter tableRowFilter;
    private ClusterJobInformationTableColumnSorter tableColumnSorter;
    private TableViewer jobInformationTableViewer;
    private Text searchText;
    private Composite parent;
    private Timer getUpdateTimer;
    private volatile boolean getUpdateTimerTaskScheduled = false;
    private final Action connectAction = new Action(Messages.connectToolTip, ImageDescriptor.createFromURL((URL)ClusterJobMonitorView.class.getResource("/resources/icons/connect16.png"))){

        public void run() {
            final ClusterConnectionConfigurationDialogsController controller = new ClusterConnectionConfigurationDialogsController(ClusterJobMonitorView.this.parent);
            final ClusterConnectionInformation connectionInformation = controller.openClusterConnectionSelectionDialog();
            if (connectionInformation != null) {
                BusyIndicator.showWhile((Display)ClusterJobMonitorView.this.jobInformationTableViewer.getTable().getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        String clusterConfigurationName = controller.getClusterConfigurationName();
                        ClusterService clusterInformationService = controller.getClusterJobInformationService();
                        if (ClusterJobMonitorView.this.updateModelForFirstTime(clusterConfigurationName, clusterInformationService, connectionInformation)) {
                            ClusterJobMonitorView.this.refreshView(clusterConfigurationName);
                            ClusterJobMonitorView.this.scheduleGetUpdateOfClusterJobInformationTimerIfNeeded();
                        }
                    }
                });
            }
        }
    };
    private final Action disconnectAction = new Action(Messages.disconnectToolTip, ImageDescriptor.createFromURL((URL)ClusterJobMonitorView.class.getResource("/resources/icons/disconnect16.png"))){

        public void run() {
            String clusterConfigurationName = ClusterJobMonitorView.this.connectedConfigurationNameCombo.getItem(ClusterJobMonitorView.this.connectedConfigurationNameCombo.getSelectionIndex());
            ClusterJobInformationModel model = ClusterJobInformationModel.getInstance();
            model.removeConnectedCluster(clusterConfigurationName);
            ClusterJobMonitorView.this.refreshConnectedClusterComboAndToolBar(null);
            clusterConfigurationName = ClusterJobMonitorView.this.connectedConfigurationNameCombo.getItem(ClusterJobMonitorView.this.connectedConfigurationNameCombo.getSelectionIndex());
            model.setSelectedConnectedConfigurationName(clusterConfigurationName);
            ClusterJobMonitorView.this.refreshClusterJobInformationTableViewer();
            ClusterJobMonitorView.this.cancelUpdateClusterJobInformationTimerIfNeeded();
        }
    };
    private final Action refreshAction = new Action(Messages.refreshToolTip, ImageDescriptor.createFromURL((URL)ClusterJobMonitorView.class.getResource("/resources/icons/refresh.gif"))){

        public void run() {
            BusyIndicator.showWhile((Display)ClusterJobMonitorView.this.jobInformationTableViewer.getTable().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    ClusterJobMonitorView.this.getUpdateOfClusterJobInformation();
                    ClusterJobMonitorView.this.refreshClusterJobInformationTableViewer();
                }
            });
        }
    };
    private final Action informationAction = new Action(Messages.informationToolTip, ImageDescriptor.createFromURL((URL)ClusterJobMonitorView.class.getResource("/resources/icons/information.gif"))){

        public void run() {
            ClusterJobInformationModel model = ClusterJobInformationModel.getInstance();
            String connectedConfigurationName = ClusterJobMonitorView.this.connectedConfigurationNameCombo.getItem(ClusterJobMonitorView.this.connectedConfigurationNameCombo.getSelectionIndex());
            ClusterConnectionInformation connectionInformation = model.getClusterConnectionInformation(connectedConfigurationName);
            MessageDialog dialog = new MessageDialog(ClusterJobMonitorView.this.parent.getShell(), Messages.informationDialogTitle, null, StringUtils.format((String)Messages.informationDialogMessage, (Object[])new Object[]{connectionInformation.getHost(), connectionInformation.getUsername(), connectionInformation.getConnectedDate(), connectionInformation.getLastUpdateDate(), connectionInformation.getUpdateInterval()}), 2, new String[]{Messages.ok}, 0);
            dialog.open();
        }
    };

    public void createPartControl(Composite aParent) {
        this.parent = aParent;
        aParent.setLayout((Layout)new GridLayout(1, false));
        Composite filterComposite = new Composite(aParent, 0);
        filterComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        filterComposite.setLayout((Layout)new RowLayout());
        this.createConnectedClusterListingArrangement(filterComposite);
        this.createLevelArrangement(filterComposite);
        this.createSearchArrangement(filterComposite);
        this.createTableArrangement(aParent);
        this.tableColumnSorter = new ClusterJobInformationTableColumnSorter();
        this.jobInformationTableViewer.setSorter((ViewerSorter)this.tableColumnSorter);
        this.tableRowFilter = new ClusterJobInformationTableFilter(this, this.jobInformationTableViewer);
        this.searchText.addKeyListener((KeyListener)this.tableRowFilter);
        this.queuedCheckbox.addSelectionListener((SelectionListener)this.tableRowFilter);
        this.runningCheckbox.addSelectionListener((SelectionListener)this.tableRowFilter);
        this.othersCheckbox.addSelectionListener((SelectionListener)this.tableRowFilter);
        this.connectedConfigurationNameCombo.addSelectionListener((SelectionListener)this.tableRowFilter);
        this.jobInformationTableViewer.addFilter((ViewerFilter)this.tableRowFilter);
        Action[] actionArray = this.createToolbarActions();
        int n = actionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Action action = actionArray[n2];
            this.getViewSite().getActionBars().getToolBarManager().add((IAction)action);
            ++n2;
        }
        String[] connectedConfigurationNames = ClusterJobInformationModel.getInstance().getConnectedConfigurationNames();
        boolean enabled = connectedConfigurationNames.length > 0 && !connectedConfigurationNames[0].equals(ClusterJobInformationModel.NOT_CONNECTED);
        this.disconnectAction.setEnabled(enabled);
        this.refreshAction.setEnabled(enabled);
        this.informationAction.setEnabled(enabled);
    }

    public void setFocus() {
        this.jobInformationTableViewer.getControl().setFocus();
        this.scheduleGetUpdateOfClusterJobInformationTimerIfNeeded();
    }

    public void dispose() {
        this.cancelUpdateClusterJobInformationTimerIfNeeded();
    }

    public boolean getQueuedSelection() {
        return this.queuedCheckbox.getSelection();
    }

    public boolean getRunningSelection() {
        return this.runningCheckbox.getSelection();
    }

    public boolean getOthersSelection() {
        return this.othersCheckbox.getSelection();
    }

    public String getSelectedConnectedConfigurationName() {
        return this.connectedConfigurationNameCombo.getItem(this.connectedConfigurationNameCombo.getSelectionIndex());
    }

    public String getSearchText() {
        return this.searchText.getText();
    }

    private Action[] createToolbarActions() {
        return new Action[]{this.connectAction, this.disconnectAction, this.refreshAction, this.informationAction};
    }

    private void createLevelArrangement(Composite filterComposite) {
        RowLayout rowLayout = new RowLayout();
        rowLayout.spacing = 0;
        filterComposite.setLayout((Layout)rowLayout);
        this.queuedCheckbox = new Button(filterComposite, 32);
        this.queuedCheckbox.setText(Messages.queuedFilter);
        this.queuedCheckbox.setSelection(true);
        this.runningCheckbox = new Button(filterComposite, 32);
        this.runningCheckbox.setText(Messages.runningFilter);
        this.runningCheckbox.setSelection(true);
        this.othersCheckbox = new Button(filterComposite, 32);
        this.othersCheckbox.setText(Messages.othersFilter);
        this.othersCheckbox.setSelection(true);
    }

    private void createConnectedClusterListingArrangement(Composite connectedClusterComposite) {
        RowLayout rowLayout = new RowLayout();
        rowLayout.spacing = 0;
        connectedClusterComposite.setLayout((Layout)rowLayout);
        this.connectedConfigurationNameCombo = new Combo(connectedClusterComposite, 12);
        this.connectedConfigurationNameCombo.setLayoutData((Object)new RowData(250, -1));
        this.connectedConfigurationNameCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                ClusterJobInformationModel.getInstance().setSelectedConnectedConfigurationName(ClusterJobMonitorView.this.connectedConfigurationNameCombo.getItem(ClusterJobMonitorView.this.connectedConfigurationNameCombo.getSelectionIndex()));
                ClusterJobMonitorView.this.refreshClusterJobInformationTableViewer();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
        this.refreshConnectedClusterComboAndToolBar(null);
    }

    private void createSearchArrangement(Composite searchComposite) {
        RowLayout rowLayout = new RowLayout();
        rowLayout.spacing = 7;
        searchComposite.setLayout((Layout)rowLayout);
        this.searchText = new Text(searchComposite, 128);
        this.searchText.setMessage(Messages.searchFilter);
        this.searchText.setSize(250, -1);
        this.searchText.setLayoutData((Object)new RowData(250, -1));
    }

    private void createTableArrangement(Composite tableComposite) {
        tableComposite.setLayout((Layout)new GridLayout());
        this.jobInformationTableViewer = new TableViewer(tableComposite, 66306);
        this.jobInformationTableViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        String[] columnTitles = new String[]{Messages.columnJobId, Messages.columnJobName, Messages.columnUser, Messages.columnQueue, Messages.columnRemainingTime, Messages.columnStartTime, Messages.columnQueueTime, Messages.columnJobState};
        int[] bounds = new int[]{120, 120, 120, 120, 120, 120, 120, 100};
        int i = 0;
        while (i < columnTitles.length) {
            final int index = i;
            TableViewerColumn viewerColumn = new TableViewerColumn(this.jobInformationTableViewer, 0);
            final TableColumn column = viewerColumn.getColumn();
            column.setText(columnTitles[i]);
            column.setWidth(bounds[i]);
            column.setResizable(true);
            column.setMoveable(true);
            column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ClusterJobMonitorView.this.tableColumnSorter.setColumn(index);
                    int direction = ClusterJobMonitorView.this.jobInformationTableViewer.getTable().getSortDirection();
                    direction = ClusterJobMonitorView.this.jobInformationTableViewer.getTable().getSortColumn() == column ? (direction == 128 ? 1024 : 128) : 128;
                    ClusterJobMonitorView.this.jobInformationTableViewer.getTable().setSortDirection(direction);
                    ClusterJobMonitorView.this.jobInformationTableViewer.getTable().setSortColumn(column);
                    ClusterJobMonitorView.this.refreshClusterJobInformationTableViewer();
                }
            });
            ++i;
        }
        this.jobInformationTableViewer.setContentProvider((IContentProvider)new ClusterJobInformationContentProvider());
        this.jobInformationTableViewer.setLabelProvider((IBaseLabelProvider)new ClusterJobInformationLabelProvider());
        this.jobInformationTableViewer.setInput((Object)ClusterJobInformationModel.getInstance());
        final Table table = this.jobInformationTableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        Menu contextMenu = new Menu((Control)tableComposite);
        final MenuItem killJobItem = new MenuItem(contextMenu, 8);
        killJobItem.setText(Messages.cancelJob);
        killJobItem.setEnabled(table.getSelectionCount() > 0);
        killJobItem.addSelectionListener((SelectionListener)new KillClusterJobListenerListener(this.jobInformationTableViewer, this.refreshAction));
        this.jobInformationTableViewer.getControl().setMenu(contextMenu);
        table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                killJobItem.setEnabled(table.getSelectionCount() > 0);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
    }

    private synchronized void getUpdateOfClusterJobInformation() {
        try {
            ClusterJobInformationModel.getInstance().getUpdateFromCluster();
        }
        catch (IOException e) {
            this.jobInformationTableViewer.getTable().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    LOGGER.error((Object)ClusterJobMonitorView.FETCHING_CLUSTER_JOB_INFORMATION_FAILED, (Throwable)e);
                    ClusterJobMonitorView.this.disconnectAction.run();
                    ErrorMessageDialogFactory.createMessageDialogForFetchingFailure(ClusterJobMonitorView.this.parent).open();
                }
            });
        }
    }

    private boolean updateModelForFirstTime(String connectedClusterConfigurationName, ClusterService clusterInformationService, ClusterConnectionInformation connectionInformation) {
        ClusterJobInformationModel model = ClusterJobInformationModel.getInstance();
        model.addConnectedCluster(connectedClusterConfigurationName, clusterInformationService);
        connectionInformation.setUpdateInterval(60);
        model.addClusterConnectionInformation(connectedClusterConfigurationName, connectionInformation);
        model.setSelectedConnectedConfigurationName(connectedClusterConfigurationName);
        try {
            model.getUpdateFromCluster();
        }
        catch (IOException e) {
            ErrorMessageDialogFactory.createMessageDialogForConnectionFailure(this.parent, e).open();
            LOGGER.error((Object)CONNECTING_TO_CLUSTER_FAILED, (Throwable)e);
            model.removeConnectedCluster(connectedClusterConfigurationName);
            return false;
        }
        return true;
    }

    private void refreshView(String connectedClusterConfigurationName) {
        this.refreshConnectedClusterComboAndToolBar(connectedClusterConfigurationName);
        this.refreshClusterJobInformationTableViewer();
    }

    private void refreshConnectedClusterComboAndToolBar(String connectedClusterConfigurationName) {
        this.connectedConfigurationNameCombo.setItems(ClusterJobInformationModel.getInstance().getConnectedConfigurationNames());
        if (connectedClusterConfigurationName != null && !connectedClusterConfigurationName.isEmpty()) {
            this.connectedConfigurationNameCombo.select(this.connectedConfigurationNameCombo.indexOf(connectedClusterConfigurationName));
            this.disconnectAction.setEnabled(true);
            this.refreshAction.setEnabled(true);
            this.informationAction.setEnabled(true);
        } else {
            this.connectedConfigurationNameCombo.select(0);
            if (!this.isConnectedToAtLeastOneCluster()) {
                this.disconnectAction.setEnabled(false);
                this.refreshAction.setEnabled(false);
                this.informationAction.setEnabled(false);
            }
        }
    }

    private void refreshClusterJobInformationTableViewer() {
        this.jobInformationTableViewer.getTable().clearAll();
        this.jobInformationTableViewer.refresh();
    }

    private void scheduleGetUpdateOfClusterJobInformationTimerIfNeeded() {
        if (!this.getUpdateTimerTaskScheduled && this.isConnectedToAtLeastOneCluster()) {
            TimerTask getUpdateTimerTask = new TimerTask(){

                @Override
                public void run() {
                    Job job = new Job(Messages.updateJobTitle){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                monitor.beginTask(Messages.updateJobMessage, 3);
                                monitor.worked(1);
                                ClusterJobMonitorView.this.getUpdateOfClusterJobInformation();
                                monitor.worked(2);
                                if (!(this).ClusterJobMonitorView.this.jobInformationTableViewer.getTable().isDisposed()) {
                                    (this).ClusterJobMonitorView.this.jobInformationTableViewer.getTable().getDisplay().asyncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            ClusterJobMonitorView.this.refreshClusterJobInformationTableViewer();
                                        }
                                    });
                                }
                            }
                            finally {
                                monitor.done();
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    job.setUser(false);
                    job.schedule();
                }
            };
            this.getUpdateTimer = new Timer("Get Update (Cluster Job Information) Timer", true);
            this.getUpdateTimer.schedule(getUpdateTimerTask, 30000L, 60000L);
            this.getUpdateTimerTaskScheduled = true;
        }
    }

    private void cancelUpdateClusterJobInformationTimerIfNeeded() {
        if (this.getUpdateTimerTaskScheduled && !this.isConnectedToAtLeastOneCluster()) {
            this.getUpdateTimer.cancel();
            this.getUpdateTimerTaskScheduled = false;
        }
    }

    private boolean isConnectedToAtLeastOneCluster() {
        return !this.connectedConfigurationNameCombo.getItem(this.connectedConfigurationNameCombo.getSelectionIndex()).equals(ClusterJobInformationModel.NOT_CONNECTED);
    }
}

