/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.workflow.execution.function;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.datamanagement.api.ComponentDataManagementService;
import de.rcenvironment.core.component.execution.api.ComponentContext;
import de.rcenvironment.core.component.model.spi.DefaultComponent;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.api.TypedDatumSerializer;
import de.rcenvironment.core.datamodel.api.TypedDatumService;
import de.rcenvironment.core.datamodel.types.api.ShortTextTD;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.LogFactory;

public class InputAdapterComponent
extends DefaultComponent {
    private ComponentContext context;

    public boolean treatStartAsComponentRun() {
        return !this.context.getOutputs().isEmpty();
    }

    public void setComponentContext(ComponentContext componentContext) {
        this.context = componentContext;
    }

    public void start() throws ComponentException {
        String inputDirectoryPath = this.context.getConfigurationValue("inputFolder");
        this.logInfo(StringUtils.format((String)"Reading from input directory %s", (Object[])new Object[]{inputDirectoryPath}));
        Map<String, String> inputValueMap = this.readInputMapFromInputDirectory(inputDirectoryPath);
        this.writeAllInputsToOutputs(inputValueMap);
    }

    private void writeAllInputsToOutputs(Map<String, String> inputValueMap) throws ComponentException {
        for (Map.Entry<String, String> input : inputValueMap.entrySet()) {
            TypedDatum datumToWriteToOutput;
            DataType dataType = this.context.getOutputDataType(input.getKey());
            String inputValue = input.getValue();
            if (dataType.equals((Object)DataType.FileReference)) {
                ShortTextTD filePath = (ShortTextTD)this.getTypedDatumSerializer().deserialize(inputValue);
                datumToWriteToOutput = this.loadLocalFileIntoDataManagement(filePath);
            } else if (dataType.equals((Object)DataType.DirectoryReference)) {
                ShortTextTD directoryPath = (ShortTextTD)this.getTypedDatumSerializer().deserialize(inputValue);
                datumToWriteToOutput = this.loadLocalDirectoryIntoDataManagement(directoryPath.getShortTextValue());
            } else {
                datumToWriteToOutput = this.getTypedDatumSerializer().deserialize(inputValue.toString());
            }
            this.context.writeOutput(input.getKey(), datumToWriteToOutput);
        }
    }

    protected Map<String, String> readInputMapFromInputDirectory(String inputDirectoryPath) throws ComponentException {
        Map inputValueMap;
        File inputConfiguration = new File(new File(inputDirectoryPath), "inputs.json");
        try {
            inputValueMap = (Map)new ObjectMapper().readValue(inputConfiguration, Map.class);
        }
        catch (IOException e) {
            throw new ComponentException(StringUtils.format((String)"Could not read input values from file '%s'", (Object[])new Object[]{inputConfiguration}), (Throwable)e);
        }
        LogFactory.getLog(((Object)((Object)this)).getClass()).debug((Object)StringUtils.format((String)"Read input values '%s'", (Object[])new Object[]{inputValueMap}));
        return inputValueMap;
    }

    private TypedDatum loadLocalFileIntoDataManagement(ShortTextTD filePath) throws ComponentException {
        try {
            File fileToLoad = new File(filePath.getShortTextValue());
            String logMessage = StringUtils.format((String)"Read file at '%s' into datamanagement", (Object[])new Object[]{fileToLoad.getAbsolutePath()});
            this.logInfo(logMessage);
            return this.getComponentDataManagementService().createFileReferenceTDFromLocalFile(this.context, fileToLoad, fileToLoad.getName());
        }
        catch (IOException e) {
            throw new ComponentException("Could not store file into local data management", (Throwable)e);
        }
    }

    private TypedDatum loadLocalDirectoryIntoDataManagement(String directoryPathString) throws ComponentException {
        try {
            File dirToLoad = new File(directoryPathString);
            String logMessage = StringUtils.format((String)"Read directory at '%s' into datamanagement", (Object[])new Object[]{dirToLoad.getAbsolutePath()});
            this.logInfo(logMessage);
            return this.getComponentDataManagementService().createDirectoryReferenceTDFromLocalDirectory(this.context, dirToLoad, dirToLoad.getName());
        }
        catch (IOException e) {
            throw new ComponentException("Could not store directory into local data management", (Throwable)e);
        }
    }

    private TypedDatumSerializer getTypedDatumSerializer() {
        return ((TypedDatumService)this.context.getService(TypedDatumService.class)).getSerializer();
    }

    private ComponentDataManagementService getComponentDataManagementService() {
        return (ComponentDataManagementService)this.context.getService(ComponentDataManagementService.class);
    }

    private void logInfo(String logMessage) {
        LogFactory.getLog(((Object)((Object)this)).getClass()).info((Object)logMessage);
    }
}

