/*
 * Decompiled with CFR 0.152.
 */
package nu.psnet.quickimage.widgets;

import java.text.DecimalFormat;
import nu.psnet.quickimage.core.ImageHolder;
import nu.psnet.quickimage.core.QManager;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class QStatusCanvas
extends Canvas {
    private String filesize = "";
    private int height = 0;
    private int width = 0;
    private String filename = "";
    private int depth = 0;
    private Image image;
    private DecimalFormat df = new DecimalFormat("0.000");
    private Color COLOR_DARK_GRAY;
    private QManager manager;

    public QStatusCanvas(QManager manager, Composite parent, int style) {
        super(parent, style | 0x800000);
        this.manager = manager;
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                QStatusCanvas.this.paint(event.gc);
            }
        });
        this.COLOR_DARK_GRAY = parent.getDisplay().getSystemColor(16);
    }

    public void updateWithCurrent() {
        if (this.manager.getImageOrganizer().getActiveView() == 1) {
            this.image = this.manager.getImageOrganizer().getCurrent().getFullsize();
            if (this.image != null) {
                this.depth = this.image.getImageData().depth;
                this.width = this.image.getBounds().width;
                this.height = this.image.getBounds().height;
            }
        }
        ImageHolder holder = this.manager.getImageOrganizer().getCurrent();
        this.filename = holder.getDisplayName();
        this.filesize = this.df.format(holder.getImageSize());
        if (holder.getImageSize() == 0.0) {
            this.filesize = "unknown";
        }
        this.redraw();
    }

    void paint(GC gc) {
        if (this.manager.getImageOrganizer().getActiveView() == 1) {
            gc.drawString("Size (kb): " + this.filesize, 5, 1);
            gc.drawString("Depth: " + this.depth, 140, 1);
            gc.drawString(String.valueOf(this.width) + " x " + this.height, 225, 1);
            gc.drawString("Name: " + this.filename, 325, 1);
            gc.setForeground(this.COLOR_DARK_GRAY);
            gc.drawLine(135, 0, 135, 24);
            gc.drawLine(210, 0, 210, 24);
            gc.drawLine(320, 0, 320, 24);
        } else {
            gc.drawString("Size (kb): " + this.filesize, 5, 1);
            gc.drawString("Name: " + this.filename, 140, 1);
            gc.setForeground(this.COLOR_DARK_GRAY);
            gc.drawLine(135, 0, 135, 24);
        }
    }
}

