/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.script.execution;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.rcenvironment.core.component.update.api.PersistentComponentDescription;
import de.rcenvironment.core.component.update.spi.PersistentComponentDescriptionUpdater;
import de.rcenvironment.core.utils.common.JsonUtils;
import java.io.IOException;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PythonToScriptingPersistentComponentDescriptionUpdater
implements PersistentComponentDescriptionUpdater {
    private static final String V2_9 = "2.9";
    private final String currentVersion = "3.0";

    public String[] getComponentIdentifiersAffectedByUpdate() {
        return new String[]{"de.rcenvironment.rce.components.python.PythonComponent_Python"};
    }

    public int getFormatVersionsAffectedByUpdate(String persistentComponentDescriptionVersion, boolean silent) {
        int versionsToUpdate = 0;
        if (!(silent || persistentComponentDescriptionVersion != null && persistentComponentDescriptionVersion.compareTo(V2_9) >= 0)) {
            versionsToUpdate |= 1;
        }
        if (!silent && persistentComponentDescriptionVersion != null && persistentComponentDescriptionVersion.compareTo("3.0") < 0) {
            versionsToUpdate |= 2;
        }
        return versionsToUpdate;
    }

    public PersistentComponentDescription performComponentDescriptionUpdate(int formatVersion, PersistentComponentDescription description, boolean silent) throws IOException {
        if (!silent) {
            JsonFactory jsonFactory = new JsonFactory();
            JsonParser jsonParser = jsonFactory.createParser(description.getComponentDescriptionAsString());
            ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
            JsonNode node = (JsonNode)mapper.readTree(jsonParser);
            if (formatVersion == 1) {
                return this.firstUpdate(node, mapper, description);
            }
        }
        return description;
    }

    private PersistentComponentDescription firstUpdate(JsonNode node, ObjectMapper mapper, PersistentComponentDescription description) throws JsonParseException, JsonGenerationException, JsonMappingException, IOException {
        JsonNode configurationValueNode;
        JsonNode configurationNode = node.get("configuration");
        Iterator nodeIterator = configurationNode.elements();
        int index = 0;
        while (nodeIterator.hasNext()) {
            configurationValueNode = (JsonNode)nodeIterator.next();
            if (configurationValueNode.textValue().startsWith("pythonInstallation:java.lang.String:")) break;
            ++index;
        }
        ((ArrayNode)configurationNode).remove(index);
        ((ArrayNode)configurationNode).add("pythonExecutionPath:java.lang.String:${pythonExecutionPath}");
        ((ArrayNode)configurationNode).add("scriptLanguage:java.lang.String:Python");
        nodeIterator = configurationNode.elements();
        index = 0;
        while (nodeIterator.hasNext()) {
            configurationValueNode = (JsonNode)nodeIterator.next();
            if (configurationValueNode.textValue().startsWith("script:java.lang.String:")) break;
            ++index;
        }
        String script = configurationNode.get(index).textValue();
        Pattern p = Pattern.compile("(_dm_\\[\".*\"\\])");
        Matcher m = p.matcher(script);
        while (m.find()) {
            String group = m.group(1);
            String name = group.substring(group.indexOf("\"") + 1, group.lastIndexOf("\""));
            script = String.valueOf(script.substring(0, script.indexOf(group))) + name + script.substring(script.indexOf(group) + group.length());
        }
        ((ArrayNode)configurationNode).remove(index);
        ((ArrayNode)configurationNode).add(script);
        JsonNode componentNode = node.get("component");
        ((ObjectNode)componentNode).remove("identifier");
        ((ObjectNode)componentNode).put("identifier", "de.rcenvironment.script");
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        description = new PersistentComponentDescription(writer.writeValueAsString((Object)node));
        description.setComponentVersion(V2_9);
        return description;
    }
}

