/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.authorization.api;

import de.rcenvironment.core.authorization.api.AuthorizationAccessGroup;
import de.rcenvironment.core.authorization.api.AuthorizationAccessGroupKeyData;
import de.rcenvironment.core.authorization.api.AuthorizationAccessGroupListener;
import de.rcenvironment.core.authorization.api.AuthorizationPermissionSet;
import de.rcenvironment.core.authorization.api.DefaultAuthorizationObjects;
import de.rcenvironment.core.authorization.cryptography.api.CryptographyOperationsProvider;
import de.rcenvironment.core.utils.common.exception.OperationFailureException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public interface AuthorizationService {
    public static final String ID_SEPARATOR = ":";
    public static final int GROUP_ID_SUFFIX_LENGTH = 16;
    public static final String GROUP_KEY_FILE_IMPORT_SUBDIRECTORY = "auth-group-keys";
    public static final String GROUP_KEY_FILE_IMPORT_DELETION_PREFIX = "delete ";

    public DefaultAuthorizationObjects getDefaultAuthorizationObjects();

    public CryptographyOperationsProvider getCryptographyOperationsProvider();

    public AuthorizationPermissionSet buildPermissionSet(AuthorizationAccessGroup ... var1);

    public AuthorizationPermissionSet buildPermissionSet(Collection<AuthorizationAccessGroup> var1);

    public List<AuthorizationAccessGroup> listAccessibleGroups(boolean var1);

    public boolean isValidGroupName(String var1);

    public AuthorizationAccessGroup createLocalGroup(String var1) throws OperationFailureException;

    public AuthorizationAccessGroup findLocalGroupById(String var1) throws OperationFailureException;

    public AuthorizationAccessGroup representRemoteGroupId(String var1) throws OperationFailureException;

    public Set<AuthorizationAccessGroup> representRemoteGroupIds(Collection<String> var1) throws OperationFailureException;

    public Set<AuthorizationAccessGroup> intersectWithAccessibleGroups(Set<AuthorizationAccessGroup> var1);

    public AuthorizationAccessGroupKeyData getKeyDataForGroup(AuthorizationAccessGroup var1);

    public void deleteLocalGroupData(AuthorizationAccessGroup var1);

    public boolean isGroupAccessible(AuthorizationAccessGroup var1);

    public String exportToString(AuthorizationAccessGroup var1);

    public AuthorizationAccessGroup importFromString(String var1) throws OperationFailureException;

    public void addAuthorizationAccessGroupListener(AuthorizationAccessGroupListener var1);

    public void removeAuthorizationAccessGroupListener(AuthorizationAccessGroupListener var1);

    public boolean isPersistentStorageAvailable();

    public boolean isPublicAccessGroup(AuthorizationAccessGroup var1);
}

