/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.joiner.gui;

import de.rcenvironment.core.component.model.configuration.api.ConfigurationDescription;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodeCommand;
import java.util.HashMap;

public class JoinerAddOrRemoveDynamicEndpointsCommand
extends WorkflowNodeCommand {
    private final int newCount;
    private int oldInputCount;
    private DataType dataType;

    public JoinerAddOrRemoveDynamicEndpointsCommand(int newCount) {
        this.newCount = newCount;
    }

    public void initialize() {
        ConfigurationDescription config = this.getProperties().getConfigurationDescription();
        this.oldInputCount = Integer.valueOf(config.getConfigurationValue("inputCount"));
        this.dataType = DataType.valueOf((String)config.getConfigurationValue("datatype"));
    }

    public boolean canExecute() {
        return true;
    }

    public boolean canUndo() {
        return true;
    }

    public void execute() {
        if (this.newCount > this.oldInputCount) {
            int i = this.oldInputCount + 1;
            while (i <= this.newCount) {
                this.getWorkflowNode().getInputDescriptionsManager().addDynamicEndpointDescription("toJoin", "Input " + this.getString(i), this.dataType, new HashMap());
                ++i;
            }
        } else if (this.newCount < this.oldInputCount) {
            int i = this.oldInputCount;
            while (i > this.newCount && i > 1) {
                this.getWorkflowNode().getInputDescriptionsManager().removeDynamicEndpointDescription("Input " + this.getString(i));
                --i;
            }
        }
        this.getProperties().getConfigurationDescription().setConfigurationValue("inputCount", String.valueOf(this.newCount));
    }

    public void undo() {
        if (this.newCount > this.oldInputCount) {
            int i = this.oldInputCount + 1;
            while (i <= this.newCount) {
                this.getWorkflowNode().getInputDescriptionsManager().removeDynamicEndpointDescription("Input " + this.getString(i));
                ++i;
            }
        } else if (this.newCount < this.oldInputCount) {
            int i = this.oldInputCount;
            while (i > this.newCount && i > 1) {
                this.getWorkflowNode().getInputDescriptionsManager().addDynamicEndpointDescription("toJoin", "Input " + this.getString(i), this.dataType, new HashMap());
                --i;
            }
        }
        this.getProperties().getConfigurationDescription().setConfigurationValue("inputCount", String.valueOf(this.oldInputCount));
    }

    private String getString(int i) {
        String result = "";
        if (i < 10) {
            result = String.valueOf(result) + "0";
        }
        if (i < 100) {
            result = String.valueOf(result) + "0";
        }
        result = String.valueOf(result) + i;
        return result;
    }
}

