/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.view.properties;

import de.rcenvironment.core.component.model.endpoint.api.EndpointDatum;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionInformation;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.types.api.DirectoryReferenceTD;
import de.rcenvironment.core.datamodel.types.api.FileReferenceTD;
import de.rcenvironment.core.datamodel.types.api.MatrixTD;
import de.rcenvironment.core.datamodel.types.api.ShortTextTD;
import de.rcenvironment.core.datamodel.types.api.SmallTableTD;
import de.rcenvironment.core.datamodel.types.api.VectorTD;
import de.rcenvironment.core.gui.workflow.EndpointContentProvider;
import de.rcenvironment.core.gui.workflow.view.properties.InputModel;
import java.util.Deque;

public final class InputEditingHelper {
    private InputEditingHelper() {
    }

    public static String getLatestInputValue(WorkflowExecutionInformation workflowInformation, EndpointContentProvider.Endpoint endpoint) {
        return InputEditingHelper.getLatestInputValueFromEndpoint(workflowInformation.getExecutionIdentifier(), InputEditingHelper.getComponentIdentifier(workflowInformation, endpoint), endpoint);
    }

    private static String getComponentIdentifier(WorkflowExecutionInformation workflowInformation, EndpointContentProvider.Endpoint endpoint) {
        WorkflowNode workflowNode = endpoint.getWorkflowNode();
        return workflowInformation.getComponentExecutionInformation(workflowNode.getIdentifierAsObject()).getExecutionIdentifier();
    }

    public static String getLatestInputValueFromEndpoint(String workflowId, String componentId, EndpointContentProvider.Endpoint endpoint) {
        Deque<EndpointDatum> inputs = InputModel.getInstance().getInputs(workflowId, componentId, endpoint.getName());
        EndpointDatum input = null;
        if (!inputs.isEmpty()) {
            input = InputModel.getInstance().getInputs(workflowId, componentId, endpoint.getName()).getLast();
        }
        return InputEditingHelper.getValueFromInput(input);
    }

    private static String getValueFromInput(EndpointDatum input) {
        String inputValue;
        if (input != null && input.getValue() != null) {
            TypedDatum rawInputValue = input.getValue();
            switch (input.getValue().getDataType()) {
                case FileReference: {
                    inputValue = ((FileReferenceTD)rawInputValue).getFileName();
                    break;
                }
                case DirectoryReference: {
                    inputValue = ((DirectoryReferenceTD)rawInputValue).getDirectoryName();
                    break;
                }
                case Boolean: 
                case Integer: 
                case Float: {
                    inputValue = rawInputValue.toString();
                    break;
                }
                case ShortText: {
                    inputValue = ((ShortTextTD)rawInputValue).toLengthLimitedString(50);
                    break;
                }
                case Vector: {
                    inputValue = ((VectorTD)rawInputValue).toLengthLimitedString(50);
                    break;
                }
                case Matrix: {
                    inputValue = ((MatrixTD)rawInputValue).toLengthLimitedString(50);
                    break;
                }
                case SmallTable: {
                    inputValue = ((SmallTableTD)rawInputValue).toLengthLimitedString(50);
                    break;
                }
                default: {
                    inputValue = input.getValue().toString();
                    break;
                }
            }
        } else {
            inputValue = "-";
        }
        return inputValue;
    }
}

