/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.verify;

import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.component.execution.api.ComponentExecutionInformation;
import de.rcenvironment.core.component.execution.api.ComponentExecutionService;
import de.rcenvironment.core.component.execution.api.ExecutionControllerException;
import de.rcenvironment.core.gui.workflow.verify.ComponentResultVerificationInfoWizardPage;
import de.rcenvironment.core.gui.workflow.verify.ComponentResultVerificationTokenWizardPage;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ComponentResultVerificationWizard
extends Wizard {
    private ComponentResultVerificationInfoWizardPage decisionPage;
    private ComponentExecutionService componentExecutionService;

    public ComponentResultVerificationWizard() {
        ServiceRegistryAccess registryAccess = ServiceRegistry.createAccessFor((Object)((Object)this));
        this.componentExecutionService = (ComponentExecutionService)registryAccess.getService(ComponentExecutionService.class);
        this.setWindowTitle("Tool Result Verification");
    }

    public void addPages() {
        this.addPage((IWizardPage)new ComponentResultVerificationTokenWizardPage());
        this.decisionPage = new ComponentResultVerificationInfoWizardPage();
        this.addPage((IWizardPage)this.decisionPage);
    }

    public boolean performCancel() {
        this.decisionPage.setVerificationToken(null);
        return super.performCancel();
    }

    public boolean performFinish() {
        final String verificationToken = this.decisionPage.getVerificationToken();
        final ComponentExecutionInformation compExeInfo = this.decisionPage.getComponentExecutionInformation();
        final boolean verificationResult = this.decisionPage.getVerificationResult();
        Job job = new Job("Send verification results for tool run"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    boolean successfullyApplied = ComponentResultVerificationWizard.this.componentExecutionService.verifyResults(compExeInfo.getExecutionIdentifier(), (ResolvableNodeId)compExeInfo.getNodeId(), verificationToken, verificationResult);
                    if (!successfullyApplied) {
                        ComponentResultVerificationWizard.this.openErrorDialog(compExeInfo);
                    }
                }
                catch (ExecutionControllerException | RemoteOperationException e) {
                    LogFactory.getLog(ComponentResultVerificationWizard.class).error((Object)StringUtils.format((String)"Error when sending verification results for component '%s' (%s) of workflow '%s' (%s)", (Object[])new Object[]{compExeInfo.getInstanceName(), compExeInfo.getExecutionIdentifier(), compExeInfo.getWorkflowInstanceName(), compExeInfo.getWorkflowExecutionIdentifier()}), e);
                    if (e instanceof RemoteOperationException) {
                        ComponentResultVerificationWizard.this.openErrorDialog((RemoteOperationException)e, compExeInfo);
                    }
                    ComponentResultVerificationWizard.this.openErrorDialog(compExeInfo);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return true;
    }

    private void openErrorDialog(ComponentExecutionInformation compExeInfo) {
        this.openErrorDialog(null, compExeInfo);
    }

    private void openErrorDialog(final RemoteOperationException e, final ComponentExecutionInformation compExeInfo) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                String errorMessage = e != null ? StringUtils.format((String)"Failed to send verification results for tool '%s' to '%s'.\n\nReason: %s", (Object[])new Object[]{compExeInfo.getInstanceName(), compExeInfo.getNodeId().getAssociatedDisplayName(), e.getMessage()}) : StringUtils.format((String)"Failed to send verification results for tool '%s' to '%s'. Most likely reason: In the meantime, verification results are already sent by someone else.", (Object[])new Object[]{compExeInfo.getInstanceName(), compExeInfo.getNodeId().getAssociatedDisplayName()});
                MessageDialog.openError((Shell)ComponentResultVerificationWizard.this.getShell(), (String)"Error Sending Verification Results", (String)errorMessage);
            }
        });
    }
}

