/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.execute;

import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.gui.workflow.execute.TreeNode;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class TreeContentProvider
implements ITreeContentProvider {
    private static final String VERSION = " (Version: ";
    private List<String> componentsWithOneVersion;
    private List<String> componentsWithMoreVersions;

    public Object[] getElements(Object element) {
        List<TreeNode> nodes = this.prepareTreeNodes((WorkflowDescription)element);
        return nodes.toArray();
    }

    private List<TreeNode> prepareTreeNodes(WorkflowDescription description) {
        TreeNode treeNodeFather;
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>();
        List nodes = description.getWorkflowNodes();
        this.componentsWithOneVersion = new ArrayList<String>();
        this.componentsWithMoreVersions = new ArrayList<String>();
        for (WorkflowNode node : nodes) {
            String componentName = node.getComponentDescription().getName();
            VersionHelper versions = this.checkIfSameComponentHasDifferentVersion(nodes, componentName);
            if (versions.getVersionList().size() == 1) {
                if (this.componentsWithOneVersion.contains(componentName)) continue;
                this.componentsWithOneVersion.add(componentName);
                continue;
            }
            for (String version : versions.getVersionList()) {
                String finalCompName = String.valueOf(node.getComponentDescription().getName()) + VERSION + version + ")";
                if (this.componentsWithMoreVersions.contains(finalCompName)) continue;
                this.componentsWithMoreVersions.add(finalCompName);
            }
        }
        for (String type : this.componentsWithOneVersion) {
            treeNodeFather = new TreeNode(type, false);
            for (WorkflowNode node : nodes) {
                if (!node.getComponentDescription().getName().equals(type)) continue;
                TreeNode treeNodeChild = new TreeNode(node.getName(), true, node, treeNodeFather);
                treeNodeFather.addChildNode(treeNodeChild);
            }
            treeNodes.add(treeNodeFather);
        }
        for (String type : this.componentsWithMoreVersions) {
            treeNodeFather = new TreeNode(type, false);
            for (WorkflowNode node : nodes) {
                String temp = String.valueOf(node.getComponentDescription().getName()) + VERSION + node.getComponentDescription().getVersion() + ")";
                if (!temp.equals(type)) continue;
                TreeNode treeNodeChild = new TreeNode(node.getName(), true, node, treeNodeFather);
                treeNodeFather.addChildNode(treeNodeChild);
            }
            treeNodes.add(treeNodeFather);
        }
        return treeNodes;
    }

    private VersionHelper checkIfSameComponentHasDifferentVersion(List<WorkflowNode> nodes, String componentString) {
        VersionHelper versionHelper = new VersionHelper();
        for (WorkflowNode node : nodes) {
            if (!node.getComponentDescription().getName().equals(componentString)) continue;
            versionHelper.addVersion(node.getComponentDescription().getVersion());
        }
        return versionHelper;
    }

    public Object getParent(Object element) {
        TreeNode node = (TreeNode)element;
        if (node.isChildElement()) {
            return node.getFatherNode();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        TreeNode node = (TreeNode)element;
        return !node.isChildElement();
    }

    public Object[] getChildren(Object element) {
        TreeNode node = (TreeNode)element;
        if (!node.isChildElement()) {
            return node.getChildrenNodes().toArray();
        }
        return null;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer tree, Object oldInput, Object newInput) {
    }

    public int getNodeTypeCount() {
        if (this.componentsWithMoreVersions != null) {
            return this.componentsWithMoreVersions.size() + this.componentsWithOneVersion.size();
        }
        return 0;
    }

    public class VersionHelper {
        private List<String> versionList = new ArrayList<String>();

        public void addVersion(String version) {
            if (!this.versionList.contains(version)) {
                this.versionList.add(version);
            }
        }

        public List<String> getVersionList() {
            return this.versionList;
        }
    }
}

