/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.execute;

import de.rcenvironment.core.gui.workflow.execute.TableBehaviour;
import de.rcenvironment.core.gui.workflow.execute.WorkflowDescriptionContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.TableColumn;

public class TableSortSelectionListener
implements SelectionListener {
    public static final String COLUMN_NAME = "COLUMN_NAME";
    public static final String COLUMN_INSTANCE = "COLUMN_INSTANCE";
    private TableViewer viewer;
    private TableColumn column;
    private int currentDirection;
    private TableBehaviour updaterTable;

    public TableSortSelectionListener(TableViewer viewer, TableColumn column, int startDirection) {
        this.currentDirection = startDirection;
        this.viewer = viewer;
        this.column = column;
        this.column.addSelectionListener((SelectionListener)this);
    }

    private void setSortDirection() {
        this.currentDirection = this.viewer.getTable().getSortDirection();
        if (this.currentDirection == 128) {
            this.viewer.getTable().setSortDirection(1024);
        } else {
            this.viewer.getTable().setSortDirection(128);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        this.updaterTable.saveIndexOfComboBeforeRefresh();
        this.viewer.getTable().setSortColumn(this.column);
        this.updaterTable.disposeWidgets();
        if (this.column.getData().equals(COLUMN_INSTANCE)) {
            this.viewer.setContentProvider((IContentProvider)new WorkflowDescriptionContentProvider(this.currentDirection, COLUMN_INSTANCE));
            this.updaterTable.setCurrentlyUsedSortingColumn(2);
        } else {
            this.viewer.setContentProvider((IContentProvider)new WorkflowDescriptionContentProvider(this.currentDirection, COLUMN_NAME));
            this.updaterTable.setCurrentlyUsedSortingColumn(1);
        }
        this.updaterTable.disposeWidgets();
        this.viewer.refresh();
        this.updaterTable.checkifAllClicked();
        this.updaterTable.checkIfDisableMasterBtn();
        this.updaterTable.setSavedComboIndex();
        this.setSortDirection();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void setUpdaterTable(TableBehaviour updaterTable) {
        this.updaterTable = updaterTable;
    }
}

