/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.execute;

import de.rcenvironment.core.component.api.ComponentUtils;
import de.rcenvironment.core.component.model.configuration.api.ConfigurationDescription;
import de.rcenvironment.core.component.model.configuration.api.PlaceholdersMetaDataDefinition;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowPlaceholderHandler;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNodeIdentifier;
import de.rcenvironment.core.gui.utils.incubator.NumericalTextConstraintListener;
import de.rcenvironment.core.gui.workflow.execute.PlaceholderPage;
import de.rcenvironment.core.gui.workflow.execute.PlaceholderSortUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class PlaceholderPageTreeFactory {
    private static final String PLACEHOLDER_FORMAT = "%s.%s";
    private static final int DEFAULT_COLUMN_WIDTH = 100;
    private static final Log LOGGER = LogFactory.getLog(PlaceholderPageTreeFactory.class);
    private final PlaceholderPage placeholderPage;
    private final WorkflowPlaceholderHandler placeholderHelper;
    private final Tree componentPlaceholderTree;
    private boolean restoredPasswords = false;
    private TreeColumn displayNameColumn;
    private final Collection<PlaceholderHistoryContentProposalProvider> contentProposalProviders = new HashSet<PlaceholderHistoryContentProposalProvider>();

    public PlaceholderPageTreeFactory(PlaceholderPage placeholderPage, WorkflowPlaceholderHandler placeholderHandler, Group parentGroup) {
        this.placeholderPage = placeholderPage;
        this.placeholderHelper = placeholderHandler;
        this.componentPlaceholderTree = new Tree((Composite)parentGroup, 2);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.componentPlaceholderTree.setLayoutData((Object)gridData);
        this.componentPlaceholderTree.setHeaderVisible(true);
        this.componentPlaceholderTree.setLinesVisible(true);
        this.componentPlaceholderTree.addListener(41, event -> {
            int n = event.height = 22;
        });
        this.displayNameColumn = this.appendLeftAlignedColumnToTree();
        this.appendValueColumnToTree();
        this.appendBrowseColumnToTree();
        this.appendApplyToAllColumnToTree();
    }

    public Tree getTree() {
        return this.componentPlaceholderTree;
    }

    public void reloadContentProposals() {
        for (PlaceholderHistoryContentProposalProvider contentProposalProvider : this.contentProposalProviders) {
            contentProposalProvider.reloadProposals();
        }
    }

    void fillTree() {
        String[] componentTypesWithPlaceholderArray;
        String[] stringArray = componentTypesWithPlaceholderArray = this.getComponentTypesWithPlaceholders(this.placeholderHelper.getIdentifiersOfPlaceholderContainingComponents());
        int n = componentTypesWithPlaceholderArray.length;
        int n2 = 0;
        while (n2 < n) {
            String componentID = stringArray[n2];
            this.appendSingleComponentTypeToTree(componentID);
            ++n2;
        }
        this.placeholderPage.placeApplyToAllButtonsWhereNecessary(this.componentPlaceholderTree);
        this.displayNameColumn.pack();
        this.componentPlaceholderTree.getColumn(0).setWidth(this.componentPlaceholderTree.getColumn(0).getWidth() + 10);
        this.componentPlaceholderTree.redraw();
    }

    protected void appendSingleComponentTypeToTree(String componentID) {
        WorkflowNode workflowNode = this.getArbitraryWorkflowNodeForComponent(componentID);
        String componentName = workflowNode.getName();
        TreeItem componentTypeTreeItem = this.createTreeItemForComponentType(workflowNode);
        this.appendGlobalPlaceholdersToTree(componentTypeTreeItem, componentID, componentName);
        List<WorkflowNodeIdentifier> instancesWithPlaceholder = this.getComponentInstancesWithPlaceholders(componentID);
        for (WorkflowNodeIdentifier componentInstanceID : instancesWithPlaceholder) {
            ConfigurationDescription configDesc;
            boolean hasPlaceholderWithGUIName = this.determineWhetherInstanceHasPlaceholdersWithDisplayName(componentInstanceID, componentName, configDesc = this.placeholderPage.getWorkflowNode(componentInstanceID).getComponentDescription().getConfigurationDescription());
            if (!hasPlaceholderWithGUIName) continue;
            String instanceName = this.placeholderPage.getWorkflowNode(componentInstanceID).getName();
            TreeItem instanceTreeItem = this.createTreeItemForComponentInstance(componentTypeTreeItem, instanceName, this.getImage(workflowNode));
            Optional<PlaceholdersMetaDataDefinition> placeholderMetaData = this.getPlaceholderMetaData(componentName);
            List<String> orderedInstancePlaceholders = PlaceholderSortUtils.sortGlobalPlaceholders(this.placeholderHelper.getPlaceholderNameSetOfComponentInstance(componentInstanceID.toString()), placeholderMetaData.orElse(null));
            for (String instancePlaceholder : orderedInstancePlaceholders) {
                boolean isActivePlaceholder = WorkflowPlaceholderHandler.isActivePlaceholder((String)instancePlaceholder, (ConfigurationDescription)configDesc);
                if (!isActivePlaceholder) continue;
                TreeItem instancePHTreeItem = new TreeItem(instanceTreeItem, 0);
                this.placeholderPage.setWorkflowNodeIDForTreeItem(instancePHTreeItem, componentInstanceID);
                String guiName = placeholderMetaData.map(metaData -> metaData.getGuiName(instancePlaceholder)).orElse(instancePlaceholder);
                this.placeholderPage.setPlaceholderForTreeItem(instancePHTreeItem, instancePlaceholder);
                instancePHTreeItem.setText(0, guiName);
                String currentPlaceholder = StringUtils.format((String)PLACEHOLDER_FORMAT, (Object[])new Object[]{componentID, instancePlaceholder});
                this.placeholderPage.putIntoControlMap(instancePHTreeItem, this.buildPlaceholderText(instancePHTreeItem, StringUtils.format((String)PLACEHOLDER_FORMAT, (Object[])new Object[]{instanceName, instancePlaceholder}), guiName, ComponentUtils.isEncryptedPlaceholder((String)currentPlaceholder, (List)WorkflowPlaceholderHandler.getEncryptedPlaceholder()), false));
            }
        }
    }

    protected TreeItem createTreeItemForComponentInstance(TreeItem componentTypeTreeItem, String instanceName, Image image) {
        TreeItem instanceTreeItem = new TreeItem(componentTypeTreeItem, 0);
        instanceTreeItem.setText(0, instanceName);
        instanceTreeItem.setImage(image);
        return instanceTreeItem;
    }

    protected boolean determineWhetherInstanceHasPlaceholdersWithDisplayName(WorkflowNodeIdentifier workflowNodeInstance, String componentName, ConfigurationDescription configDesc) {
        boolean hasPlaceholderWithGUIName = false;
        Optional<PlaceholdersMetaDataDefinition> placeholderMetaData = this.getPlaceholderMetaData(componentName);
        Iterator iterator = this.placeholderHelper.getPlaceholderNameSetOfComponentInstance(workflowNodeInstance.toString()).iterator();
        if (iterator.hasNext()) {
            String instancePlaceholder = (String)iterator.next();
            boolean isActivePlaceholder = WorkflowPlaceholderHandler.isActivePlaceholder((String)instancePlaceholder, (ConfigurationDescription)configDesc);
            if (isActivePlaceholder) {
                Optional<String> guiName = placeholderMetaData.map(metaData -> metaData.getGuiName(instancePlaceholder));
                Optional<String> defaultGuiName = placeholderMetaData.map(metaData -> metaData.getGuiName("*"));
                if (guiName.isPresent() && !guiName.get().isEmpty() || defaultGuiName.isPresent()) {
                    return true;
                }
                for (String configurationValues : configDesc.getConfiguration().values()) {
                    if (!ConfigurationDescription.isPlaceholder((String)configurationValues) || !WorkflowPlaceholderHandler.getNameOfPlaceholder((String)configurationValues).equals(instancePlaceholder)) continue;
                    hasPlaceholderWithGUIName = true;
                }
                if (!hasPlaceholderWithGUIName) {
                    LOGGER.warn((Object)StringUtils.format((String)"Placeholder %s of component %s has no GUI name defined and will be ignored.", (Object[])new Object[]{instancePlaceholder, this.placeholderPage.getWorkflowNode(workflowNodeInstance).getComponentDescription().getName()}));
                }
                return hasPlaceholderWithGUIName;
            }
            return false;
        }
        return false;
    }

    protected List<WorkflowNodeIdentifier> getComponentInstancesWithPlaceholders(String componentID) {
        List<String> instancesWithPlaceholder = this.placeholderHelper.getComponentInstances(componentID);
        instancesWithPlaceholder = PlaceholderSortUtils.sortInstancesWithPlaceholderByName(instancesWithPlaceholder, this.placeholderPage.getWorkflowDescription());
        return instancesWithPlaceholder.stream().map(WorkflowNodeIdentifier::new).collect(Collectors.toList());
    }

    protected void appendGlobalPlaceholdersToTree(TreeItem parent, String componentID, String componentName) {
        Optional<PlaceholdersMetaDataDefinition> placeholderMetaData = this.getPlaceholderMetaData(componentName);
        List<String> globalPlaceholders = PlaceholderSortUtils.sortGlobalPlaceholders(this.placeholderHelper.getGlobalPlaceholdersForComponentID(componentID), placeholderMetaData.orElse(null));
        for (String componentPlaceholder : globalPlaceholders) {
            TreeItem compPHTreeItem = new TreeItem(parent, 0);
            Optional<String> guiName = placeholderMetaData.map(metaData -> metaData.getGuiName(componentPlaceholder));
            this.placeholderPage.setPlaceholderForTreeItem(compPHTreeItem, componentPlaceholder);
            compPHTreeItem.setText(0, guiName.orElse(""));
            String currentPlaceholder = StringUtils.format((String)PLACEHOLDER_FORMAT, (Object[])new Object[]{componentID, componentPlaceholder});
            this.placeholderPage.putIntoControlMap(compPHTreeItem, this.buildPlaceholderText(compPHTreeItem, StringUtils.format((String)PLACEHOLDER_FORMAT, (Object[])new Object[]{componentName, componentPlaceholder}), guiName.orElse(""), ComponentUtils.isEncryptedPlaceholder((String)currentPlaceholder, (List)WorkflowPlaceholderHandler.getEncryptedPlaceholder()), true));
        }
    }

    private Optional<PlaceholdersMetaDataDefinition> getPlaceholderMetaData(String name) {
        return this.placeholderPage.getWorkflowDescription().getWorkflowNodes().stream().filter(workflowNode -> workflowNode.getName().equals(name)).map(workflowNode -> workflowNode.getComponentDescription().getConfigurationDescription().getComponentConfigurationDefinition().getPlaceholderMetaDataDefinition()).findAny();
    }

    protected WorkflowNode getArbitraryWorkflowNodeForComponent(String componentID) {
        String workflowNodeID = (String)this.placeholderHelper.getComponentInstances(componentID).get(0);
        return this.placeholderPage.getWorkflowNode(new WorkflowNodeIdentifier(workflowNodeID));
    }

    protected TreeItem createTreeItemForComponentType(WorkflowNode workflowNode) {
        TreeItem componentIDTreeItem = new TreeItem(this.componentPlaceholderTree, 0);
        componentIDTreeItem.setText(0, workflowNode.getComponentDescription().getName());
        componentIDTreeItem.setImage(this.getImage(workflowNode));
        return componentIDTreeItem;
    }

    protected void appendApplyToAllColumnToTree() {
        this.appendCenterAlignedColumnToTree(100);
    }

    protected void appendBrowseColumnToTree() {
        this.appendCenterAlignedColumnToTree(50);
    }

    protected void appendValueColumnToTree() {
        this.appendCenterAlignedColumnToTree(105);
    }

    protected String[] getComponentTypesWithPlaceholders(Set<String> componentTypesWithPlaceholders) {
        Set<String> componentTypesWithPlaceholder = componentTypesWithPlaceholders;
        Object[] componentTypesWithPlaceholderArray = componentTypesWithPlaceholder.toArray(new String[componentTypesWithPlaceholder.size()]);
        Arrays.sort(componentTypesWithPlaceholderArray);
        return componentTypesWithPlaceholderArray;
    }

    Control buildPlaceholderText(TreeItem item, String placeholderName, String guiName, boolean isEncrypted, boolean isGlobal) {
        boolean isShorttext;
        boolean isBoolean;
        Combo booleanCombo;
        TreeEditor textEditor = new TreeEditor(item.getParent());
        textEditor.horizontalAlignment = 16384;
        textEditor.grabHorizontal = true;
        int style = 2052;
        boolean isPathField = false;
        boolean isInteger = false;
        boolean isFloat = false;
        String dataType = (String)this.placeholderHelper.getPlaceholdersDataType().get(placeholderName);
        String componentName = placeholderName.split("\\.")[0];
        if (dataType != null) {
            if (dataType.equals("file") || dataType.equals("dir")) {
                booleanCombo = null;
                isPathField = true;
                isBoolean = false;
            } else if (dataType.equals("bool")) {
                booleanCombo = PlaceholderPageTreeFactory.createBooleanCombo(item);
                isBoolean = true;
            } else if (dataType.equals("int")) {
                booleanCombo = null;
                isInteger = true;
                isBoolean = false;
            } else if (dataType.equals("float")) {
                booleanCombo = null;
                isFloat = true;
                isBoolean = false;
            } else {
                booleanCombo = null;
                isBoolean = false;
            }
        } else {
            booleanCombo = null;
            isBoolean = false;
        }
        if (isEncrypted) {
            style |= 0x400000;
        }
        Text placeholderText = new Text((Composite)item.getParent(), style);
        boolean bl = isShorttext = !isFloat && !isInteger && !isBoolean && !isPathField;
        if (!isShorttext) {
            placeholderText.setMessage("No value entered.");
        }
        ModifyListener modifyListener = event -> this.placeholderPage.validateInput((Text)event.getSource(), componentName, guiName, isShorttext);
        placeholderText.addModifyListener(modifyListener);
        if (!this.restoredPasswords && isEncrypted) {
            WorkflowPlaceholderHandler.restorePasswords((Map)this.placeholderHelper.getComponentInstanceHistory());
            WorkflowPlaceholderHandler.restorePasswords((Map)this.placeholderHelper.getComponentTypeHistory());
            this.restoredPasswords = true;
        }
        Supplier<String[]> getProposals = () -> {
            if (isEncrypted) {
                return this.getAllProposalsForEncryptedPlaceholder(item, isGlobal, booleanCombo, isBoolean, placeholderText);
            }
            return this.getAllProposalsForUnencryptedPlaceholder(item, isGlobal, booleanCombo, isBoolean, placeholderText);
        };
        this.buildAndSetContentProposalAdapter(placeholderText, getProposals);
        if (isPathField) {
            this.placeholderPage.addFileChooser(item, dataType, placeholderText);
        }
        if (isBoolean) {
            textEditor.setEditor((Control)booleanCombo, item, 1);
            return booleanCombo;
        }
        if (PlaceholderPage.isTextEmpty(placeholderText) && !isShorttext) {
            this.placeholderPage.addPlaceholderValidator(componentName, guiName);
            placeholderText.setBackground(PlaceholderPage.COLOR_RED);
        }
        textEditor.setEditor((Control)placeholderText, item, 1);
        if (isEncrypted) {
            this.placeholderPage.addSaveButton(item, placeholderText);
        }
        if (isFloat) {
            NumericalTextConstraintListener floatListener = new NumericalTextConstraintListener(1);
            placeholderText.addVerifyListener((VerifyListener)floatListener);
        }
        if (isInteger) {
            NumericalTextConstraintListener integerListener = new NumericalTextConstraintListener(2);
            placeholderText.addVerifyListener((VerifyListener)integerListener);
        }
        return placeholderText;
    }

    private static Combo createBooleanCombo(TreeItem item) {
        Combo combo = new Combo((Composite)item.getParent(), 8);
        combo.add(Boolean.TRUE.toString().toLowerCase());
        combo.add(Boolean.FALSE.toString().toLowerCase());
        combo.setText(Boolean.TRUE.toString().toLowerCase());
        return combo;
    }

    protected void buildAndSetContentProposalAdapter(Text placeholderText, Supplier<String[]> getProposals) {
        PlaceholderHistoryContentProposalProvider scp = new PlaceholderHistoryContentProposalProvider(getProposals);
        scp.setFiltering(true);
        this.contentProposalProviders.add(scp);
        ContentProposalAdapter adapter = null;
        adapter = new ContentProposalAdapter((Control)placeholderText, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)scp, KeyStroke.getInstance((int)0x1000002), null);
        adapter.setProposalAcceptanceStyle(2);
        adapter.setAutoActivationDelay(1);
        adapter.setPropagateKeys(true);
    }

    private String[] getAllProposalsForEncryptedPlaceholder(TreeItem item, boolean isGlobal, Combo booleanCombo, boolean isBoolean, Text placeholderText) {
        String[] allProposals = !isGlobal ? this.placeholderHelper.getInstancePlaceholderHistory(this.placeholderPage.getPlaceholderForTreeItem(item), this.placeholderPage.getWorkflowNodeIDForTreeItem(item).toString()) : this.placeholderHelper.getComponentPlaceholderHistory(this.placeholderPage.getPlaceholderForTreeItem(item), this.placeholderPage.getComponentIDByName(item.getParentItem().getText()), this.placeholderPage.getWorkflowIdentifier());
        String finalProposal = null;
        if (allProposals.length > 0) {
            byte[] decoded = new Base64().decode(allProposals[allProposals.length - 1]);
            allProposals[allProposals.length - 1] = new String(decoded, StandardCharsets.UTF_8);
            finalProposal = allProposals[allProposals.length - 1];
        }
        if (finalProposal != null && !finalProposal.equals("")) {
            if (!isBoolean) {
                placeholderText.setText(finalProposal);
            } else if (booleanCombo != null) {
                booleanCombo.setText(finalProposal);
            }
        }
        return new String[0];
    }

    private String[] getAllProposalsForUnencryptedPlaceholder(TreeItem item, boolean isGlobal, Combo booleanCombo, boolean isBoolean, Text placeholderText) {
        String[] allProposals = !isGlobal ? this.placeholderHelper.getInstancePlaceholderHistory(this.placeholderPage.getPlaceholderForTreeItem(item), this.placeholderPage.getWorkflowNodeIDForTreeItem(item).toString()) : this.placeholderHelper.getComponentPlaceholderHistory(this.placeholderPage.getPlaceholderForTreeItem(item), this.placeholderPage.getComponentIDByName(item.getParentItem().getText()), this.placeholderPage.getWorkflowIdentifier());
        String finalProposal = null;
        if (allProposals.length > 0) {
            finalProposal = allProposals[allProposals.length - 1];
        }
        String[] additionalProposals = this.placeholderHelper.getOtherPlaceholderHistoryValues(this.placeholderPage.getPlaceholderForTreeItem(item));
        if (allProposals.length == 0) {
            allProposals = additionalProposals;
            if (allProposals.length > 0) {
                String valueFromOtherComponentInWorkflow = this.placeholderHelper.getValueFromOtherComponentInWorkflow(this.placeholderPage.getPlaceholderForTreeItem(item), this.placeholderPage.getWorkflowIdentifier());
                finalProposal = valueFromOtherComponentInWorkflow != null ? valueFromOtherComponentInWorkflow : allProposals[allProposals.length - 1];
            }
        } else {
            allProposals = additionalProposals;
        }
        if (finalProposal != null && !finalProposal.equals("")) {
            if (!isBoolean) {
                placeholderText.setText(finalProposal);
            } else if (booleanCombo != null) {
                booleanCombo.setText(finalProposal);
            }
        }
        return allProposals;
    }

    private TreeColumn appendLeftAlignedColumnToTree() {
        TreeColumn returnValue = new TreeColumn(this.componentPlaceholderTree, 16384);
        returnValue.setText("");
        return returnValue;
    }

    private TreeColumn createCenterAlignedTreeColumn() {
        TreeColumn returnValue = new TreeColumn(this.componentPlaceholderTree, 0x1000000);
        returnValue.setText("");
        return returnValue;
    }

    private TreeColumn appendCenterAlignedColumnToTree(int width) {
        TreeColumn returnValue = this.createCenterAlignedTreeColumn();
        returnValue.setWidth(width);
        return returnValue;
    }

    private Image getImage(WorkflowNode element) {
        return element.getComponentDescription().getIcon16();
    }

    private class PlaceholderHistoryContentProposalProvider
    extends SimpleContentProposalProvider {
        private final Supplier<String[]> placeholderHistoryProvider;

        PlaceholderHistoryContentProposalProvider(Supplier<String[]> contentProposalProvider) {
            super(contentProposalProvider.get());
            this.placeholderHistoryProvider = contentProposalProvider;
        }

        public void reloadProposals() {
            this.setProposals(this.placeholderHistoryProvider.get());
        }
    }
}

