/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor.commands;

import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.gui.workflow.editor.handlers.AbstractWorkflowPartSendHandler;
import de.rcenvironment.core.gui.workflow.parts.WorkflowNodePart;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.gef.commands.Command;

public class WorkflowNodeSendLayerwiseCommand
extends Command {
    public static final int SEND_BACK = 0;
    public static final int SEND_FORWARD = 1;
    public static final int SEND_TO_BACKGROUND = 2;
    public static final int SEND_TO_FOREGROUND = 4;
    private static final int MINUS_ONE = -1;
    private final WorkflowDescription workflowDescription;
    private final List<WorkflowNode> selectedNodes;
    private final AbstractWorkflowPartSendHandler.SendType sendType;
    private Map<WorkflowNode, Integer> previousState = new HashMap<WorkflowNode, Integer>();

    public WorkflowNodeSendLayerwiseCommand(WorkflowDescription workflowDescription, List<WorkflowNodePart> cleanSelectedNodeParts, AbstractWorkflowPartSendHandler.SendType sendType) {
        this.workflowDescription = workflowDescription;
        this.selectedNodes = new ArrayList<WorkflowNode>();
        for (WorkflowNodePart part : cleanSelectedNodeParts) {
            this.selectedNodes.add((WorkflowNode)part.getModel());
        }
        this.sendType = sendType;
    }

    public void execute() {
        this.savePreviousState();
        this.redo();
    }

    public void redo() {
        this.orderSelectedLabels();
        int[] zIndexList = this.getzIndexList(this.workflowDescription.getWorkflowNodes().size());
        switch (this.sendType) {
            case SEND_BACK: {
                this.sendSelectedArrayIndicesOneLayerBack(zIndexList);
                break;
            }
            case SEND_FORWARD: {
                this.sendSelectedArrayIndicesOneLayerForward(zIndexList);
                break;
            }
            case SEND_TO_BACKGROUND: {
                this.sendSelectedArrayIndicesToBackground(zIndexList);
                break;
            }
            case SEND_TO_FOREGROUND: {
                this.sendSelectedArrayIndicesToForeground(zIndexList);
            }
        }
        this.setNewzIndicesFromIndexList(zIndexList);
        this.workflowDescription.firePropertyChange("e.rcenvironment.wf.n");
    }

    public void undo() {
        for (WorkflowNode node : this.workflowDescription.getWorkflowNodes()) {
            node.setZIndex(this.previousState.get(node).intValue());
        }
        this.workflowDescription.firePropertyChange("e.rcenvironment.wf.n");
    }

    private void savePreviousState() {
        for (WorkflowNode node : this.workflowDescription.getWorkflowNodes()) {
            this.previousState.put(node, node.getZIndex());
        }
    }

    private void orderSelectedLabels() {
        Collections.sort(this.selectedNodes, new Comparator<WorkflowNode>(){

            @Override
            public int compare(WorkflowNode arg0, WorkflowNode arg1) {
                if (arg0.getZIndex() < arg1.getZIndex()) {
                    return -1;
                }
                if (arg0.getZIndex() > arg1.getZIndex()) {
                    return 1;
                }
                return 0;
            }
        });
    }

    private int[] getzIndexList(int size) {
        int[] returnList = new int[size];
        int i = 0;
        while (i < size) {
            returnList[i] = i;
            ++i;
        }
        return returnList;
    }

    private void sendSelectedArrayIndicesOneLayerBack(int[] indexList) {
        int i = 0;
        while (i < this.selectedNodes.size()) {
            if (this.selectedNodes.get(i).getZIndex() != i) {
                int z = this.selectedNodes.get(i).getZIndex();
                int tempZ = indexList[z];
                indexList[z] = indexList[z - 1];
                indexList[z - 1] = tempZ;
            }
            ++i;
        }
    }

    private void sendSelectedArrayIndicesOneLayerForward(int[] indexList) {
        int i = this.selectedNodes.size() - 1;
        while (i >= 0) {
            WorkflowNode selectedNode = this.selectedNodes.get(i);
            int z = selectedNode.getZIndex();
            if (z < this.workflowDescription.getWorkflowNodes().size() - 1) {
                int tempZ = indexList[z];
                indexList[z] = indexList[z + 1];
                indexList[z + 1] = tempZ;
            }
            --i;
        }
    }

    private void sendSelectedArrayIndicesToBackground(int[] indexList) {
        int i = 0;
        while (i < this.selectedNodes.size()) {
            int j = this.selectedNodes.get(i).getZIndex();
            while (j > i) {
                int tempZ = indexList[j];
                indexList[j] = indexList[j - 1];
                indexList[j - 1] = tempZ;
                --j;
            }
            ++i;
        }
    }

    private void sendSelectedArrayIndicesToForeground(int[] indexList) {
        int i = this.selectedNodes.size() - 1;
        while (i >= 0) {
            int j = this.selectedNodes.get(i).getZIndex();
            while (j < indexList.length - this.selectedNodes.size() + i) {
                int tempZ = indexList[j];
                indexList[j] = indexList[j + 1];
                indexList[j + 1] = tempZ;
                ++j;
            }
            --i;
        }
    }

    private void setNewzIndicesFromIndexList(int[] indexList) {
        HashMap<WorkflowNode, Integer> assignMap = new HashMap<WorkflowNode, Integer>();
        int i = 0;
        while (i < indexList.length) {
            for (WorkflowNode node : this.workflowDescription.getWorkflowNodes()) {
                if (node.getZIndex() != indexList[i]) continue;
                assignMap.put(node, i);
                break;
            }
            ++i;
        }
        for (WorkflowNode node : assignMap.keySet()) {
            node.setZIndex(((Integer)assignMap.get(node)).intValue());
        }
    }
}

