/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor.commands;

import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.gui.workflow.editor.connections.ConnectionDialogController;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.gef.commands.Command;

public class ConnectionDrawCommand
extends Command {
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private WorkflowNode sourceNode;
    private WorkflowNode targetNode;
    private WorkflowDescription memorizedModel;
    private WorkflowDescription currentModel;
    private WorkflowDescription modifiedModel;

    public ConnectionDrawCommand(WorkflowDescription model, WorkflowNode sourceNode) {
        this.memorizedModel = model.clone();
        this.currentModel = model;
        this.sourceNode = sourceNode;
    }

    public void execute() {
        WorkflowDescription modelClone = this.currentModel.clone();
        ConnectionDialogController dialogControler = new ConnectionDialogController(modelClone, this.sourceNode, this.targetNode, false);
        if (this.sourceNode != null && this.targetNode != null && dialogControler.open() == 0) {
            List modifiedConnections;
            this.modifiedModel = dialogControler.getWorkflowDescription();
            List originalConnections = this.currentModel.getConnections();
            if (!CollectionUtils.isEqualCollection((Collection)originalConnections, (Collection)(modifiedConnections = this.modifiedModel.getConnections()))) {
                this.currentModel.replaceConnections(modifiedConnections);
            }
        }
    }

    public void undo() {
        this.currentModel.replaceConnections(this.memorizedModel.getConnections());
    }

    public void redo() {
        if (this.currentModel != null && this.modifiedModel != null) {
            this.currentModel.replaceConnections(this.modifiedModel.getConnections());
        } else {
            this.logger.warn((Object)"Redo of connections did not finish successfully.");
        }
    }

    public void setTarget(WorkflowNode target) {
        this.targetNode = target;
    }
}

