/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.model.impl;

import de.rcenvironment.core.component.model.api.ComponentImageContainerService;
import de.rcenvironment.core.component.model.api.ComponentInterface;
import de.rcenvironment.core.component.model.impl.ComponentImageContainer;
import de.rcenvironment.core.component.model.impl.ComponentImageUtility;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ServiceScope;

@Component(scope=ServiceScope.SINGLETON)
public class ComponentImageContainerServiceImpl
implements ComponentImageContainerService {
    private List<ComponentImageContainer> componentImageContainerList = new ArrayList<ComponentImageContainer>();

    @Override
    public synchronized ComponentImageContainer getComponentImageContainer(String componentId) {
        if ((componentId = ComponentImageUtility.getNormalId(componentId)) != null) {
            for (ComponentImageContainer entry : this.componentImageContainerList) {
                if (!entry.getComponentId().equals(componentId)) continue;
                return entry;
            }
        } else {
            throw new IllegalArgumentException("ComponentId must not be null");
        }
        ComponentImageContainer container = new ComponentImageContainer(componentId);
        this.componentImageContainerList.add(container);
        return container;
    }

    @Override
    public ComponentImageContainer getComponentImageContainer(ComponentInterface ci) {
        if (ci != null) {
            return this.getComponentImageContainer(ci.getIdentifierAndVersion());
        }
        throw new IllegalArgumentException("Component interface must not be null");
    }
}

