/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.model.endpoint.impl;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinition;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinitionsProvider;
import de.rcenvironment.core.component.model.endpoint.api.EndpointGroupDefinition;
import de.rcenvironment.core.component.model.endpoint.impl.EndpointDefinitionImpl;
import de.rcenvironment.core.component.model.endpoint.impl.EndpointGroupDefinitionImpl;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@JsonIgnoreProperties(ignoreUnknown=true)
public class EndpointDefinitionsProviderImpl
implements Serializable,
EndpointDefinitionsProvider {
    private static final long serialVersionUID = -386695878188756473L;
    private Set<EndpointDefinitionImpl> endpointDefinitions = new HashSet<EndpointDefinitionImpl>();
    private Set<EndpointGroupDefinitionImpl> endpointGroupDefinitions = new HashSet<EndpointGroupDefinitionImpl>();
    @JsonIgnore
    private Map<String, EndpointDefinition> staticEndpointDefinitions = new HashMap<String, EndpointDefinition>();
    @JsonIgnore
    private Map<String, EndpointDefinition> dynamicEndpointDefinitions = new HashMap<String, EndpointDefinition>();
    @JsonIgnore
    private Map<String, EndpointGroupDefinition> staticEndpointGroupDefinitions = new HashMap<String, EndpointGroupDefinition>();
    @JsonIgnore
    private Map<String, EndpointGroupDefinition> dynamicEndpointGroupDefinitions = new HashMap<String, EndpointGroupDefinition>();

    @Override
    @JsonIgnore
    public Set<EndpointDefinition> getStaticEndpointDefinitions() {
        return new HashSet<EndpointDefinition>(this.staticEndpointDefinitions.values());
    }

    @Override
    @JsonIgnore
    public EndpointDefinition getStaticEndpointDefinition(String name) {
        return this.staticEndpointDefinitions.get(name);
    }

    @Override
    @JsonIgnore
    public Set<EndpointDefinition> getDynamicEndpointDefinitions() {
        return new HashSet<EndpointDefinition>(this.dynamicEndpointDefinitions.values());
    }

    @Override
    @JsonIgnore
    public EndpointDefinition getDynamicEndpointDefinition(String id) {
        return this.dynamicEndpointDefinitions.get(id);
    }

    @Override
    @JsonIgnore
    public Set<EndpointGroupDefinition> getDynamicEndpointGroupDefinitions() {
        return new HashSet<EndpointGroupDefinition>(this.dynamicEndpointGroupDefinitions.values());
    }

    @Override
    @JsonIgnore
    public Set<EndpointGroupDefinition> getStaticEndpointGroupDefinitions() {
        return new HashSet<EndpointGroupDefinition>(this.staticEndpointGroupDefinitions.values());
    }

    @Override
    @JsonIgnore
    public EndpointGroupDefinition getDynamicEndpointGroupDefinition(String id) {
        return this.dynamicEndpointGroupDefinitions.get(id);
    }

    public Set<EndpointDefinition> getEndpointDefinitions() {
        return new HashSet<EndpointDefinition>(this.endpointDefinitions);
    }

    public Set<EndpointGroupDefinition> getEndpointGroupDefinitions() {
        return new HashSet<EndpointGroupDefinition>(this.endpointGroupDefinitions);
    }

    public void setEndpointDefinitions(Set<EndpointDefinitionImpl> endpointDefinitionImpls) {
        this.endpointDefinitions = endpointDefinitionImpls;
        for (EndpointDefinition endpointDefinition : endpointDefinitionImpls) {
            if (endpointDefinition.getIdentifier() != null) {
                this.dynamicEndpointDefinitions.put(endpointDefinition.getIdentifier(), endpointDefinition);
                continue;
            }
            this.staticEndpointDefinitions.put(endpointDefinition.getName(), endpointDefinition);
        }
    }

    public void setEndpointGroupDefinitions(Set<EndpointGroupDefinitionImpl> endpointGroupDefinitionImpls) {
        this.endpointGroupDefinitions = endpointGroupDefinitionImpls;
        for (EndpointGroupDefinition endpointGroupDefinition : endpointGroupDefinitionImpls) {
            if (endpointGroupDefinition.getIdentifier() != null) {
                this.dynamicEndpointGroupDefinitions.put(endpointGroupDefinition.getIdentifier(), endpointGroupDefinition);
                continue;
            }
            this.staticEndpointGroupDefinitions.put(endpointGroupDefinition.getName(), endpointGroupDefinition);
        }
    }
}

