/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.inputprovider.gui;

import de.rcenvironment.components.inputprovider.gui.InputProviderDynamicEndpointCommandUtils;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescriptionsManager;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.gui.workflow.editor.commands.endpoint.RemoveDynamicEndpointCommand;
import de.rcenvironment.core.gui.workflow.editor.properties.Refreshable;
import java.util.List;
import java.util.Map;

public class InputProviderRemoveDynamicEndpointCommand
extends RemoveDynamicEndpointCommand {
    public InputProviderRemoveDynamicEndpointCommand(EndpointType direction, String id, List<String> names, Map<String, String> metaData, Refreshable ... refreshable) {
        super(direction, id, names, refreshable);
    }

    public void execute() {
        for (String name : this.names) {
            if (this.direction == EndpointType.INPUT) {
                this.getWorkflowNode().getInputDescriptionsManager();
            } else {
                this.getWorkflowNode().getOutputDescriptionsManager();
            }
            this.getWorkflowNode().getConfigurationDescription().setConfigurationValue(name, null);
            this.getWorkflowNode().getConfigurationDescription().setConfigurationValue(String.valueOf(name) + "_datatype_799ef365", null);
        }
        super.execute();
    }

    public void undo() {
        super.undo();
        for (String name : this.names) {
            EndpointDescription oldDescription = (EndpointDescription)this.oldDescriptions.get(name);
            EndpointDescriptionsManager manager = this.direction == EndpointType.INPUT ? this.getWorkflowNode().getInputDescriptionsManager() : this.getWorkflowNode().getOutputDescriptionsManager();
            if (!oldDescription.getMetaData().containsKey("fileSourceType") || !((String)oldDescription.getMetaData().get("fileSourceType")).equals("atWorkflowStart")) continue;
            InputProviderDynamicEndpointCommandUtils.setValueName(this.getWorkflowNode(), manager.getEndpointDescription(name).getDataType(), name);
        }
    }
}

