/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.notification;

import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.notification.NotificationHeader;
import de.rcenvironment.core.utils.incubator.Assertions;
import java.io.Serializable;

public class Notification
implements Serializable {
    private static final long serialVersionUID = -1148551583045246749L;
    private static final String ASSERT_MUST_NOT_BE_NULL = " must not be null!";
    private final NotificationHeader header;
    private final Serializable body;

    public <T extends Serializable> Notification(String identifier, long sequenceNumber, InstanceNodeSessionId nodeId, T body) {
        Assertions.isDefined((Object)identifier, (String)"The notification identifier must not be null!");
        Assertions.isBiggerThan((long)sequenceNumber, (int)-1, (String)"The sequence number for the first notification is 0 - it needs to be increaded with each new one.");
        Assertions.isDefined((Object)nodeId, (String)"The platform identifier the notification was created on must not be null!");
        this.header = new NotificationHeader(identifier, sequenceNumber, nodeId);
        this.body = body;
    }

    public NotificationHeader getHeader() {
        return this.header;
    }

    public Serializable getBody() {
        return this.body;
    }

    public boolean equals(Object object) {
        if (object instanceof Notification) {
            return this.header.equals(((Notification)object).getHeader()) && this.body.equals(((Notification)object).getBody());
        }
        return false;
    }

    public int hashCode() {
        return this.header.hashCode() + this.body.hashCode();
    }

    public String toString() {
        return String.valueOf(this.header.toString()) + "_" + this.body.toString();
    }
}

