/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.utils.common.configuration;

import de.rcenvironment.core.gui.utils.common.configuration.AdapterManager;
import de.rcenvironment.core.gui.utils.common.configuration.SelectionPropertyDescriptor;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

public class BeanPropertyWidget
extends Composite {
    private IPropertySource propertySource;
    private Control defaultFocusControl;

    public BeanPropertyWidget(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout(2, false);
        this.setLayout((Layout)layout);
    }

    public void setObject(Object object) {
        this.setObject(object, true);
    }

    public void setObject(Object object, boolean lookupPropertySource) {
        if (lookupPropertySource) {
            IPropertySource newPropertySource = (IPropertySource)AdapterManager.getInstance().getAdapter(object, IPropertySource.class);
            if (newPropertySource == null) {
                newPropertySource = (IPropertySource)Platform.getAdapterManager().getAdapter(object, IPropertySource.class);
            }
            this.propertySource = newPropertySource;
            this.setPropertySource(newPropertySource);
        }
        this.createControls();
    }

    protected void setPropertySource(IPropertySource propertySource) {
        this.propertySource = propertySource;
    }

    protected void createControls() {
        List<IPropertyDescriptor> descriptors = Arrays.asList(this.propertySource.getPropertyDescriptors());
        this.sortPropertyDescriptors(descriptors);
        for (IPropertyDescriptor descriptor : descriptors) {
            this.createControls(descriptor);
        }
        this.resetFocus();
    }

    protected void sortPropertyDescriptors(List<? extends IPropertyDescriptor> descriptors) {
        Collections.sort(descriptors, new Comparator<IPropertyDescriptor>(){

            @Override
            public int compare(IPropertyDescriptor o1, IPropertyDescriptor o2) {
                return o1.getDisplayName().toLowerCase().compareTo(o2.getDisplayName().toLowerCase());
            }
        });
    }

    protected void createControls(final IPropertyDescriptor descriptor) {
        Label label = new Label((Composite)this, 0);
        label.setText(descriptor.getDisplayName());
        label.setToolTipText(descriptor.getDescription());
        GridData layoutData = new GridData(36);
        label.setLayoutData((Object)layoutData);
        Composite editorComposite = new Composite((Composite)this, 2048);
        editorComposite.setLayout((Layout)new FillLayout());
        final CellEditor editor = descriptor.createPropertyEditor(editorComposite);
        Control control = editor.getControl();
        if (this.defaultFocusControl == null) {
            this.defaultFocusControl = control;
        }
        Object value = this.propertySource.getPropertyValue(descriptor.getId());
        if (editor instanceof TextCellEditor && value == null) {
            value = "";
        }
        boolean setValue = true;
        if (descriptor instanceof SelectionPropertyDescriptor && value == null) {
            setValue = false;
        }
        if (setValue) {
            editor.setValue(value);
        }
        ICellEditorListener editorListener = new ICellEditorListener(control){
            private final Runnable runnable;
            {
                this.runnable = new Runnable(){

                    @Override
                    public void run() {
                        cellEditor.activate();
                        if (!control.isDisposed()) {
                            control.setVisible(true);
                        }
                    }
                };
            }

            public void cancelEditor() {
                Display.getCurrent().asyncExec(this.runnable);
            }

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            }

            public void applyEditorValue() {
                Object newValue = descriptor instanceof SelectionPropertyDescriptor ? ((SelectionPropertyDescriptor)descriptor).getValue((Integer)editor.getValue()) : editor.getValue();
                BeanPropertyWidget.this.propertySource.setPropertyValue(descriptor.getId(), newValue);
                Display.getCurrent().asyncExec(this.runnable);
            }
        };
        editor.addListener(editorListener);
        control.setBackground(Display.getCurrent().getSystemColor(25));
        editor.activate();
        control.setVisible(true);
        layoutData = new GridData(768);
        editorComposite.setLayoutData((Object)layoutData);
    }

    public void resetFocus() {
        this.defaultFocusControl.setFocus();
    }
}

