/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.utils.common.configuration;

import de.rcenvironment.core.gui.utils.common.configuration.AdapterManager;
import de.rcenvironment.core.gui.utils.common.configuration.BeanPropertySourceAdapter;
import de.rcenvironment.core.gui.utils.common.configuration.ConfigurationViewerContentProvider;
import de.rcenvironment.core.gui.utils.common.configuration.IConfigurationSource;
import de.rcenvironment.core.gui.utils.common.configuration.SelectionPropertyDescriptor;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.configuration.ConfigurationInfo;
import de.rcenvironment.core.utils.incubator.configuration.ConfigurationIntrospector;
import de.rcenvironment.core.utils.incubator.configuration.annotation.Configurable;
import de.rcenvironment.core.utils.incubator.configuration.annotation.Configuration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySource2;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class BeanConfigurationSourceAdapter
extends BeanPropertySourceAdapter
implements IConfigurationSource {
    private final ConfigurationInfo configurationInfo;
    private final Map<String, IPropertyDescriptor> configurationPropertyDescriptors = new HashMap<String, IPropertyDescriptor>();
    private IPropertyDescriptor[] configurationPropertyDescriptorsArray;

    static {
        AdapterManager.getInstance().registerAdapters(new Factory(), Object.class);
        AdapterManager.getInstance().registerAdapters(new ArrayConfigurationSourceAdapter.Factory(), ConfigurationViewerContentProvider.ArraySource.class);
        AdapterManager.getInstance().registerAdapters(new ListConfigurationSourceAdapter.Factory(), List.class);
    }

    public BeanConfigurationSourceAdapter(Object source) {
        super(source);
        this.configurationInfo = ConfigurationIntrospector.getConfigurationInfo(source.getClass());
        this.parse();
    }

    public static void initialize() {
    }

    private void parse() {
        LinkedList<Object> configurationDescriptors = new LinkedList<Object>();
        this.configurationPropertyDescriptors.clear();
        String[] stringArray = this.configurationInfo.getPropertyNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String propertyName = stringArray[n2];
            if (super.isManaged(propertyName)) {
                configurationDescriptors.add(this.getPropertyDescriptor(propertyName));
            } else {
                PropertyDescriptor descriptor;
                final Configurable.ValueProvider valueProvider = this.configurationInfo.getProperty(propertyName).getValueProvider();
                if (valueProvider == null) {
                    descriptor = new PropertyDescriptor((Object)propertyName, propertyName);
                } else {
                    SelectionPropertyDescriptor.ValueProvider valueProvider2 = null;
                    if (valueProvider != null) {
                        valueProvider.setObject(this.getBean());
                        valueProvider2 = new SelectionPropertyDescriptor.ValueProvider(){

                            @Override
                            public Object[] getValues() {
                                return valueProvider.getValues();
                            }
                        };
                    }
                    descriptor = new SelectionPropertyDescriptor(propertyName, propertyName, valueProvider2);
                }
                final Configurable.LabelProvider labelProvider = this.configurationInfo.getProperty(propertyName).getLabelProvider();
                LabelProvider propertyLabelProvider = new LabelProvider(){

                    public String getText(Object element) {
                        return labelProvider.getLabel(element);
                    }
                };
                descriptor.setLabelProvider((ILabelProvider)propertyLabelProvider);
                configurationDescriptors.add(descriptor);
                this.configurationPropertyDescriptors.put(propertyName, (IPropertyDescriptor)descriptor);
            }
            ++n2;
        }
        this.configurationPropertyDescriptorsArray = configurationDescriptors.toArray(new IPropertyDescriptor[configurationDescriptors.size()]);
    }

    @Override
    public IPropertyDescriptor[] getConfigurationPropertyDescriptors() {
        return this.configurationPropertyDescriptorsArray;
    }

    @Override
    protected boolean isManaged(Object id) {
        if (super.isManaged(id)) {
            return true;
        }
        String key = id.toString();
        return this.configurationInfo.getProperty(key) != null;
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (super.isManaged(id)) {
            super.setPropertyValue(id, value);
            return;
        }
        String propertyName = id.toString();
        this.configurationInfo.getProperty(propertyName).setValue(this.getBean(), value);
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (super.isManaged(id)) {
            return super.getPropertyValue(id);
        }
        String propertyName = id.toString();
        Object result = this.configurationInfo.getProperty(propertyName).getValue(this.getBean());
        return result;
    }

    public static final class ArrayConfigurationSourceAdapter
    implements IConfigurationSource {
        private final Object[] array;
        private final ConfigurationViewerContentProvider.ArraySource<?> arraySource;

        public ArrayConfigurationSourceAdapter(Object[] array) {
            this.array = array;
            this.arraySource = null;
        }

        public ArrayConfigurationSourceAdapter(ConfigurationViewerContentProvider.ArraySource<?> arraySource) {
            this.array = null;
            this.arraySource = arraySource;
        }

        private Object[] getArray() {
            if (this.array != null) {
                return this.array;
            }
            return this.arraySource.getValue();
        }

        public Object getEditableValue() {
            Object[] arrayRef = this.getArray();
            return StringUtils.format((String)"%s [%d]", (Object[])new Object[]{arrayRef.getClass().getComponentType().getSimpleName(), arrayRef.length});
        }

        public boolean isPropertySet(Object id) {
            return true;
        }

        public Object getPropertyValue(Object id) {
            Object[] arrayRef = this.getArray();
            Integer index = (Integer)id;
            return arrayRef[index];
        }

        public boolean isPropertyResettable(Object id) {
            return false;
        }

        public void resetPropertyValue(Object id) {
        }

        public IPropertyDescriptor[] getPropertyDescriptors() {
            Object[] arrayRef = this.getArray();
            IPropertyDescriptor[] descriptors = new IPropertyDescriptor[arrayRef.length];
            int index = 0;
            while (index < descriptors.length) {
                descriptors[index] = new PropertyDescriptor((Object)new Integer(index), StringUtils.format((String)"[%d]", (Object[])new Object[]{index}));
                ++index;
            }
            return descriptors;
        }

        @Override
        public IPropertyDescriptor[] getConfigurationPropertyDescriptors() {
            return this.getPropertyDescriptors();
        }

        public void setPropertyValue(Object id, Object value) {
            Object[] arrayRef = this.getArray();
            Integer index = (Integer)id;
            arrayRef[index.intValue()] = value;
        }

        public static final class Factory
        implements IAdapterFactory {
            private static final Class<?>[] ADAPTER_CLASSES = new Class[]{IPropertySource.class, IPropertySource2.class, IConfigurationSource.class};
            private static final ThreadLocal<Boolean> APPLICABLE = new ThreadLocal();

            public Class[] getAdapterList() {
                return ADAPTER_CLASSES;
            }

            public Object getAdapter(Object adaptableObject, Class adapterType) {
                boolean applicable = true;
                if (APPLICABLE.get() != null && !APPLICABLE.get().booleanValue()) {
                    applicable = false;
                }
                if (adaptableObject.getClass().getComponentType() == null && !(adaptableObject instanceof ConfigurationViewerContentProvider.ArraySource)) {
                    applicable = false;
                }
                ArrayConfigurationSourceAdapter result = null;
                if (applicable) {
                    APPLICABLE.set(false);
                    try {
                        Object adapter = Platform.getAdapterManager().getAdapter(adaptableObject, adapterType);
                        if (adapter != null) {
                            Object object = adapter;
                            return object;
                        }
                    }
                    finally {
                        APPLICABLE.set(true);
                    }
                    if (adaptableObject.getClass().getComponentType() != null) {
                        Object[] array = (Object[])adaptableObject;
                        result = new ArrayConfigurationSourceAdapter(array);
                    } else if (adaptableObject instanceof ConfigurationViewerContentProvider.ArraySource) {
                        ConfigurationViewerContentProvider.ArraySource arraySource = (ConfigurationViewerContentProvider.ArraySource)adaptableObject;
                        result = new ArrayConfigurationSourceAdapter(arraySource);
                    } else {
                        throw new AssertionError();
                    }
                }
                return result;
            }
        }
    }

    public static final class Factory
    implements IAdapterFactory {
        private static final Class<?>[] ADAPTER_CLASSES = new Class[]{IPropertySource.class, IPropertySource2.class, IConfigurationSource.class};
        private static final ThreadLocal<Boolean> APPLICABLE = new ThreadLocal();

        public Class[] getAdapterList() {
            return ADAPTER_CLASSES;
        }

        public Object getAdapter(Object adaptableObject, Class adapterType) {
            boolean configuration = false;
            Class<?> clazz = adaptableObject.getClass();
            while (clazz.getSuperclass() != null) {
                if (clazz.isAnnotationPresent(Configuration.class)) {
                    configuration = true;
                    break;
                }
                clazz = clazz.getSuperclass();
            }
            if (!configuration || APPLICABLE.get() != null && !APPLICABLE.get().booleanValue()) {
                return null;
            }
            APPLICABLE.set(false);
            try {
                Object adapter = AdapterManager.getInstance().getAdapter(adaptableObject, adapterType);
                if (adapter != null) {
                    Object object = adapter;
                    return object;
                }
            }
            finally {
                APPLICABLE.set(true);
            }
            return new BeanConfigurationSourceAdapter(adaptableObject);
        }
    }

    public static final class ListConfigurationSourceAdapter
    implements IConfigurationSource {
        private final List<?> list;

        public ListConfigurationSourceAdapter(List<?> list) {
            this.list = list;
        }

        public Object getEditableValue() {
            return StringUtils.format((String)"? [%d]", (Object[])new Object[]{this.list.size()});
        }

        public boolean isPropertySet(Object id) {
            return true;
        }

        public Object getPropertyValue(Object id) {
            Integer index = (Integer)id;
            return this.list.get(index);
        }

        public boolean isPropertyResettable(Object id) {
            return false;
        }

        public void resetPropertyValue(Object id) {
        }

        public IPropertyDescriptor[] getPropertyDescriptors() {
            IPropertyDescriptor[] descriptors = new IPropertyDescriptor[this.list.size()];
            int index = 0;
            while (index < descriptors.length) {
                descriptors[index] = new PropertyDescriptor((Object)new Integer(index), StringUtils.format((String)"[%d]", (Object[])new Object[]{index}));
                ++index;
            }
            return descriptors;
        }

        @Override
        public IPropertyDescriptor[] getConfigurationPropertyDescriptors() {
            return this.getPropertyDescriptors();
        }

        public void setPropertyValue(Object id, Object value) {
            throw new UnsupportedOperationException();
        }

        public static final class Factory
        implements IAdapterFactory {
            private static final Class<?>[] ADAPTER_CLASSES = new Class[]{IPropertySource.class, IPropertySource2.class, IConfigurationSource.class};
            private static final ThreadLocal<Boolean> APPLICABLE = new ThreadLocal();

            public Class[] getAdapterList() {
                return ADAPTER_CLASSES;
            }

            public Object getAdapter(Object adaptableObject, Class adapterType) {
                if (APPLICABLE.get() != null && !APPLICABLE.get().booleanValue()) {
                    return null;
                }
                APPLICABLE.set(false);
                try {
                    Object adapter = Platform.getAdapterManager().getAdapter(adaptableObject, adapterType);
                    if (adapter != null) {
                        Object object = adapter;
                        return object;
                    }
                }
                finally {
                    APPLICABLE.set(true);
                }
                List list = (List)adaptableObject;
                return new ListConfigurationSourceAdapter(list);
            }
        }
    }
}

