/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.pop3;

import com.icegreen.greenmail.foedus.util.StreamUtils;
import com.icegreen.greenmail.pop3.Pop3Handler;
import com.icegreen.greenmail.util.InternetPrintWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pop3Connection {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    Pop3Handler _handler;
    private static final int TIMEOUT_MILLIS = 30000;
    Socket _socket;
    InetAddress _clientAddress;
    BufferedReader _in;
    InternetPrintWriter _out;

    public Pop3Connection(Pop3Handler handler, Socket socket) throws IOException {
        this.configureSocket(socket);
        this.configureStreams();
        this._handler = handler;
    }

    private void configureStreams() throws IOException {
        OutputStream o = this._socket.getOutputStream();
        InputStream i = this._socket.getInputStream();
        this._out = new InternetPrintWriter(o, true);
        this._in = new BufferedReader(new InputStreamReader(i));
    }

    private void configureSocket(Socket socket) throws SocketException {
        this._socket = socket;
        this._socket.setSoTimeout(30000);
        this._clientAddress = this._socket.getInetAddress();
    }

    public void close() throws IOException {
        this._socket.close();
    }

    public void quit() {
        this._handler.close();
    }

    public void println(String line) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("S: " + line);
        }
        this._out.print(line);
        this.println();
    }

    public void println() {
        this._out.print("\r\n");
        this._out.flush();
    }

    public void print(Reader in) throws IOException {
        StreamUtils.copy(in, this._out);
        this._out.flush();
    }

    public String readLine() throws IOException {
        String line = this._in.readLine();
        if (this.log.isDebugEnabled()) {
            this.log.debug("C: " + line);
        }
        return line;
    }

    public String getClientAddress() {
        return this._clientAddress.toString();
    }
}

