/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.palette.view.dialogs;

import de.rcenvironment.core.gui.palette.GroupNameValidator;
import de.rcenvironment.core.gui.palette.ToolGroupAssignment;
import de.rcenvironment.core.gui.palette.toolidentification.ToolIdentification;
import de.rcenvironment.core.gui.palette.view.PaletteViewContentProvider;
import de.rcenvironment.core.gui.palette.view.palettetreenodes.ComponentNode;
import de.rcenvironment.core.gui.palette.view.palettetreenodes.GroupNode;
import de.rcenvironment.core.gui.palette.view.palettetreenodes.PaletteTreeNode;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditCustomGroupDialog
extends TitleAreaDialog {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final PaletteViewContentProvider contentProvider;
    private ToolGroupAssignment assignment;
    private PaletteTreeNode groupNode;
    private String previousGroupString;
    private List<PaletteTreeNode> currentGroups;
    private Text editGroupText;
    private boolean groupUpdated = false;

    public EditCustomGroupDialog(Shell parentShell, PaletteTreeNode groupNode, PaletteViewContentProvider contentProvider) {
        super(parentShell);
        this.contentProvider = contentProvider;
        this.assignment = contentProvider.getAssignment();
        this.groupNode = groupNode;
        this.currentGroups = groupNode.getPaletteParent().getSubGroups();
        this.previousGroupString = groupNode.getNodeName();
    }

    public void create() {
        super.create();
        this.setTitle("Edit Group Dialog");
        this.setMessage(StringUtils.format((String)"Update name of custom group '%s'", (Object[])new Object[]{this.groupNode.getNodeName()}));
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        Composite content = new Composite(container, 0);
        content.setLayout((Layout)new GridLayout(2, false));
        GridData contentData = new GridData(768);
        content.setLayoutData((Object)contentData);
        CLabel label = new CLabel(content, 0);
        label.setText("Set Group Name:");
        this.editGroupText = new Text(content, 2048);
        GridData editGroupGridData = new GridData(768);
        this.editGroupText.setLayoutData((Object)editGroupGridData);
        this.editGroupText.setEditable(true);
        this.editGroupText.setText(this.previousGroupString);
        this.editGroupText.setSelection(0, this.editGroupText.getText().length());
        this.editGroupText.addModifyListener((ModifyListener)new EditGroupModifyListener());
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.getButton(0).setEnabled(false);
    }

    protected void okPressed() {
        String groupString = this.editGroupText.getText().trim();
        if (!groupString.equals(this.previousGroupString)) {
            String previousPath = this.groupNode.getQualifiedGroupName();
            this.groupNode.setNodeName(groupString);
            Stream<ComponentNode> predefinedNodes = null;
            if (this.groupNode.hasChildren()) {
                Stream<ComponentNode> stream1 = Arrays.stream(this.groupNode.getChildren()).filter(ComponentNode.class::isInstance).map(ComponentNode.class::cast);
                Stream stream2 = this.groupNode.getAllSubGroups().stream().filter(TreeNode::hasChildren).flatMap(GroupNode::getAllComponentNodes);
                predefinedNodes = Stream.concat(stream1, stream2).filter(node -> !this.assignment.getCustomizedAssignments().containsKey(node.getToolIdentification()));
                this.updateCustomizedAssignments(this.groupNode.getChildren(), this.groupNode.getQualifiedGroupName());
                this.groupNode.getAllSubGroups().stream().filter(TreeNode::hasChildren).forEach(node -> this.updateCustomizedAssignments(node.getChildren(), node.getQualifiedGroupName()));
            }
            if (predefinedNodes != null) {
                predefinedNodes.forEach(this.contentProvider::resetGroup);
            }
            this.groupUpdated = true;
            this.log.debug((Object)StringUtils.format((String)"Renamed group '%s' to '%s'", (Object[])new Object[]{previousPath, this.groupNode.getQualifiedGroupName()}));
        }
        super.okPressed();
    }

    private void updateCustomizedAssignments(TreeNode[] treeNodes, String qualifiedGroupString) {
        String[] groupPath = this.assignment.createPathArray(qualifiedGroupString);
        Map<ToolIdentification, String[]> customizedAssignments = this.assignment.getCustomizedAssignments();
        Arrays.stream(treeNodes).filter(ComponentNode.class::isInstance).map(ComponentNode.class::cast).forEach(node -> this.updateAssignmentMap(customizedAssignments, node.getToolIdentification().getToolID(), groupPath));
        this.assignment.setCustomizedAssignments(customizedAssignments);
    }

    private void updateAssignmentMap(Map<ToolIdentification, String[]> customizedAssignments, String installationId, String[] groupPath) {
        for (Map.Entry<ToolIdentification, String[]> entry : customizedAssignments.entrySet()) {
            if (!entry.getKey().getToolID().equals(installationId)) continue;
            entry.setValue(groupPath);
            break;
        }
    }

    public boolean isGroupUpdated() {
        return this.groupUpdated;
    }

    private class EditGroupModifyListener
    implements ModifyListener {
        private EditGroupModifyListener() {
        }

        public void modifyText(ModifyEvent arg0) {
            EditCustomGroupDialog.this.setErrorMessage(null);
            String modifiedText = EditCustomGroupDialog.this.editGroupText.getText();
            if (modifiedText.equals(EditCustomGroupDialog.this.previousGroupString)) {
                EditCustomGroupDialog.this.getButton(0).setEnabled(false);
                return;
            }
            GroupNameValidator validator = new GroupNameValidator(EditCustomGroupDialog.this.currentGroups, EditCustomGroupDialog.this.groupNode.getPaletteParent().isRoot());
            Optional<String> validationMessage = validator.valdiateText(modifiedText);
            EditCustomGroupDialog.this.getButton(0).setEnabled(!validationMessage.isPresent());
            if (validationMessage.isPresent()) {
                EditCustomGroupDialog.this.setErrorMessage(validationMessage.get());
            }
        }
    }
}

