/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.authorization;

import de.rcenvironment.core.authorization.api.AuthorizationService;
import de.rcenvironment.core.gui.authorization.ImportGroupKeyDialog;
import de.rcenvironment.core.utils.common.exception.OperationFailureException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public final class ImportGroupKeyAction
extends Action {
    private static final String APOSTROPHE = "'";
    private static final String DOT = ".";
    private AuthorizationService authorizationService;
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public ImportGroupKeyAction(AuthorizationService authorizationService) {
        super("Import Group Key...");
        this.authorizationService = authorizationService;
    }

    public void run() {
        Display display = Display.getDefault();
        Shell shell = display.getActiveShell();
        ImportGroupKeyDialog importGroupKeyDialog = new ImportGroupKeyDialog(shell);
        int id = importGroupKeyDialog.open();
        if (id == 0) {
            String importKey = importGroupKeyDialog.getKeyToImport().trim();
            try {
                this.authorizationService.importFromString(importKey);
            }
            catch (OperationFailureException operationFailureException) {
                this.log.error((Object)("Failed to import access group for key '" + importKey + APOSTROPHE + DOT));
            }
        }
    }
}

