/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.integration;

import de.rcenvironment.core.component.model.configuration.api.ReadOnlyConfiguration;
import de.rcenvironment.core.gui.workflow.editor.documentation.ToolIntegrationDocumentationGUIHelper;
import de.rcenvironment.core.gui.workflow.editor.properties.ValidatingWorkflowNodePropertySection;
import de.rcenvironment.core.gui.workflow.integration.Messages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class ToolInformationSection
extends ValidatingWorkflowNodePropertySection {
    private Label toolNameLabel;
    private Label integratorNameLabel;
    private Label integratorEmailLabel;
    private Label toolDescriptionLabel;
    private Composite infoComposite;

    protected void createCompositeContent(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        parent.setLayoutData((Object)new GridData(1808));
        parent.setLayout((Layout)new GridLayout(1, true));
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(1, true));
        Section infoSection = this.getWidgetFactory().createSection(composite, 256);
        infoSection.setLayoutData((Object)new GridData(1808));
        infoSection.setText(Messages.infoSection);
        this.infoComposite = this.getWidgetFactory().createFlatFormComposite((Composite)infoSection);
        this.infoComposite.setLayout((Layout)new GridLayout(2, false));
        new Label(this.infoComposite, 0).setText(Messages.toolNameLabel);
        this.toolNameLabel = new Label(this.infoComposite, 0);
        new Label(this.infoComposite, 0).setText(Messages.toolIntegratorNameLabel);
        this.integratorNameLabel = new Label(this.infoComposite, 0);
        new Label(this.infoComposite, 0).setText(Messages.toolIntegratorEmailLabel);
        this.integratorEmailLabel = new Label(this.infoComposite, 0);
        Label descriptionLabel = new Label(this.infoComposite, 1);
        descriptionLabel.setText(Messages.toolDescriptionLabel);
        GridData labelGridData = new GridData();
        labelGridData.verticalAlignment = 1;
        descriptionLabel.setLayoutData((Object)labelGridData);
        this.toolDescriptionLabel = new Label(this.infoComposite, 0);
        Button toolDocumentationButton = new Button(this.infoComposite, 8);
        GridData docuData = new GridData();
        docuData.horizontalSpan = 1;
        toolDocumentationButton.setLayoutData((Object)docuData);
        toolDocumentationButton.setText("Open Documentation");
        toolDocumentationButton.addSelectionListener(this.createDocumentationButtonSelectionListener(false));
        Button exportDocumentationButton = new Button(this.infoComposite, 8);
        exportDocumentationButton.setLayoutData((Object)docuData);
        exportDocumentationButton.setText("Export Documentation");
        exportDocumentationButton.addSelectionListener(this.createDocumentationButtonSelectionListener(true));
        infoSection.setClient((Control)this.infoComposite);
    }

    public void aboutToBeShown() {
        super.aboutToBeShown();
        this.updateLabel();
        this.infoComposite.layout();
    }

    public void refreshSection() {
        super.refreshSection();
        this.aboutToBeShown();
    }

    private void updateLabel() {
        this.toolNameLabel.setText("");
        this.integratorNameLabel.setText("");
        this.integratorEmailLabel.setText("");
        this.toolDescriptionLabel.setText("");
        ReadOnlyConfiguration readOnlyconfig = this.getConfiguration().getConfigurationDescription().getComponentConfigurationDefinition().getReadOnlyConfiguration();
        readOnlyconfig.getValue("toolName");
        if (readOnlyconfig.getValue("toolName") != null) {
            this.toolNameLabel.setText(readOnlyconfig.getValue("toolName"));
        }
        if (readOnlyconfig.getValue("toolIntegratorName") != null) {
            this.integratorNameLabel.setText(readOnlyconfig.getValue("toolIntegratorName"));
        }
        if (readOnlyconfig.getValue("toolIntegratorE-Mail") != null) {
            this.integratorEmailLabel.setText(readOnlyconfig.getValue("toolIntegratorE-Mail"));
        }
        if (readOnlyconfig.getValue("toolDescription") != null) {
            this.toolDescriptionLabel.setText(readOnlyconfig.getValue("toolDescription"));
        }
    }

    protected SelectionListener createDocumentationButtonSelectionListener(final boolean export) {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                String identifier = ToolInformationSection.this.getConfiguration().getComponentIdentifierWithVersion();
                ToolIntegrationDocumentationGUIHelper.getInstance().showComponentDocumentation(identifier, export);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        };
    }
}

