/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.screen;

import com.googlecode.lanterna.input.Key;
import com.googlecode.lanterna.screen.ScreenCharacter;
import com.googlecode.lanterna.screen.ScreenCharacterStyle;
import com.googlecode.lanterna.screen.TabBehaviour;
import com.googlecode.lanterna.terminal.Terminal;
import com.googlecode.lanterna.terminal.TerminalPosition;
import com.googlecode.lanterna.terminal.TerminalSize;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeMap;

public class Screen {
    private final Object mutex = new Object();
    private final Terminal terminal;
    private final LinkedList<TerminalSize> resizeQueue;
    private TerminalPosition cursorPosition;
    private TerminalSize terminalSize;
    private ScreenCharacter[][] visibleScreen;
    private ScreenCharacter[][] backbuffer;
    private ScreenCharacter paddingCharacter;
    private boolean wholeScreenInvalid;
    private boolean hasBeenActivated;
    private TabBehaviour tabBehaviour;

    public Screen(Terminal terminal) {
        this(terminal, terminal.queryTerminalSize());
    }

    public Screen(Terminal terminal, TerminalSize terminalSize) {
        this(terminal, terminalSize.getColumns(), terminalSize.getRows());
    }

    public Screen(Terminal terminal, int terminalWidth, int terminalHeight) {
        this.terminal = terminal;
        this.terminalSize = new TerminalSize(terminalWidth, terminalHeight);
        this.visibleScreen = new ScreenCharacter[terminalHeight][terminalWidth];
        this.backbuffer = new ScreenCharacter[terminalHeight][terminalWidth];
        this.paddingCharacter = new ScreenCharacter('X', Terminal.Color.GREEN, Terminal.Color.BLACK);
        this.resizeQueue = new LinkedList();
        this.wholeScreenInvalid = false;
        this.hasBeenActivated = false;
        this.cursorPosition = new TerminalPosition(0, 0);
        this.tabBehaviour = TabBehaviour.ALIGN_TO_COLUMN_8;
        this.terminal.addResizeListener(new TerminalResizeListener());
        this.clear();
    }

    public Terminal getTerminal() {
        return this.terminal;
    }

    public TerminalPosition getCursorPosition() {
        return this.cursorPosition;
    }

    public void setCursorPosition(TerminalPosition position) {
        this.cursorPosition = position != null ? new TerminalPosition(position) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCursorPosition(int column, int row) {
        Object object = this.mutex;
        synchronized (object) {
            if (column >= 0 && column < this.terminalSize.getColumns() && row >= 0 && row < this.terminalSize.getRows()) {
                this.setCursorPosition(new TerminalPosition(column, row));
            }
        }
    }

    public void setTabBehaviour(TabBehaviour tabBehaviour) {
        if (tabBehaviour != null) {
            this.tabBehaviour = tabBehaviour;
        }
    }

    public void setPaddingCharacter(char character, Terminal.Color foregroundColor, Terminal.Color backgroundColor, ScreenCharacterStyle ... style) {
        this.paddingCharacter = new ScreenCharacter(character, foregroundColor, backgroundColor, new HashSet<ScreenCharacterStyle>(Arrays.asList(style)));
    }

    public TabBehaviour getTabBehaviour() {
        return this.tabBehaviour;
    }

    public Key readInput() {
        return this.terminal.readInput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalSize getTerminalSize() {
        Object object = this.mutex;
        synchronized (object) {
            return this.terminalSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startScreen() {
        if (this.hasBeenActivated) {
            return;
        }
        this.hasBeenActivated = true;
        this.terminal.enterPrivateMode();
        this.terminal.getTerminalSize();
        Object object = this.mutex;
        synchronized (object) {
            this.resizeScreenIfNeeded();
        }
        this.terminal.clearScreen();
        this.clear();
        if (this.cursorPosition != null) {
            this.terminal.setCursorVisible(true);
            this.terminal.moveCursor(this.cursorPosition.getColumn(), this.cursorPosition.getRow());
        } else {
            this.terminal.setCursorVisible(false);
        }
        this.refresh();
    }

    public void stopScreen() {
        if (!this.hasBeenActivated) {
            return;
        }
        while (this.readInput() != null) {
        }
        this.terminal.exitPrivateMode();
        this.hasBeenActivated = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ScreenCharacter background = new ScreenCharacter(' ');
        Object object = this.mutex;
        synchronized (object) {
            for (int y = 0; y < this.terminalSize.getRows(); ++y) {
                for (int x = 0; x < this.terminalSize.getColumns(); ++x) {
                    this.backbuffer[y][x] = background;
                }
            }
        }
    }

    public void putString(int x, int y, String string, Terminal.Color foregroundColor, Terminal.Color backgroundColor, ScreenCharacterStyle ... styles) {
        EnumSet<ScreenCharacterStyle> drawStyle = EnumSet.noneOf(ScreenCharacterStyle.class);
        drawStyle.addAll(Arrays.asList(styles));
        this.putString(x, y, string, foregroundColor, backgroundColor, drawStyle);
    }

    public void putString(int x, int y, String string, Terminal.Color foregroundColor, Terminal.Color backgroundColor, Set<ScreenCharacterStyle> styles) {
        string = this.tabBehaviour.replaceTabs(string, x);
        for (int i = 0; i < string.length(); ++i) {
            this.putCharacter(x + i, y, new ScreenCharacter(string.charAt(i), foregroundColor, backgroundColor, styles));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putCharacter(int x, int y, ScreenCharacter character) {
        Object object = this.mutex;
        synchronized (object) {
            if (y < 0 || y >= this.backbuffer.length || x < 0 || x >= this.backbuffer[0].length) {
                return;
            }
            if (!this.backbuffer[y][x].equals(character)) {
                this.backbuffer[y][x] = new ScreenCharacter(character);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resizePending() {
        LinkedList<TerminalSize> linkedList = this.resizeQueue;
        synchronized (linkedList) {
            return !this.resizeQueue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateScreenSize() {
        if (!this.resizePending()) {
            return false;
        }
        Object object = this.mutex;
        synchronized (object) {
            this.resizeScreenIfNeeded();
        }
        return true;
    }

    public void completeRefresh() {
        this.wholeScreenInvalid = true;
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        if (!this.hasBeenActivated) {
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            this.resizeScreenIfNeeded();
            TreeMap<TerminalPosition, ScreenCharacter> updateMap = new TreeMap<TerminalPosition, ScreenCharacter>(new ScreenPointComparator());
            for (int y = 0; y < this.terminalSize.getRows(); ++y) {
                for (int x = 0; x < this.terminalSize.getColumns(); ++x) {
                    ScreenCharacter c = this.backbuffer[y][x];
                    if (c.equals(this.visibleScreen[y][x]) && !this.wholeScreenInvalid) continue;
                    this.visibleScreen[y][x] = c;
                    updateMap.put(new TerminalPosition(x, y), c);
                }
            }
            Writer terminalWriter = new Writer();
            terminalWriter.reset();
            TerminalPosition previousPoint = null;
            for (TerminalPosition nextUpdate : updateMap.keySet()) {
                if (previousPoint == null || previousPoint.getRow() != nextUpdate.getRow() || previousPoint.getColumn() + 1 != nextUpdate.getColumn()) {
                    terminalWriter.setCursorPosition(nextUpdate.getColumn(), nextUpdate.getRow());
                }
                terminalWriter.writeCharacter((ScreenCharacter)updateMap.get(nextUpdate));
                previousPoint = nextUpdate;
            }
            if (this.cursorPosition != null) {
                terminalWriter.setCursorVisible(true);
                terminalWriter.setCursorPosition(this.cursorPosition.getColumn(), this.cursorPosition.getRow());
            } else {
                terminalWriter.setCursorVisible(false);
            }
            this.wholeScreenInvalid = false;
        }
        this.terminal.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resizeScreenIfNeeded() {
        TerminalSize newSize;
        LinkedList<TerminalSize> linkedList = this.resizeQueue;
        synchronized (linkedList) {
            if (this.resizeQueue.isEmpty()) {
                return;
            }
            newSize = this.resizeQueue.getLast();
            this.resizeQueue.clear();
        }
        int height = newSize.getRows();
        int width = newSize.getColumns();
        ScreenCharacter[][] newBackBuffer = new ScreenCharacter[height][width];
        ScreenCharacter[][] newVisibleScreen = new ScreenCharacter[height][width];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                newBackBuffer[y][x] = this.backbuffer.length > 0 && x < this.backbuffer[0].length && y < this.backbuffer.length ? this.backbuffer[y][x] : new ScreenCharacter(this.paddingCharacter);
                newVisibleScreen[y][x] = this.visibleScreen.length > 0 && x < this.visibleScreen[0].length && y < this.visibleScreen.length ? this.visibleScreen[y][x] : new ScreenCharacter(this.paddingCharacter);
            }
        }
        this.backbuffer = newBackBuffer;
        this.visibleScreen = newVisibleScreen;
        this.wholeScreenInvalid = true;
        this.terminalSize = new TerminalSize(newSize);
    }

    private class Writer {
        private Terminal.Color currentForegroundColor = Terminal.Color.DEFAULT;
        private Terminal.Color currentBackgroundColor = Terminal.Color.DEFAULT;
        private boolean currentlyIsBold = false;
        private boolean currentlyIsUnderline = false;
        private boolean currentlyIsNegative = false;
        private boolean currentlyIsBlinking = false;

        void setCursorPosition(int x, int y) {
            Screen.this.terminal.moveCursor(x, y);
        }

        private void setCursorVisible(boolean visible) {
            Screen.this.terminal.setCursorVisible(visible);
        }

        void writeCharacter(ScreenCharacter character) {
            if (this.currentlyIsBlinking != character.isBlinking()) {
                if (character.isBlinking()) {
                    Screen.this.terminal.applySGR(Terminal.SGR.ENTER_BLINK);
                    this.currentlyIsBlinking = true;
                } else {
                    Screen.this.terminal.applySGR(Terminal.SGR.RESET_ALL);
                    Screen.this.terminal.applyBackgroundColor(character.getBackgroundColor());
                    Screen.this.terminal.applyForegroundColor(character.getForegroundColor());
                    this.currentlyIsBold = false;
                    this.currentlyIsUnderline = false;
                    this.currentlyIsNegative = false;
                    this.currentlyIsBlinking = false;
                }
            }
            if (this.currentForegroundColor != character.getForegroundColor()) {
                Screen.this.terminal.applyForegroundColor(character.getForegroundColor());
                this.currentForegroundColor = character.getForegroundColor();
            }
            if (this.currentBackgroundColor != character.getBackgroundColor()) {
                Screen.this.terminal.applyBackgroundColor(character.getBackgroundColor());
                this.currentBackgroundColor = character.getBackgroundColor();
            }
            if (this.currentlyIsBold != character.isBold()) {
                if (character.isBold()) {
                    Screen.this.terminal.applySGR(Terminal.SGR.ENTER_BOLD);
                    this.currentlyIsBold = true;
                } else {
                    Screen.this.terminal.applySGR(Terminal.SGR.EXIT_BOLD);
                    this.currentlyIsBold = false;
                }
            }
            if (this.currentlyIsUnderline != character.isUnderline()) {
                if (character.isUnderline()) {
                    Screen.this.terminal.applySGR(Terminal.SGR.ENTER_UNDERLINE);
                    this.currentlyIsUnderline = true;
                } else {
                    Screen.this.terminal.applySGR(Terminal.SGR.EXIT_UNDERLINE);
                    this.currentlyIsUnderline = false;
                }
            }
            if (this.currentlyIsNegative != character.isNegative()) {
                if (character.isNegative()) {
                    Screen.this.terminal.applySGR(Terminal.SGR.ENTER_REVERSE);
                    this.currentlyIsNegative = true;
                } else {
                    Screen.this.terminal.applySGR(Terminal.SGR.EXIT_REVERSE);
                    this.currentlyIsNegative = false;
                }
            }
            Screen.this.terminal.putCharacter(character.getCharacter());
        }

        void reset() {
            Screen.this.terminal.applySGR(Terminal.SGR.RESET_ALL);
            Screen.this.terminal.moveCursor(0, 0);
            this.currentBackgroundColor = Terminal.Color.DEFAULT;
            this.currentForegroundColor = Terminal.Color.DEFAULT;
            this.currentlyIsBold = false;
            this.currentlyIsNegative = false;
            this.currentlyIsUnderline = false;
        }
    }

    private class TerminalResizeListener
    implements Terminal.ResizeListener {
        private TerminalResizeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onResized(TerminalSize newSize) {
            LinkedList linkedList = Screen.this.resizeQueue;
            synchronized (linkedList) {
                if (!Screen.this.terminalSize.equals(newSize)) {
                    Screen.this.resizeQueue.add(newSize);
                }
            }
        }
    }

    private static class ScreenPointComparator
    implements Comparator<TerminalPosition> {
        private ScreenPointComparator() {
        }

        @Override
        public int compare(TerminalPosition o1, TerminalPosition o2) {
            if (o1.getRow() == o2.getRow()) {
                if (o1.getColumn() == o2.getColumn()) {
                    return 0;
                }
                return new Integer(o1.getColumn()).compareTo(o2.getColumn());
            }
            return new Integer(o1.getRow()).compareTo(o2.getRow());
        }
    }
}

