/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.input;

import com.googlecode.lanterna.input.CharacterPattern;
import com.googlecode.lanterna.input.Key;
import java.util.List;

public class NormalCharacterPattern
implements CharacterPattern {
    @Override
    public Key getResult(List<Character> matching) {
        return new Key(matching.get(0).charValue(), false, false);
    }

    @Override
    public boolean isCompleteMatch(List<Character> currentMatching) {
        return currentMatching.size() == 1;
    }

    @Override
    public boolean matches(List<Character> currentMatching) {
        if (currentMatching.size() != 1) {
            return false;
        }
        return NormalCharacterPattern.isPrintableChar(currentMatching.get(0).charValue());
    }

    private static boolean isPrintableChar(char c) {
        Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
        return !Character.isISOControl(c) && block != null && block != Character.UnicodeBlock.SPECIALS;
    }
}

