/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.input;

public class Key {
    private final Kind kind;
    private final char character;
    private final boolean altPressed;
    private final boolean ctrlPressed;

    public Key(char character) {
        this(character, false, false);
    }

    public Key(char character, boolean ctrlPressed, boolean altPressed) {
        this.character = character;
        this.kind = Kind.NormalKey;
        this.ctrlPressed = ctrlPressed;
        this.altPressed = altPressed;
    }

    public Key(Kind kind) {
        this.kind = kind;
        this.character = kind.getRepresentationKey();
        this.altPressed = false;
        this.ctrlPressed = false;
    }

    public Key(Kind kind, boolean ctrlPressed, boolean altPressed) {
        this.kind = kind;
        this.character = kind.getRepresentationKey();
        this.altPressed = altPressed;
        this.ctrlPressed = ctrlPressed;
    }

    public Kind getKind() {
        return this.kind;
    }

    public char getCharacter() {
        return this.character;
    }

    public boolean isAltPressed() {
        return this.altPressed;
    }

    public boolean isCtrlPressed() {
        return this.ctrlPressed;
    }

    public String toString() {
        return this.getKind().toString() + (this.getKind() == Kind.NormalKey ? ": " + this.character : "") + (this.ctrlPressed ? " (ctrl)" : "") + (this.altPressed ? " (alt)" : "");
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Key other = (Key)obj;
        if (this.kind != other.kind) {
            return false;
        }
        if (this.character != other.character) {
            return false;
        }
        if (this.altPressed != other.altPressed) {
            return false;
        }
        return this.ctrlPressed == other.ctrlPressed;
    }

    public int hashCode() {
        int hash = 7;
        hash = 19 * hash + (this.kind != null ? this.kind.hashCode() : 0);
        hash = 19 * hash + this.character;
        hash = 19 * hash + (this.altPressed ? 1 : 0);
        hash = 19 * hash + (this.ctrlPressed ? 1 : 0);
        return hash;
    }

    public static enum Kind {
        NormalKey('N'),
        Escape('\\'),
        Backspace('B'),
        ArrowLeft('L'),
        ArrowRight('R'),
        ArrowUp('U'),
        ArrowDown('D'),
        Insert('I'),
        Delete('T'),
        Home('H'),
        End('E'),
        PageUp('P'),
        PageDown('O'),
        Tab('\t'),
        ReverseTab('/'),
        Enter('\n'),
        F1('1'),
        F2('2'),
        F3('3'),
        F4('4'),
        F5('5'),
        F6('6'),
        F7('7'),
        F8('8'),
        F9('9'),
        F10('Q'),
        F11('W'),
        F12('Y'),
        Unknown('!'),
        CursorLocation('\u00a3'),
        EOF('$');

        private char representationKey;

        private Kind(char representationKey) {
            this.representationKey = representationKey;
        }

        public char getRepresentationKey() {
            return this.representationKey;
        }
    }
}

