/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.input;

import com.googlecode.lanterna.input.CharacterPattern;
import com.googlecode.lanterna.input.Key;
import java.util.List;

public class AltAndCharacterPattern
implements CharacterPattern {
    @Override
    public Key getResult(List<Character> matching) {
        return new Key(matching.get(1).charValue(), false, true);
    }

    @Override
    public boolean isCompleteMatch(List<Character> currentMatching) {
        if (currentMatching.size() != 2) {
            return false;
        }
        if (currentMatching.get(0).charValue() != '\u001b') {
            return false;
        }
        return Character.isLetterOrDigit(currentMatching.get(1).charValue());
    }

    @Override
    public boolean matches(List<Character> currentMatching) {
        if (currentMatching.get(0).charValue() != '\u001b') {
            return false;
        }
        if (currentMatching.size() == 1) {
            return true;
        }
        if (!Character.isLetterOrDigit(currentMatching.get(1).charValue())) {
            return false;
        }
        return currentMatching.size() == 2;
    }
}

