/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui.layout;

import com.googlecode.lanterna.gui.Component;
import com.googlecode.lanterna.gui.layout.DefaultLaidOutComponent;
import com.googlecode.lanterna.gui.layout.LayoutManager;
import com.googlecode.lanterna.gui.layout.LayoutParameter;
import com.googlecode.lanterna.terminal.TerminalPosition;
import com.googlecode.lanterna.terminal.TerminalSize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BorderLayout
implements LayoutManager {
    public static final LayoutParameter CENTER = new LayoutParameter("BorderLayout.CENTER");
    public static final LayoutParameter LEFT = new LayoutParameter("BorderLayout.LEFT");
    public static final LayoutParameter RIGHT = new LayoutParameter("BorderLayout.RIGHT");
    public static final LayoutParameter TOP = new LayoutParameter("BorderLayout.TOP");
    public static final LayoutParameter BOTTOM = new LayoutParameter("BorderLayout.BOTTOM");
    private static final Set<LayoutParameter> BORDER_LAYOUT_POSITIONS = Collections.unmodifiableSet(new HashSet<LayoutParameter>(Arrays.asList(CENTER, LEFT, RIGHT, TOP, BOTTOM)));
    private final Map<LayoutParameter, Component> components = new IdentityHashMap<LayoutParameter, Component>(5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addComponent(Component component, LayoutParameter ... parameters) {
        if (parameters.length == 0) {
            parameters = new LayoutParameter[]{CENTER};
        } else {
            if (parameters.length > 1) {
                throw new IllegalArgumentException("Calling BorderLayout.addComponent with more than one layout parameter");
            }
            if (!BORDER_LAYOUT_POSITIONS.contains(parameters[0])) {
                throw new IllegalArgumentException("Calling BorderLayout.addComponent layout parameter " + parameters[0] + " is not allowed");
            }
            if (component == null) {
                throw new IllegalArgumentException("Calling BorderLayout.addComponent component parameter set to null is not allowed");
            }
        }
        this.removeComponent(component);
        Map<LayoutParameter, Component> map = this.components;
        synchronized (map) {
            this.components.put(parameters[0], component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeComponent(Component component) {
        Map<LayoutParameter, Component> map = this.components;
        synchronized (map) {
            for (LayoutParameter parameter : BORDER_LAYOUT_POSITIONS) {
                if (this.components.get(parameter) != component) continue;
                this.components.remove(parameter);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TerminalSize getPreferredSize() {
        Map<LayoutParameter, Component> map = this.components;
        synchronized (map) {
            int preferredHeight = (this.components.containsKey(TOP) ? this.components.get(TOP).getPreferredSize().getRows() : 0) + Math.max(this.components.containsKey(LEFT) ? this.components.get(LEFT).getPreferredSize().getRows() : 0, Math.max(this.components.containsKey(CENTER) ? this.components.get(CENTER).getPreferredSize().getRows() : 0, this.components.containsKey(RIGHT) ? this.components.get(RIGHT).getPreferredSize().getRows() : 0)) + (this.components.containsKey(BOTTOM) ? this.components.get(BOTTOM).getPreferredSize().getRows() : 0);
            int preferredWidth = Math.max((this.components.containsKey(LEFT) ? this.components.get(LEFT).getPreferredSize().getColumns() : 0) + (this.components.containsKey(CENTER) ? this.components.get(CENTER).getPreferredSize().getColumns() : 0) + (this.components.containsKey(RIGHT) ? this.components.get(RIGHT).getPreferredSize().getColumns() : 0), Math.max(this.components.containsKey(TOP) ? this.components.get(TOP).getPreferredSize().getColumns() : 0, this.components.containsKey(BOTTOM) ? this.components.get(BOTTOM).getPreferredSize().getColumns() : 0));
            return new TerminalSize(preferredWidth, preferredHeight);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<? extends LayoutManager.LaidOutComponent> layout(TerminalSize layoutArea) {
        int availableHorizontalSpace = layoutArea.getColumns();
        int availableVerticalSpace = layoutArea.getRows();
        ArrayList<DefaultLaidOutComponent> finalLayout = new ArrayList<DefaultLaidOutComponent>();
        Map<LayoutParameter, Component> map = this.components;
        synchronized (map) {
            int topComponentHeight = 0;
            int leftComponentWidth = 0;
            if (this.components.containsKey(TOP)) {
                Component topComponent = this.components.get(TOP);
                topComponentHeight = Math.min(topComponent.getPreferredSize().getRows(), availableVerticalSpace);
                finalLayout.add(new DefaultLaidOutComponent(topComponent, new TerminalSize(availableHorizontalSpace, topComponentHeight), new TerminalPosition(0, 0)));
                availableVerticalSpace -= topComponentHeight;
            }
            if (this.components.containsKey(BOTTOM)) {
                Component bottomComponent = this.components.get(BOTTOM);
                int bottomComponentHeight = Math.min(bottomComponent.getPreferredSize().getRows(), availableVerticalSpace);
                finalLayout.add(new DefaultLaidOutComponent(bottomComponent, new TerminalSize(availableHorizontalSpace, bottomComponentHeight), new TerminalPosition(0, layoutArea.getRows() - bottomComponentHeight)));
                availableVerticalSpace -= bottomComponentHeight;
            }
            if (this.components.containsKey(LEFT)) {
                Component leftComponent = this.components.get(LEFT);
                leftComponentWidth = Math.min(leftComponent.getPreferredSize().getColumns(), availableHorizontalSpace);
                finalLayout.add(new DefaultLaidOutComponent(leftComponent, new TerminalSize(leftComponentWidth, availableVerticalSpace), new TerminalPosition(0, topComponentHeight)));
                availableHorizontalSpace -= leftComponentWidth;
            }
            if (this.components.containsKey(RIGHT)) {
                Component rightComponent = this.components.get(RIGHT);
                int rightComponentWidth = Math.min(rightComponent.getPreferredSize().getColumns(), availableHorizontalSpace);
                finalLayout.add(new DefaultLaidOutComponent(rightComponent, new TerminalSize(rightComponentWidth, availableVerticalSpace), new TerminalPosition(layoutArea.getColumns() - rightComponentWidth, topComponentHeight)));
                availableHorizontalSpace -= rightComponentWidth;
            }
            if (this.components.containsKey(CENTER)) {
                Component centerComponent = this.components.get(CENTER);
                finalLayout.add(new DefaultLaidOutComponent(centerComponent, new TerminalSize(availableHorizontalSpace, availableVerticalSpace), new TerminalPosition(leftComponentWidth, topComponentHeight)));
            }
        }
        return finalLayout;
    }

    @Override
    public boolean maximisesVertically() {
        return false;
    }

    @Override
    public boolean maximisesHorisontally() {
        return false;
    }
}

