/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui.dialog;

import com.googlecode.lanterna.gui.Action;
import com.googlecode.lanterna.gui.Border;
import com.googlecode.lanterna.gui.Component;
import com.googlecode.lanterna.gui.GUIScreen;
import com.googlecode.lanterna.gui.Window;
import com.googlecode.lanterna.gui.component.Button;
import com.googlecode.lanterna.gui.component.EmptySpace;
import com.googlecode.lanterna.gui.component.Label;
import com.googlecode.lanterna.gui.component.Panel;
import com.googlecode.lanterna.gui.component.PasswordBox;
import com.googlecode.lanterna.gui.component.TextBox;
import com.googlecode.lanterna.gui.layout.LayoutParameter;
import com.googlecode.lanterna.gui.layout.LinearLayout;

public class TextInputDialog
extends Window {
    private final TextBox textBox;
    private String result;

    private TextInputDialog(TextBoxFactory textBoxFactory, String title, String description, String initialText) {
        this(textBoxFactory, title, description, initialText, 0);
    }

    private TextInputDialog(TextBoxFactory textBoxFactory, String title, String description, String initialText, int textBoxWidth) {
        super(title);
        Label descriptionLabel = new Label(description);
        if (textBoxWidth == 0) {
            textBoxWidth = Math.max(descriptionLabel.getPreferredSize().getColumns(), title.length());
        }
        this.textBox = textBoxFactory.createTextBox(initialText, textBoxWidth);
        this.addComponent(descriptionLabel, new LayoutParameter[0]);
        this.addComponent(new EmptySpace(1, 1), new LayoutParameter[0]);
        this.addComponent(this.textBox, new LayoutParameter[0]);
        this.addComponent(new EmptySpace(1, 1), new LayoutParameter[0]);
        Panel okCancelPanel = new Panel(new Border.Invisible(), Panel.Orientation.HORISONTAL);
        Button okButton = new Button("OK", new Action(){

            @Override
            public void doAction() {
                TextInputDialog.this.result = TextInputDialog.this.textBox.getText();
                TextInputDialog.this.close();
            }
        });
        okButton.setAlignment(Component.Alignment.RIGHT_CENTER);
        okCancelPanel.addComponent(okButton, LinearLayout.GROWS_HORIZONTALLY);
        Button cancelButton = new Button("Cancel", new Action(){

            @Override
            public void doAction() {
                TextInputDialog.this.close();
            }
        });
        okCancelPanel.addComponent(cancelButton, new LayoutParameter[0]);
        this.addComponent(okCancelPanel, LinearLayout.GROWS_HORIZONTALLY);
    }

    public static String showTextInputBox(GUIScreen owner, String title, String description, String initialText) {
        return TextInputDialog.showTextInputBox(owner, title, description, initialText, 0);
    }

    public static String showTextInputBox(GUIScreen owner, String title, String description, String initialText, int textBoxWidth) {
        TextInputDialog textInputBox = new TextInputDialog(new NormalTextBoxFactory(), title, description, initialText, textBoxWidth);
        owner.showWindow(textInputBox, GUIScreen.Position.CENTER);
        return textInputBox.result;
    }

    public static String showPasswordInputBox(GUIScreen owner, String title, String description, String initialText) {
        return TextInputDialog.showPasswordInputBox(owner, title, description, initialText, 0);
    }

    public static String showPasswordInputBox(GUIScreen owner, String title, String description, String initialText, int textBoxWidth) {
        TextInputDialog textInputBox = new TextInputDialog(new PasswordTextBoxFactory(), title, description, initialText, textBoxWidth);
        owner.showWindow(textInputBox, GUIScreen.Position.CENTER);
        return textInputBox.result;
    }

    private static class PasswordTextBoxFactory
    implements TextBoxFactory {
        private PasswordTextBoxFactory() {
        }

        @Override
        public TextBox createTextBox(String initialContent, int width) {
            return new PasswordBox(initialContent, width);
        }
    }

    private static class NormalTextBoxFactory
    implements TextBoxFactory {
        private NormalTextBoxFactory() {
        }

        @Override
        public TextBox createTextBox(String initialContent, int width) {
            return new TextBox(initialContent, width);
        }
    }

    private static interface TextBoxFactory {
        public TextBox createTextBox(String var1, int var2);
    }
}

