/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui.dialog;

import com.googlecode.lanterna.gui.Action;
import com.googlecode.lanterna.gui.Border;
import com.googlecode.lanterna.gui.GUIScreen;
import com.googlecode.lanterna.gui.Window;
import com.googlecode.lanterna.gui.component.ActionListBox;
import com.googlecode.lanterna.gui.component.Button;
import com.googlecode.lanterna.gui.component.Label;
import com.googlecode.lanterna.gui.component.Panel;
import com.googlecode.lanterna.gui.layout.LayoutParameter;
import com.googlecode.lanterna.terminal.TerminalSize;

public class ActionListDialog
extends Window {
    private final ActionListBox actionListBox;
    private final boolean closeBeforeAction;

    private ActionListDialog(String title, String description, int actionListBoxWidth, boolean closeBeforeAction) {
        super(title);
        if (description != null) {
            this.addComponent(new Label(description), new LayoutParameter[0]);
        }
        this.closeBeforeAction = closeBeforeAction;
        this.actionListBox = new ActionListBox(new TerminalSize(actionListBoxWidth, 0));
        this.addComponent(this.actionListBox, new LayoutParameter[0]);
        Panel cancelPanel = new Panel(new Border.Invisible(), Panel.Orientation.HORISONTAL);
        cancelPanel.addComponent(new Label("                "), new LayoutParameter[0]);
        cancelPanel.addComponent(new Button("Close", new Action(){

            @Override
            public void doAction() {
                ActionListDialog.this.close();
            }
        }), new LayoutParameter[0]);
        this.addComponent(cancelPanel, new LayoutParameter[0]);
    }

    private void addAction(String title, final Action action) {
        this.actionListBox.addAction(title, new Action(){

            @Override
            public void doAction() {
                if (ActionListDialog.this.closeBeforeAction) {
                    ActionListDialog.this.close();
                }
                action.doAction();
                if (!ActionListDialog.this.closeBeforeAction) {
                    ActionListDialog.this.close();
                }
            }
        });
        this.actionListBox.setPreferredSize(new TerminalSize(this.actionListBox.getPreferredSize().getColumns(), this.actionListBox.getPreferredSize().getRows() + 1));
    }

    public static void showActionListDialog(GUIScreen owner, String title, String description, Action ... actions) {
        int maxLength = 0;
        for (Action action : actions) {
            if (action.toString().length() <= maxLength) continue;
            maxLength = action.toString().length();
        }
        ActionListDialog.showActionListDialog(owner, title, description, maxLength, actions);
    }

    public static void showActionListDialog(GUIScreen owner, String title, String description, int itemWidth, Action ... actions) {
        ActionListDialog.showActionListDialog(owner, title, description, itemWidth, false, actions);
    }

    public static void showActionListDialog(GUIScreen owner, String title, String description, int itemWidth, boolean closeBeforeAction, Action ... actions) {
        if (itemWidth == 0) {
            ActionListDialog.showActionListDialog(owner, title, description, actions);
            return;
        }
        ActionListDialog actionListDialog = new ActionListDialog(title, description, itemWidth, closeBeforeAction);
        for (Action action : actions) {
            actionListDialog.addAction(action.toString(), action);
        }
        owner.showWindow(actionListDialog, GUIScreen.Position.CENTER);
    }
}

