/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui.component;

import java.util.ArrayList;
import java.util.Iterator;

public class TextGrid {
    private StringBuilder dataBuffer;
    private DataGridCel[][] grid;
    private int numberOfCols;
    private int numberOfRows;
    private char NullDisplayChar = (char)32;

    public TextGrid() {
        this.dataBuffer = new StringBuilder("");
        this.numberOfCols = 0;
        this.numberOfRows = 0;
        this.grid = new DataGridCel[this.numberOfRows][this.numberOfCols];
    }

    public TextGrid(String data) {
        this.dataBuffer = new StringBuilder(this.lineFeedConvert(data, true));
        this.setGrid();
    }

    void appendChar(char character) {
        if (this.dataBuffer.toString().length() != 0) {
            this.dataBuffer.append(character);
        } else {
            this.dataBuffer = new StringBuilder(Character.toString(character));
        }
        this.setGrid();
    }

    protected DataGridCel getCel(int row, int col) {
        try {
            return this.grid[row][col];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public String getDataBuffer() {
        return this.lineFeedConvert(this.dataBuffer.toString(), false);
    }

    public String getDisplayLine(int row, int offset, int length) {
        StringBuilder sb = new StringBuilder();
        for (int c = offset; c < offset + length; ++c) {
            char tmp = row < this.numberOfRows && c < this.numberOfCols ? this.grid[row][c].getDisplayCharacter() : this.NullDisplayChar;
            sb.append(tmp);
        }
        return sb.toString();
    }

    public int getLineLength(int row) {
        int count;
        for (count = 0; count < this.grid[row].length && this.grid[row][count].getCharacter() != '\n' && this.grid[row][count].getCharacter() != '\u0001'; ++count) {
        }
        return count;
    }

    public int getNumRows() {
        return this.numberOfRows;
    }

    public void insertChar(int bufferIndex, char character) {
        this.dataBuffer.insert(bufferIndex, character);
        this.setGrid();
    }

    public String lineFeedConvert(String str, boolean input) {
        if (input) {
            return str.replaceAll(System.getProperty("line.separator"), Character.toString('\n'));
        }
        return str.replaceAll(Character.toString('\n'), System.getProperty("line.separator"));
    }

    public void removeChar(int bufferIndex) {
        this.dataBuffer.deleteCharAt(bufferIndex);
        this.setGrid();
    }

    public void setBufferData(String data) {
        this.dataBuffer = new StringBuilder(this.lineFeedConvert(data, true));
    }

    protected void setGrid() {
        int count = 0;
        this.updateDataSize();
        this.grid = new DataGridCel[this.numberOfRows][this.numberOfCols + 1];
        LineScanner scan = new LineScanner(this.dataBuffer.toString());
        for (int r = 0; r < this.numberOfRows; ++r) {
            String line = scan.hasNext() ? scan.nextLine() : new String();
            for (int c = 0; c < this.numberOfCols; ++c) {
                if (c < line.length()) {
                    this.grid[r][c] = new DataGridCel(line.charAt(c), count);
                    ++count;
                    continue;
                }
                this.grid[r][c] = r == this.numberOfRows - 1 && c > 0 && c == line.length() ? new DataGridCel(count) : new DataGridCel(-1);
            }
        }
    }

    public int size() {
        return this.dataBuffer.length();
    }

    private void updateDataSize() {
        int dataWidth = 0;
        int dataHeight = 0;
        String Line = null;
        LineScanner scan = new LineScanner(this.dataBuffer.toString());
        while (scan.hasNext()) {
            Line = scan.nextLine();
            if (Line.length() > dataWidth) {
                dataWidth = Line.length();
            }
            ++dataHeight;
        }
        this.numberOfCols = dataWidth + 1;
        this.numberOfRows = dataHeight;
    }

    private static class LineScanner
    implements Iterator<Object> {
        private ArrayList<String> data = new ArrayList();
        private int lineCount;
        private int current;

        LineScanner(String text) {
            String tmp = "";
            this.lineCount = 1;
            this.current = 0;
            for (int c = 0; c < text.length(); ++c) {
                tmp = tmp + Character.toString(text.charAt(c));
                if (text.charAt(c) != '\n') continue;
                this.data.add(tmp);
                tmp = "";
                ++this.lineCount;
            }
            if (!tmp.matches("")) {
                this.data.add(tmp);
            }
        }

        @Override
        public boolean hasNext() {
            return this.current < this.lineCount;
        }

        @Override
        public Object next() {
            ++this.current;
            if (this.data.size() < this.current) {
                return "";
            }
            return this.data.get(this.current - 1);
        }

        public String nextLine() {
            return (String)this.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public class DataGridCel {
        private char character;
        private char displayCharacter;
        private int bufferIndex;
        private static final char NullDisplayChar = ' ';
        private static final char LFDisplayChar = ' ';
        public static final char NullChar = '\u0001';

        public DataGridCel() {
            this.character = '\u0001';
            this.bufferIndex = -1;
            this.displayCharacter = (char)32;
        }

        public DataGridCel(char character, int bufferIndex) {
            this.character = character;
            this.bufferIndex = bufferIndex;
            switch (character) {
                case '\n': {
                    this.displayCharacter = (char)32;
                    break;
                }
                case '\u0001': {
                    this.displayCharacter = (char)32;
                    break;
                }
                default: {
                    this.displayCharacter = character;
                }
            }
        }

        public DataGridCel(int bufferIndex) {
            this.character = '\u0001';
            this.bufferIndex = bufferIndex;
            this.displayCharacter = (char)32;
        }

        public int getBufferIndex() {
            return this.bufferIndex;
        }

        public char getCharacter() {
            return this.character;
        }

        public char getDisplayCharacter() {
            return this.displayCharacter;
        }
    }
}

