/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui.component;

import com.googlecode.lanterna.gui.Border;
import com.googlecode.lanterna.gui.Component;
import com.googlecode.lanterna.gui.TextGraphics;
import com.googlecode.lanterna.gui.component.AbstractContainer;
import com.googlecode.lanterna.gui.layout.HorisontalLayout;
import com.googlecode.lanterna.gui.layout.LayoutManager;
import com.googlecode.lanterna.gui.layout.LayoutParameter;
import com.googlecode.lanterna.gui.layout.LinearLayout;
import com.googlecode.lanterna.gui.layout.VerticalLayout;
import com.googlecode.lanterna.terminal.TerminalPosition;
import com.googlecode.lanterna.terminal.TerminalSize;
import java.util.List;

public class Panel
extends AbstractContainer {
    private Border border;
    private LayoutManager layoutManager;
    private String title;

    public Panel() {
        this(Orientation.VERTICAL);
    }

    public Panel(String title) {
        this(title, Orientation.VERTICAL);
    }

    public Panel(Orientation panelOrientation) {
        this(new Border.Invisible(), panelOrientation);
    }

    public Panel(String title, Orientation panelOrientation) {
        this(title, new Border.Bevel(true), panelOrientation);
    }

    public Panel(Border border, Orientation panelOrientation) {
        this("", border, panelOrientation);
    }

    public Panel(String title, Border border, Orientation panelOrientation) {
        this.border = border;
        this.layoutManager = panelOrientation == Orientation.HORISONTAL ? new HorisontalLayout() : new VerticalLayout();
        this.title = title != null ? title : "";
    }

    public Border getBorder() {
        return this.border;
    }

    public void setBorder(Border border) {
        if (border != null) {
            this.border = border;
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title != null ? title : "";
    }

    public void setLayoutManager(LayoutManager layoutManager) {
        this.layoutManager = layoutManager;
    }

    public LayoutManager getLayoutManager() {
        return this.layoutManager;
    }

    public boolean maximisesVertically() {
        return this.layoutManager.maximisesVertically();
    }

    public boolean maximisesHorisontally() {
        return this.layoutManager.maximisesHorisontally();
    }

    @Deprecated
    public void setBetweenComponentsPadding(int paddingSize) {
        if (paddingSize < 0) {
            paddingSize = 0;
        }
        if (this.layoutManager instanceof LinearLayout) {
            ((LinearLayout)this.layoutManager).setPadding(paddingSize);
        }
    }

    @Override
    public void repaint(TextGraphics graphics) {
        this.border.drawBorder(graphics, new TerminalSize(graphics.getWidth(), graphics.getHeight()), this.title);
        TerminalPosition contentPaneTopLeft = this.border.getInnerAreaLocation(graphics.getWidth(), graphics.getHeight());
        TerminalSize contentPaneSize = this.border.getInnerAreaSize(graphics.getWidth(), graphics.getHeight());
        TextGraphics subGraphics = graphics.subAreaGraphics(contentPaneTopLeft, contentPaneSize);
        List<? extends LayoutManager.LaidOutComponent> laidOutComponents = this.layoutManager.layout(contentPaneSize);
        for (LayoutManager.LaidOutComponent laidOutComponent : laidOutComponents) {
            TextGraphics subSubGraphics = subGraphics.subAreaGraphics(laidOutComponent.getTopLeftPosition(), laidOutComponent.getSize());
            if (!laidOutComponent.getComponent().isVisible()) continue;
            laidOutComponent.getComponent().repaint(subSubGraphics);
        }
    }

    @Override
    protected TerminalSize calculatePreferredSize() {
        TerminalSize preferredSize = this.border.surroundAreaSize(this.layoutManager.getPreferredSize());
        if (this.title.length() + 4 > preferredSize.getColumns()) {
            preferredSize.setColumns(this.title.length() + 4);
        }
        return preferredSize;
    }

    @Override
    public void addComponent(Component component, LayoutParameter ... layoutParameters) {
        super.addComponent(component, new LayoutParameter[0]);
        this.layoutManager.addComponent(component, layoutParameters);
    }

    @Override
    public boolean removeComponent(Component component) {
        if (super.removeComponent(component)) {
            this.layoutManager.removeComponent(component);
            return true;
        }
        return false;
    }

    public String toString() {
        return "Panel with " + this.getComponentCount() + " components";
    }

    public static enum Orientation {
        HORISONTAL,
        VERTICAL;

    }
}

