/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui.component;

import com.googlecode.lanterna.gui.Border;
import com.googlecode.lanterna.gui.Component;
import com.googlecode.lanterna.gui.Container;
import com.googlecode.lanterna.gui.GUIScreen;
import com.googlecode.lanterna.gui.TextGraphics;
import com.googlecode.lanterna.gui.Window;
import com.googlecode.lanterna.gui.component.AbstractContainer;
import com.googlecode.lanterna.gui.component.Panel;
import com.googlecode.lanterna.gui.layout.LinearLayout;
import com.googlecode.lanterna.gui.listener.ComponentListener;
import com.googlecode.lanterna.terminal.TerminalPosition;
import com.googlecode.lanterna.terminal.TerminalSize;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractComponent
implements Component {
    private final List<ComponentListener> componentListeners = new LinkedList<ComponentListener>();
    private Container parent = null;
    private TerminalSize preferredSizeOverride = null;
    private boolean visible = true;
    private Component.Alignment alignment = Component.Alignment.CENTER;

    @Override
    public Container getParent() {
        return this.parent;
    }

    protected void setParent(Container parent) {
        this.parent = parent;
    }

    @Override
    public void addComponentListener(ComponentListener cl) {
        if (cl != null) {
            this.componentListeners.add(cl);
        }
    }

    @Override
    public void removeComponentListener(ComponentListener cl) {
        this.componentListeners.remove(cl);
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public boolean isScrollable() {
        return false;
    }

    @Override
    public void setPreferredSize(TerminalSize preferredSizeOverride) {
        this.preferredSizeOverride = preferredSizeOverride;
        this.invalidate();
    }

    @Override
    public TerminalSize getPreferredSize() {
        if (this.preferredSizeOverride != null) {
            return this.preferredSizeOverride;
        }
        return this.calculatePreferredSize();
    }

    protected abstract TerminalSize calculatePreferredSize();

    @Override
    public TerminalSize getMinimumSize() {
        return new TerminalSize(1, 1);
    }

    @Override
    public Component.Alignment getAlignment() {
        return this.alignment;
    }

    @Override
    public void setAlignment(Component.Alignment alignment) {
        if (alignment == null) {
            throw new IllegalArgumentException("Alignment argument to AbstractComponent.setAlignment(...) cannot be null");
        }
        this.alignment = alignment;
    }

    protected void invalidate() {
        for (ComponentListener cl : this.componentListeners) {
            cl.onComponentInvalidated(this);
        }
        if (this.parent != null && this.parent instanceof AbstractContainer) {
            ((AbstractContainer)this.parent).invalidate();
        }
    }

    protected List<ComponentListener> getComponentListeners() {
        return Collections.unmodifiableList(this.componentListeners);
    }

    @Override
    public Window getWindow() {
        Container container = this.getParent();
        if (container != null) {
            return container.getWindow();
        }
        return null;
    }

    protected GUIScreen getGUIScreen() {
        Window window = this.getWindow();
        if (window == null) {
            return null;
        }
        return window.getOwner();
    }

    @Override
    public Component addBorder(Border border, String title) {
        Panel panel = new Panel(title, border, Panel.Orientation.VERTICAL);
        panel.addComponent(this, LinearLayout.GROWS_HORIZONTALLY, LinearLayout.GROWS_VERTICALLY);
        return panel;
    }

    protected TextGraphics transformAccordingToAlignment(TextGraphics graphics, TerminalSize preferredSize) {
        if (graphics.getWidth() <= preferredSize.getColumns() && graphics.getHeight() <= preferredSize.getRows()) {
            return graphics;
        }
        if (this.alignment == Component.Alignment.FILL) {
            return graphics;
        }
        int leftPosition = 0;
        if (this.alignment == Component.Alignment.TOP_CENTER || this.alignment == Component.Alignment.CENTER || this.alignment == Component.Alignment.BOTTON_CENTER) {
            leftPosition = (graphics.getWidth() - preferredSize.getColumns()) / 2;
        } else if (this.alignment == Component.Alignment.TOP_RIGHT || this.alignment == Component.Alignment.RIGHT_CENTER || this.alignment == Component.Alignment.BOTTOM_RIGHT) {
            leftPosition = graphics.getWidth() - preferredSize.getColumns();
        }
        int topPosition = 0;
        if (this.alignment == Component.Alignment.LEFT_CENTER || this.alignment == Component.Alignment.CENTER || this.alignment == Component.Alignment.RIGHT_CENTER) {
            topPosition = (graphics.getHeight() - preferredSize.getRows()) / 2;
        } else if (this.alignment == Component.Alignment.BOTTOM_LEFT || this.alignment == Component.Alignment.BOTTON_CENTER || this.alignment == Component.Alignment.BOTTOM_RIGHT) {
            topPosition = graphics.getHeight() - preferredSize.getRows();
        }
        return graphics.subAreaGraphics(new TerminalPosition(leftPosition, topPosition), preferredSize);
    }
}

