/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.transport.jms.activemq.internal;

import de.rcenvironment.core.communication.common.CommunicationException;
import de.rcenvironment.core.communication.configuration.ConnectionFilter;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.activemq.broker.BrokerPluginSupport;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActiveMQConnectionFilterPlugin
extends BrokerPluginSupport {
    private static final Pattern VM_CONNECTION_PATTERN = Pattern.compile("vm://.+#\\d+");
    private static final Pattern TCP_CONNECTION_PATTERN = Pattern.compile("tcp://(\\d{1,3}.\\d{1,3}.\\d{1,3}.\\d{1,3}):\\d{1,5}");
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private volatile ConnectionFilter filter = null;

    public void addConnection(ConnectionContext context, ConnectionInfo info) throws Exception {
        String clientUrl = info.getClientIp();
        if (VM_CONNECTION_PATTERN.matcher(clientUrl).matches()) {
            this.log.debug((Object)("Accepting in-JVM JMS broker connection " + clientUrl));
        } else {
            Matcher m = TCP_CONNECTION_PATTERN.matcher(clientUrl);
            if (!m.matches()) {
                throw new CommunicationException("Connection refused: Malformed client URL (not a numeric IPv4 address): " + clientUrl);
            }
            String ipPart = m.group(1);
            try {
                boolean accepted = this.filter.isIpAllowedToConnect(ipPart);
                if (!accepted) {
                    this.log.error((Object)("Refusing TCP JMS connection from " + ipPart));
                    throw new CommunicationException("Connection from " + ipPart + " refused by IP filter");
                }
                this.log.debug((Object)("Accepting TCP JMS connection from " + ipPart));
            }
            catch (RuntimeException e) {
                throw new IllegalStateException("Error while checking filter for incoming IP " + ipPart, e);
            }
        }
        super.addConnection(context, info);
    }

    public Set getDestinations(ActiveMQDestination destination) {
        return super.getDestinations(destination);
    }

    public void setFilter(ConnectionFilter filter) {
        this.filter = filter;
    }
}

