/*
 * Decompiled with CFR 0.152.
 */
package de.vonloesch.pdf4eclipse.model.jpedal;

import de.vonloesch.pdf4eclipse.Activator;
import de.vonloesch.pdf4eclipse.model.IPDFLinkAnnotation;
import de.vonloesch.pdf4eclipse.model.IPDFPage;
import de.vonloesch.pdf4eclipse.model.jpedal.JPedalPDFLinkAnnotation;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import org.jpedal.PdfDecoder;
import org.jpedal.exception.PdfException;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfArrayIterator;

public class JPedalPDFPage
implements IPDFPage {
    PdfDecoder decoder;
    int pageNr;
    int width;
    int height;
    int cropx;
    int cropy;
    int imgWidth;
    int imgHeight;
    IPDFLinkAnnotation[] annotations;

    public JPedalPDFPage(PdfDecoder decoder, int pageNr) {
        this.decoder = decoder;
        this.pageNr = pageNr;
        PdfPageData data = decoder.getPdfPageData();
        this.cropx = data.getCropBoxX(pageNr);
        this.cropy = data.getCropBoxY(pageNr);
        this.width = data.getCropBoxWidth(pageNr);
        this.height = data.getCropBoxHeight(pageNr);
    }

    @Override
    public BufferedImage getImage(int height, int width) {
        try {
            double ratio = this.getHeight() / this.getWidth();
            double askratio = (double)height / (double)width;
            if (askratio > ratio) {
                height = (int)((double)width * ratio + 0.5);
            } else {
                width = (int)((double)height / ratio + 0.5);
            }
            this.decoder.scaling = (float)height / this.getHeight();
            BufferedImage img = this.decoder.getPageAsImage(this.pageNr);
            this.imgWidth = img.getWidth();
            this.imgHeight = img.getHeight();
            return img;
        }
        catch (PdfException e) {
            Activator.log("Error while decoding page", e);
            return null;
        }
    }

    @Override
    public int getPageNumber() {
        return this.pageNr;
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    @Override
    public Rectangle2D image2PdfCoordinates(Rectangle2D r) {
        if (this.imgWidth == 0 || this.imgHeight == 0) {
            return null;
        }
        Rectangle tr = new Rectangle();
        tr.setFrame(r.getX() * (double)this.getWidth() / (double)this.imgWidth + (double)this.cropx, (double)(this.getHeight() + (float)this.cropy) - r.getY() * (double)this.getHeight() / (double)this.imgHeight, r.getWidth() * (double)this.getWidth() / (double)this.imgWidth, r.getHeight() * (double)this.getHeight() / (double)this.imgHeight);
        return tr;
    }

    @Override
    public Rectangle2D pdf2ImageCoordinates(Rectangle2D r) {
        Rectangle tr = new Rectangle();
        tr.setFrame((r.getX() - (double)this.cropx) * (double)this.imgWidth / (double)this.getWidth(), ((double)this.height - r.getY() - r.getHeight() + (double)this.cropy) * (double)this.imgHeight / (double)this.getHeight(), r.getWidth() * (double)this.imgWidth / (double)this.getWidth(), r.getHeight() * (double)this.imgHeight / (double)this.getHeight());
        return tr;
    }

    @Override
    public IPDFLinkAnnotation[] getAnnotations() {
        if (this.annotations != null) {
            return this.annotations;
        }
        LinkedList<JPedalPDFLinkAnnotation> annotationsList = new LinkedList<JPedalPDFLinkAnnotation>();
        PdfArrayIterator annotListForPage = this.decoder.getFormRenderer().getAnnotsOnPage(this.pageNr);
        if (annotListForPage != null && annotListForPage.getTokenCount() > 0) {
            while (annotListForPage.hasMoreTokens()) {
                String annotKey = annotListForPage.getNextValueAsString(true);
                Object[] rawObj = this.decoder.getFormRenderer().getCompData().getRawForm(annotKey);
                int i = 0;
                while (i < rawObj.length) {
                    FormObject annotObj;
                    int subtype;
                    if (rawObj[i] != null && (subtype = (annotObj = (FormObject)rawObj[i]).getParameterConstant(1147962727)) == 473513531) {
                        annotationsList.add(new JPedalPDFLinkAnnotation(annotObj, this.decoder));
                    }
                    ++i;
                }
            }
        }
        this.annotations = annotationsList.toArray(new JPedalPDFLinkAnnotation[0]);
        return this.annotations;
    }
}

