/*
 * Decompiled with CFR 0.152.
 */
package de.vonloesch.pdf4eclipse;

import de.vonloesch.pdf4eclipse.Messages;
import de.vonloesch.pdf4eclipse.editors.PDFEditor;
import de.vonloesch.pdf4eclipse.model.IPDFLinkAnnotation;
import de.vonloesch.pdf4eclipse.model.IPDFPage;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class PDFPageViewer
extends Canvas
implements PaintListener,
IEclipsePreferences.IPreferenceChangeListener {
    private Image currentImage;
    public IPDFPage currentPage;
    AffineTransform currentXform;
    int offx;
    int offy;
    private boolean highlightLinks;
    private Rectangle2D highlight;
    private Display display;
    private float zoomFactor;

    public PDFPageViewer(Composite parent, final PDFEditor editor) {
        super(parent, 0x240000);
        this.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                IPDFLinkAnnotation[] annos;
                if (e.button != 1) {
                    return;
                }
                IPDFLinkAnnotation[] iPDFLinkAnnotationArray = annos = PDFPageViewer.this.getPage().getAnnotations();
                int n = annos.length;
                int n2 = 0;
                while (n2 < n) {
                    final IPDFLinkAnnotation a = iPDFLinkAnnotationArray[n2];
                    Rectangle2D r = PDFPageViewer.this.convertPDF2ImageCoord(a.getPosition());
                    if (r.contains(e.x, e.y) && a.getDestination() != null) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                editor.gotoAction(a.getDestination());
                            }
                        });
                        return;
                    }
                    ++n2;
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
                if (e.button != 1) {
                    return;
                }
                final Rectangle2D r = PDFPageViewer.this.convertImage2PDFCoord(new Rectangle(e.x, e.y, 1, 1));
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        editor.reverseSearch(r.getX(), (double)(this).PDFPageViewer.this.currentPage.getHeight() - r.getY());
                    }
                });
            }
        });
        this.display = parent.getDisplay();
        this.setSize(800, 600);
        this.zoomFactor = 1.0f;
        this.addPaintListener(this);
        IEclipsePreferences prefs = new InstanceScope().getNode("de.vonloesch.pdf4Eclipse");
        prefs.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        this.highlightLinks = prefs.getBoolean("de.vonloesch.pdf4eclipse.preferences.linkHighlight", true);
    }

    public static ImageData convertToSWT(BufferedImage bufferedImage) {
        if (bufferedImage.getType() == 6) {
            byte[] datas = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), 32, new PaletteData(255, 65280, 0xFF0000));
            data.data = datas;
            return data;
        }
        if (bufferedImage.getColorModel() instanceof DirectColorModel) {
            DirectColorModel colorModel = (DirectColorModel)bufferedImage.getColorModel();
            PaletteData palette = new PaletteData(colorModel.getRedMask(), colorModel.getGreenMask(), colorModel.getBlueMask());
            ImageData data = null;
            if (bufferedImage.getType() == 2) {
                data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
                int[] rbgs = new int[data.width];
                int y = 0;
                while (y < data.height) {
                    bufferedImage.getRGB(0, y, data.width, 1, rbgs, 0, data.width);
                    data.setPixels(0, y, data.width, rbgs, 0);
                    ++y;
                }
            } else if (bufferedImage.getType() == 1) {
                data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
                WritableRaster raster = bufferedImage.getRaster();
                int[] pixelArray = new int[3];
                int y = 0;
                while (y < data.height) {
                    int x = 0;
                    while (x < data.width) {
                        raster.getPixel(x, y, pixelArray);
                        int pixel = palette.getPixel(new RGB(pixelArray[0], pixelArray[1], pixelArray[2]));
                        data.setPixel(x, y, pixel);
                        ++x;
                    }
                    ++y;
                }
            }
            return data;
        }
        if (bufferedImage.getColorModel() instanceof IndexColorModel) {
            IndexColorModel colorModel = (IndexColorModel)bufferedImage.getColorModel();
            int size = colorModel.getMapSize();
            byte[] reds = new byte[size];
            byte[] greens = new byte[size];
            byte[] blues = new byte[size];
            colorModel.getReds(reds);
            colorModel.getGreens(greens);
            colorModel.getBlues(blues);
            RGB[] rgbs = new RGB[size];
            int i = 0;
            while (i < rgbs.length) {
                rgbs[i] = new RGB(reds[i] & 0xFF, greens[i] & 0xFF, blues[i] & 0xFF);
                ++i;
            }
            PaletteData palette = new PaletteData(rgbs);
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
            data.transparentPixel = colorModel.getTransparentPixel();
            WritableRaster raster = bufferedImage.getRaster();
            int[] pixelArray = new int[1];
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    raster.getPixel(x, y, pixelArray);
                    data.setPixel(x, y, pixelArray[0]);
                    ++x;
                }
                ++y;
            }
            return data;
        }
        return null;
    }

    public void highlight(double x, double y, double x2, double y2) {
        Rectangle2D.Double r = new Rectangle2D.Double(x, (double)this.currentPage.getHeight() - y2, x2 - x, y2 - y);
        this.highlight = this.convertPDF2ImageCoord(r);
    }

    public void showPage(IPDFPage page) {
        this.currentPage = page;
        this.highlight = null;
        boolean resize = false;
        int newW = Math.round(this.zoomFactor * page.getWidth());
        int newH = Math.round(this.zoomFactor * page.getHeight());
        Point sz = this.getSize();
        if (sz.x == 0 || sz.y == 0) {
            return;
        }
        this.currentImage = page.getImage(newH, newW);
        newW = this.currentImage.getWidth(null);
        newH = this.currentImage.getHeight(null);
        if (sz.x != newW || sz.y != newH) {
            sz.x = newW;
            sz.y = newH;
            resize = true;
        }
        if (resize) {
            this.setSize(this.currentImage.getWidth(null), this.currentImage.getHeight(null));
            this.redraw();
        }
    }

    private org.eclipse.swt.graphics.Rectangle getRectangle(Rectangle2D r) {
        return new org.eclipse.swt.graphics.Rectangle((int)Math.round(r.getX()), (int)Math.round(r.getY()), (int)Math.round(r.getWidth()), (int)Math.round(r.getHeight()));
    }

    public Rectangle2D convertPDF2ImageCoord(Rectangle2D r) {
        return this.currentPage.pdf2ImageCoordinates(r);
    }

    public Rectangle2D convertImage2PDFCoord(Rectangle2D r) {
        return this.currentPage.image2PdfCoordinates(r);
    }

    public void setZoomFactor(float factor) {
        assert (factor > 0.0f);
        this.zoomFactor = factor;
        this.showPage(this.currentPage);
    }

    public float getZoomFactor() {
        return this.zoomFactor;
    }

    public void paintControl(PaintEvent event) {
        GC g = event.gc;
        Point sz = this.getSize();
        if (this.currentImage == null) {
            g.setForeground(this.getBackground());
            g.fillRectangle(0, 0, sz.x, sz.y);
            g.setForeground(this.display.getSystemColor(2));
            g.drawString(Messages.PDFPageViewer_1, sz.x / 2 - 30, sz.y / 2);
        } else {
            int imwid = this.currentImage.getWidth(null);
            int imhgt = this.currentImage.getHeight(null);
            this.offx = (sz.x - imwid) / 2;
            this.offy = (sz.y - imhgt) / 2;
            if (imwid == sz.x && imhgt <= sz.y || imhgt == sz.y && imwid <= sz.x) {
                BufferedImage temp = new BufferedImage(event.width, event.height, 6);
                ((Image)temp).getGraphics().drawImage(this.currentImage, 0, 0, event.width, event.height, event.x, event.y, event.x + event.width, event.y + event.height, null);
                org.eclipse.swt.graphics.Image swtImage = new org.eclipse.swt.graphics.Image((Device)this.display, PDFPageViewer.convertToSWT(temp));
                g.drawImage(swtImage, event.x, event.y);
                swtImage.dispose();
                if (this.highlightLinks) {
                    IPDFLinkAnnotation[] anno = this.currentPage.getAnnotations();
                    g.setForeground(this.display.getSystemColor(3));
                    IPDFLinkAnnotation[] iPDFLinkAnnotationArray = anno;
                    int n = anno.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPDFLinkAnnotation a = iPDFLinkAnnotationArray[n2];
                        org.eclipse.swt.graphics.Rectangle r = this.getRectangle(this.convertPDF2ImageCoord(a.getPosition()));
                        g.drawRectangle(r);
                        ++n2;
                    }
                }
                if (this.highlight != null) {
                    g.setForeground(this.display.getSystemColor(9));
                    g.drawRectangle(this.getRectangle(this.highlight));
                }
            } else {
                if (this.currentPage != null) {
                    this.showPage(this.currentPage);
                }
                g.setForeground(this.getBackground());
                g.fillRectangle(0, 0, sz.x, sz.y);
                g.setForeground(this.display.getSystemColor(3));
                g.drawLine(0, 0, sz.x, sz.y);
                g.drawLine(0, sz.y, sz.x, 0);
            }
        }
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if ("de.vonloesch.pdf4eclipse.preferences.linkHighlight".equals(event.getKey())) {
            this.highlightLinks = Boolean.parseBoolean((String)event.getNewValue());
            this.redraw();
        }
    }

    public IPDFPage getPage() {
        return this.currentPage;
    }

    public void dispose() {
        super.dispose();
        this.currentImage.flush();
        this.currentImage = null;
        IEclipsePreferences prefs = new InstanceScope().getNode("de.vonloesch.pdf4Eclipse");
        prefs.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
    }
}

