/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.database.gui;

import de.rcenvironment.components.database.common.DatabaseComponentHistoryDataItem;
import de.rcenvironment.components.database.common.DatabaseStatementHistoryData;
import de.rcenvironment.core.component.api.ComponentUtils;
import de.rcenvironment.core.component.datamanagement.api.DefaultComponentHistoryDataItem;
import de.rcenvironment.core.datamodel.api.TypedDatumSerializer;
import de.rcenvironment.core.datamodel.api.TypedDatumService;
import de.rcenvironment.core.gui.datamanagement.browser.spi.CommonHistoryDataItemSubtreeBuilderUtils;
import de.rcenvironment.core.gui.datamanagement.browser.spi.DMBrowserNode;
import de.rcenvironment.core.gui.datamanagement.browser.spi.DMBrowserNodeType;
import de.rcenvironment.core.gui.datamanagement.browser.spi.DefaultHistoryDataItemSubtreeBuilder;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class DatabaseHistoryDataItemSubtreeBuilder
extends DefaultHistoryDataItemSubtreeBuilder {
    private static final Image COMPONENT_ICON;

    static {
        String bundleName = "de.rcenvironment.components.database.common";
        String iconName = "database16.png";
        URL url = ComponentUtils.readIconURL((String)bundleName, (String)iconName);
        COMPONENT_ICON = url != null ? ImageDescriptor.createFromURL((URL)url).createImage() : null;
    }

    public String[] getSupportedHistoryDataItemIdentifier() {
        return new String[]{"de.rcenvironment.database"};
    }

    public Image getComponentIcon(String historyDataItemIdentifier) {
        return COMPONENT_ICON;
    }

    public void buildInitialHistoryDataItemSubtree(Serializable historyDataItem, DMBrowserNode parentNode) {
        ServiceRegistryAccess registryAccess = ServiceRegistry.createAccessFor((Object)((Object)this));
        TypedDatumSerializer serializer = ((TypedDatumService)registryAccess.getService(TypedDatumService.class)).getSerializer();
        if (historyDataItem instanceof String) {
            DatabaseComponentHistoryDataItem historyData;
            try {
                historyData = DatabaseComponentHistoryDataItem.fromString((String)((String)((Object)historyDataItem)), (TypedDatumSerializer)serializer, (String)"de.rcenvironment.database");
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
            CommonHistoryDataItemSubtreeBuilderUtils.buildDefaultHistoryDataItemSubtrees((DefaultComponentHistoryDataItem)historyData, (DMBrowserNode)parentNode);
            List databaseStatementHistoryData = historyData.getDatabaseStatementHistoryDataList();
            if (databaseStatementHistoryData.size() > 0) {
                DMBrowserNode statementsFolderNode = DMBrowserNode.addNewChildNode((String)"SQL Statements", (DMBrowserNodeType)DMBrowserNodeType.SqlFolder, (DMBrowserNode)parentNode);
                for (DatabaseStatementHistoryData statement : databaseStatementHistoryData) {
                    DMBrowserNode statementsFolderWithName = DMBrowserNode.addNewChildNode((String)statement.getStatementName(), (DMBrowserNodeType)DMBrowserNodeType.LogFolder, (DMBrowserNode)statementsFolderNode);
                    DMBrowserNode statementPatternNode = DMBrowserNode.addNewLeafNode((String)("Statement pattern: " + StringUtils.abbreviate((String)statement.getStatementPattern(), (int)30)), (DMBrowserNodeType)DMBrowserNodeType.CommonText, (DMBrowserNode)statementsFolderWithName);
                    statementPatternNode.setFileContentAndName(statement.getStatementPattern(), "Statement pattern");
                    DMBrowserNode statementEffectiveNode = DMBrowserNode.addNewLeafNode((String)("Effective statement: " + StringUtils.abbreviate((String)statement.getStatementEffective(), (int)30)), (DMBrowserNodeType)DMBrowserNodeType.CommonText, (DMBrowserNode)statementsFolderWithName);
                    statementEffectiveNode.setFileContentAndName(statement.getStatementEffective(), "Effective statement");
                }
            } else {
                DMBrowserNode.addNewLeafNode((String)"No statements found.", (DMBrowserNodeType)DMBrowserNodeType.SqlFolder, (DMBrowserNode)parentNode);
            }
        }
    }
}

