/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.script.gui;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;

public final class ScriptHandler {
    private static final int BUF_SIZE = 8192;

    private ScriptHandler() {
    }

    public static String decodeString(byte[] data, String encoding) {
        return Charset.forName(encoding).decode(ByteBuffer.wrap(data)).toString();
    }

    public static String loadSciptAsString(IFile file, String encoding) throws CoreException, IOException {
        byte[] bytes = ScriptHandler.loadScriptAsBytes(file.getContents());
        return ScriptHandler.decodeString(bytes, encoding);
    }

    public static byte[] loadScriptAsBytes(InputStream is) throws CoreException, IOException {
        int num;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        while ((num = is.read(buffer)) > 0) {
            baos.write(buffer, 0, num);
        }
        is.close();
        baos.close();
        return baos.toByteArray();
    }

    public static byte[] encodeString(String string, String encoding) {
        ByteBuffer bb = Charset.forName(encoding).encode(string);
        byte[] buffer = bb.array();
        return Arrays.copyOfRange(buffer, 0, bb.limit());
    }
}

