/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.uplink.client.execution.api;

import de.rcenvironment.core.communication.uplink.client.execution.api.DirectoryUploadContext;
import de.rcenvironment.core.communication.uplink.client.execution.api.FileDataSource;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.DebugSettings;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DataTransferUtils {
    private static final String SLASH = "/";
    private static final boolean VERBOSE_FILE_TRANSFER_LOGGING_ENABLED = DebugSettings.getVerboseLoggingEnabled((String)"uplink.filetransfers");
    private static final long MAXIMUM_EXPECTED_FILE_SIZE = 0xFFFFFFFFL;

    private DataTransferUtils() {
    }

    public static void uploadDirectory(File directory, DirectoryUploadContext uploadContext, String remotePath, String logPrefix) throws IOException {
        File[] files = directory.listFiles();
        if (files == null) {
            DataTransferUtils.staticLogger().warn((Object)(String.valueOf(logPrefix) + "Attempted to upload " + directory + ", but it does not seem to be a directory"));
            return;
        }
        if (VERBOSE_FILE_TRANSFER_LOGGING_ENABLED) {
            DataTransferUtils.staticLogger().debug((Object)StringUtils.format((String)"%sUploading %d file(s) found in '%s'", (Object[])new Object[]{logPrefix, files.length, directory.toString()}));
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                if (VERBOSE_FILE_TRANSFER_LOGGING_ENABLED) {
                    DataTransferUtils.staticLogger().debug((Object)StringUtils.format((String)"%sRecursing into directory '%s'", (Object[])new Object[]{logPrefix, file.toString()}));
                }
                DataTransferUtils.uploadDirectory(file, uploadContext, String.valueOf(remotePath) + SLASH + file.getName(), logPrefix);
            } else {
                Path path = file.toPath();
                long fileSize = Files.size(path);
                if (fileSize < 0L) {
                    throw new IOException("Error determining file size of " + path.toString() + ", received " + fileSize);
                }
                if (fileSize > 0xFFFFFFFFL) {
                    DataTransferUtils.staticLogger().warn((Object)("Excessive upload file size for " + path.toString() + ": " + fileSize));
                }
                if (VERBOSE_FILE_TRANSFER_LOGGING_ENABLED) {
                    DataTransferUtils.staticLogger().debug((Object)StringUtils.format((String)"%sUploading local file '%s' of %d bytes", (Object[])new Object[]{logPrefix, file.toString(), fileSize}));
                }
                Throwable throwable = null;
                Object var13_13 = null;
                try (BufferedInputStream bufferedFileStream = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
                    uploadContext.provideFile(new FileDataSource(String.valueOf(remotePath) + SLASH + file.getName(), fileSize, bufferedFileStream));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                if (VERBOSE_FILE_TRANSFER_LOGGING_ENABLED) {
                    DataTransferUtils.staticLogger().debug((Object)StringUtils.format((String)"%sFinished uploading local file '%s'", (Object[])new Object[]{logPrefix, file.toString()}));
                }
            }
            ++n2;
        }
    }

    public static void getDirectoryListing(File directory, List<String> listOfDirs, String remotePath) throws IOException {
        File[] files = directory.listFiles();
        if (files == null) {
            DataTransferUtils.staticLogger().warn((Object)("Attempted to upload " + directory + ", but it does not seem to be a directory"));
            return;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                listOfDirs.add(String.valueOf(remotePath) + SLASH + file.getName());
                DataTransferUtils.getDirectoryListing(file, listOfDirs, String.valueOf(remotePath) + SLASH + file.getName());
            }
            ++n2;
        }
    }

    public static void receiveFile(FileDataSource dataSource, File rootDirectory) throws IOException {
        String relativePath = dataSource.getRelativePath();
        if (relativePath == null) {
            throw new IOException("Relative path is null");
        }
        File fileToWrite = new File(rootDirectory, relativePath);
        if (fileToWrite.getCanonicalPath().startsWith(rootDirectory.getCanonicalPath())) {
            fileToWrite.getParentFile().mkdirs();
            try (FileOutputStream fileStream = new FileOutputStream(fileToWrite);){
                IOUtils.copy((InputStream)dataSource.getStream(), (OutputStream)fileStream);
            }
            if (!dataSource.receivedCompletely()) {
                throw new IOException("Received incomplete file transfer for relative path " + relativePath);
            }
        } else {
            throw new IOException("Relative path " + relativePath + " points to a destination output the root directory.");
        }
        dataSource.getStream().close();
    }

    public static void receiveDirectoryListing(List<String> dirList, File rootDirectory) throws IOException {
        for (String relativePath : dirList) {
            if (relativePath == null) {
                throw new IOException("Relative path is null");
            }
            File dirToCreate = new File(rootDirectory, relativePath);
            if (dirToCreate.getCanonicalPath().startsWith(rootDirectory.getCanonicalPath())) {
                dirToCreate.mkdir();
                continue;
            }
            throw new IOException("Relative path " + relativePath + " points to a destination output the root directory.");
        }
    }

    private static Log staticLogger() {
        return LogFactory.getLog(DataTransferUtils.class);
    }
}

