/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.mail.internal;

import de.rcenvironment.core.command.common.CommandException;
import de.rcenvironment.core.command.spi.AbstractCommandParameter;
import de.rcenvironment.core.command.spi.CommandContext;
import de.rcenvironment.core.command.spi.CommandModifierInfo;
import de.rcenvironment.core.command.spi.CommandPlugin;
import de.rcenvironment.core.command.spi.MainCommandDescription;
import de.rcenvironment.core.command.spi.ParsedCommandModifiers;
import de.rcenvironment.core.command.spi.ParsedStringParameter;
import de.rcenvironment.core.command.spi.StringParameter;
import de.rcenvironment.core.command.spi.SubCommandDescription;
import de.rcenvironment.core.mail.InvalidMailException;
import de.rcenvironment.core.mail.Mail;
import de.rcenvironment.core.mail.MailDispatchResult;
import de.rcenvironment.core.mail.MailDispatchResultListener;
import de.rcenvironment.core.mail.MailService;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MailCommandPlugin
implements CommandPlugin {
    private static final String PERM_FAILURE = "Unable to delivered the mail to the mail server. Most likely the SMTP server configuration is wrong: %s";
    private static final String CMD_MAIL = "mail";
    private static final StringParameter RECIPIENT_PARAMETER = new StringParameter(null, "recipient", "recipient of the e-mail");
    private static final StringParameter SUBJECT_PARAMETER = new StringParameter(null, "subject", "subject of the e-mail");
    private static final StringParameter BODY_PARAMETER = new StringParameter(null, "body", "body of the e-mail");
    private Log log = LogFactory.getLog(MailCommandPlugin.class);
    private MailService mailService;

    protected void bindMailService(MailService service) {
        this.mailService = service;
    }

    public MainCommandDescription[] getCommands() {
        MainCommandDescription commands = new MainCommandDescription(CMD_MAIL, "send an email", "send an email", this::performSendMail, new CommandModifierInfo(new AbstractCommandParameter[]{RECIPIENT_PARAMETER, SUBJECT_PARAMETER, BODY_PARAMETER}), new SubCommandDescription[0]);
        return new MainCommandDescription[]{commands};
    }

    private void performSendMail(final CommandContext context) throws CommandException {
        Mail validatedMail;
        if (!this.mailService.isConfigured()) {
            context.println((Object)"The SMTP mail server is not configured or invalid configured.");
            return;
        }
        ParsedCommandModifiers modifiers = context.getParsedModifiers();
        String recipient = ((ParsedStringParameter)modifiers.getPositionalCommandParameter(0)).getResult();
        String subject = ((ParsedStringParameter)modifiers.getPositionalCommandParameter(1)).getResult();
        String body = ((ParsedStringParameter)modifiers.getPositionalCommandParameter(2)).getResult();
        try {
            validatedMail = Mail.createMail(new String[]{recipient}, subject, body, null);
        }
        catch (InvalidMailException e) {
            throw CommandException.executionError((String)e.getMessage(), (CommandContext)context);
        }
        Future<?> sendMailFuture = this.mailService.sendMail(validatedMail, new MailDispatchResultListener(){

            @Override
            public void receiveResult(MailDispatchResult result, String message) {
                switch (result) {
                    case SUCCESS: {
                        context.println((Object)"Successfully delivered the mail to the mail server.");
                        break;
                    }
                    case FAILURE: {
                        context.println((Object)StringUtils.format((String)MailCommandPlugin.PERM_FAILURE, (Object[])new Object[]{message}));
                        break;
                    }
                    case FAILURE_RETRY: {
                        context.println((Object)"Unable to delivered the mail to the mail server. Retrying...");
                        break;
                    }
                    default: {
                        MailCommandPlugin.this.log.warn((Object)"Received unexpected result from the mail service.");
                    }
                }
            }
        });
        try {
            sendMailFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            this.log.error((Object)e);
            throw CommandException.executionError((String)e.getMessage(), (CommandContext)context);
        }
    }
}

