/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.mail.Address;
import javax.mail.internet.InternetAddress;
import jodd.mail.CommonEmail;
import jodd.mail.EmailAddress;
import jodd.mail.EmailAttachment;
import jodd.mail.EmailAttachmentBuilder;
import jodd.mail.EmailMessage;
import jodd.mail.MailAddress;

public class Email
extends CommonEmail {
    protected ArrayList<EmailAttachment> attachments;

    public static Email create() {
        return new Email();
    }

    public Email from(String from) {
        this.setFrom(new MailAddress(from));
        return this;
    }

    public Email from(String personal, String from) {
        this.setFrom(new MailAddress(personal, from));
        return this;
    }

    public Email from(EmailAddress emailAddress) {
        this.setFrom(new MailAddress(emailAddress));
        return this;
    }

    public Email from(InternetAddress internetAddress) {
        this.setFrom(new MailAddress(internetAddress));
        return this;
    }

    public Email to(String to) {
        this.addTo(new MailAddress(to));
        return this;
    }

    public Email to(String personalName, String to) {
        this.addTo(new MailAddress(personalName, to));
        return this;
    }

    public Email to(EmailAddress emailAddress) {
        this.addTo(new MailAddress(emailAddress));
        return this;
    }

    public Email to(InternetAddress internetAddress) {
        this.addTo(new MailAddress(internetAddress));
        return this;
    }

    public Email to(String[] tos) {
        this.setTo(MailAddress.createFrom(tos));
        return this;
    }

    public Email to(EmailAddress[] tos) {
        this.setTo(MailAddress.createFrom(tos));
        return this;
    }

    public Email to(InternetAddress[] tos) {
        this.setTo(MailAddress.createFrom((Address[])tos));
        return this;
    }

    public Email replyTo(String replyTo) {
        this.addReplyTo(new MailAddress(replyTo));
        return this;
    }

    public Email replyTo(String personalName, String replyTo) {
        this.addReplyTo(new MailAddress(personalName, replyTo));
        return this;
    }

    public Email replyTo(EmailAddress emailAddress) {
        this.addReplyTo(new MailAddress(emailAddress));
        return this;
    }

    public Email replyTo(InternetAddress internetAddress) {
        this.addReplyTo(new MailAddress(internetAddress));
        return this;
    }

    public Email replyTo(String[] replyTos) {
        this.setReplyTo(MailAddress.createFrom(replyTos));
        return this;
    }

    public Email replyTo(EmailAddress[] replyTos) {
        this.setReplyTo(MailAddress.createFrom(replyTos));
        return this;
    }

    public Email replyTo(InternetAddress[] replyTos) {
        this.setReplyTo(MailAddress.createFrom((Address[])replyTos));
        return this;
    }

    public Email cc(String cc) {
        this.addCc(new MailAddress(cc));
        return this;
    }

    public Email cc(String personalName, String cc) {
        this.addCc(new MailAddress(personalName, cc));
        return this;
    }

    public Email cc(EmailAddress emailAddress) {
        this.addCc(new MailAddress(emailAddress));
        return this;
    }

    public Email cc(InternetAddress internetAddress) {
        this.addCc(new MailAddress(internetAddress));
        return this;
    }

    public Email cc(String[] ccs) {
        this.setCc(MailAddress.createFrom(ccs));
        return this;
    }

    public Email cc(EmailAddress[] ccs) {
        this.setCc(MailAddress.createFrom(ccs));
        return this;
    }

    public Email cc(InternetAddress[] ccs) {
        this.setCc(MailAddress.createFrom((Address[])ccs));
        return this;
    }

    public Email bcc(String bcc) {
        this.addBcc(new MailAddress(bcc));
        return this;
    }

    public Email bcc(String personal, String bcc) {
        this.addBcc(new MailAddress(personal, bcc));
        return this;
    }

    public Email bcc(EmailAddress emailAddress) {
        this.addBcc(new MailAddress(emailAddress));
        return this;
    }

    public Email bcc(InternetAddress internetAddress) {
        this.addBcc(new MailAddress(internetAddress));
        return this;
    }

    public Email bcc(String[] bccs) {
        this.setBcc(MailAddress.createFrom(bccs));
        return this;
    }

    public Email bcc(EmailAddress[] bccs) {
        this.setBcc(MailAddress.createFrom(bccs));
        return this;
    }

    public Email bcc(InternetAddress[] bccs) {
        this.setBcc(MailAddress.createFrom((Address[])bccs));
        return this;
    }

    public Email subject(String subject) {
        this.setSubject(subject);
        return this;
    }

    public Email subject(String subject, String subjectEncoding) {
        this.setSubject(subject, subjectEncoding);
        return this;
    }

    public Email message(String text, String mimeType, String encoding) {
        this.addMessage(text, mimeType, encoding);
        return this;
    }

    public Email message(String text, String mimeType) {
        this.addMessage(text, mimeType);
        return this;
    }

    public Email addText(String text) {
        this.messages.add(new EmailMessage(text, "text/plain"));
        return this;
    }

    public Email addText(String text, String encoding) {
        this.messages.add(new EmailMessage(text, "text/plain", encoding));
        return this;
    }

    public Email addHtml(String message) {
        this.messages.add(new EmailMessage(message, "text/html"));
        return this;
    }

    public Email addHtml(String message, String encoding) {
        this.messages.add(new EmailMessage(message, "text/html", encoding));
        return this;
    }

    public List<EmailAttachment> getAttachments() {
        return this.attachments;
    }

    public Email attach(EmailAttachment emailAttachment) {
        if (this.attachments == null) {
            this.attachments = new ArrayList();
        }
        this.attachments.add(emailAttachment);
        return this;
    }

    public Email embed(EmailAttachment emailAttachment) {
        int size;
        this.attach(emailAttachment);
        if (emailAttachment.isInline() && (size = this.messages.size()) > 0) {
            emailAttachment.setEmbeddedMessage((EmailMessage)this.messages.get(size - 1));
        }
        return this;
    }

    public Email attach(EmailAttachmentBuilder emailAttachmentBuilder) {
        emailAttachmentBuilder.setInline(false);
        this.attach(emailAttachmentBuilder.create());
        return this;
    }

    public Email embed(EmailAttachmentBuilder emailAttachmentBuilder) {
        emailAttachmentBuilder.setInline(true);
        this.embed(emailAttachmentBuilder.create());
        return this;
    }

    public Email header(String name, String value) {
        this.setHeader(name, value);
        return this;
    }

    public Email priority(int priority) {
        super.setPriority(priority);
        return this;
    }

    public Email setCurrentSentDate() {
        this.sentDate = new Date();
        return this;
    }

    public Email sentOn(Date date) {
        this.setSentDate(date);
        return this;
    }

    public String toString() {
        return "Email{'" + this.from + "', subject='" + this.subject + "'}";
    }
}

